/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.commands;

import java.util.List;
import org.eclipse.buckminster.cmdline.Option;
import org.eclipse.buckminster.cmdline.OptionDescriptor;
import org.eclipse.buckminster.cmdline.UsageException;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.commands.PreferenceMappingManager;
import org.eclipse.buckminster.core.commands.WorkspaceCommand;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetPreference
extends WorkspaceCommand {
    private static final OptionDescriptor TEST_DESCRIPTOR = new OptionDescriptor(null, "__test", 1);
    private boolean m_test = false;
    private String[] m_assignments;

    protected void getOptionDescriptors(List<OptionDescriptor> appendHere) throws Exception {
        appendHere.add(TEST_DESCRIPTOR);
    }

    protected void handleOption(Option option) throws Exception {
        this.m_test = option.is(TEST_DESCRIPTOR);
    }

    protected void handleUnparsed(String[] unparsed) throws Exception {
        if (unparsed.length < 1) {
            throw new UsageException(Messages.You_must_provide_at_least_one_preference_assignment);
        }
        this.m_assignments = unparsed;
    }

    @Override
    protected int internalRun(IProgressMonitor monitor) throws Exception {
        PreferenceMappingManager prefManager = PreferenceMappingManager.getInstance(this.m_test);
        int idx = 0;
        while (idx < this.m_assignments.length) {
            String assignment = this.m_assignments[idx];
            int eqIdx = assignment.indexOf(61);
            if (eqIdx < 1 || eqIdx >= assignment.length() - 1) {
                throw new UsageException(NLS.bind((String)Messages._0_is_not_an_assignment, (Object)assignment));
            }
            String key = assignment.substring(0, eqIdx);
            String value = assignment.substring(eqIdx + 1);
            prefManager.getHandler(key).set(value);
            System.out.println(NLS.bind((String)Messages._0_set_to_the_value_1, (Object)key, (Object)value));
            ++idx;
        }
        return 0;
    }
}

