/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.commands;

import org.eclipse.buckminster.cmdline.AbstractCommand;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.helpers.JobBlocker;
import org.eclipse.buckminster.core.materializer.WorkspaceBindingInstallJob;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.internal.resources.DelayedSnapshotJob;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.utils.StringPoolJob;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public abstract class WorkspaceCommand
extends AbstractCommand {
    private boolean m_inWorkspace = false;

    private static void saveWorkspace(IProgressMonitor monitor) {
        monitor.beginTask(null, 300);
        try {
            IStatus saveStatus = ResourcesPlugin.getWorkspace().save(true, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100));
            if (saveStatus != null && !saveStatus.isOK()) {
                throw new ResourceException(saveStatus);
            }
        }
        catch (Throwable e) {
            Buckminster.getLogger().error(e, NLS.bind((String)Messages.Error_while_saving_workspace_0, (Object)e.getMessage()), new Object[0]);
        }
        monitor.done();
    }

    public boolean isInWorkspace() {
        return this.m_inWorkspace;
    }

    public void setInWorkspace(boolean inWorkspace) {
        this.m_inWorkspace = inWorkspace;
    }

    protected void initWorkspace(IProgressMonitor monitor) throws Exception {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription wsDesc = ws.getDescription();
        wsDesc.setAutoBuilding(false);
        wsDesc.setSnapshotInterval(Long.MAX_VALUE);
        ws.setDescription(wsDesc);
        WorkspaceCommand.saveWorkspace(monitor);
    }

    protected abstract int internalRun(IProgressMonitor var1) throws Exception;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final int run(IProgressMonitor monitor) throws Exception {
        int job3;
        int n;
        Job[] jobArray;
        IJobManager jobManager;
        Logger logger;
        Throwable throwable2;
        JobBlocker jobBlocker;
        block17: {
            int n2;
            monitor.beginTask(null, 1000);
            jobBlocker = new JobBlocker();
            jobBlocker.addClassBlock("org.eclipse.core.internal.events.AutoBuildJob");
            jobBlocker.addClassBlock("org.eclipse.jdt.internal.core.search.processing.JobManager$1$ProgressJob");
            try {
                if (!this.isInWorkspace()) {
                    this.initWorkspace(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
                }
                jobBlocker.addClassBlock(DelayedSnapshotJob.class);
                n2 = this.internalRun(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)900));
                if (this.isInWorkspace()) {
                    jobBlocker.release();
                    return n2;
                }
            }
            catch (Throwable throwable2) {
                if (this.isInWorkspace()) {
                    jobBlocker.release();
                    throw throwable2;
                }
                logger = CorePlugin.getLogger();
                logger.debug("Doing full workspace refresh", new Object[0]);
                try {
                    ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
                }
                catch (Throwable e) {
                    Buckminster.getLogger().error(NLS.bind((String)Messages.Error_while_refreshing_workspace_0, (Object)e.getMessage()), new Object[]{e});
                }
                jobManager = Job.getJobManager();
                jobManager.suspend();
                WorkspaceBindingInstallJob.stop();
                jobArray = jobManager.find(null);
                n = jobArray.length;
                job3 = 0;
                break block17;
            }
            Logger logger2 = CorePlugin.getLogger();
            logger2.debug("Doing full workspace refresh", new Object[0]);
            try {
                ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
            }
            catch (Throwable e) {
                Buckminster.getLogger().error(NLS.bind((String)Messages.Error_while_refreshing_workspace_0, (Object)e.getMessage()), new Object[]{e});
            }
            IJobManager jobManager2 = Job.getJobManager();
            jobManager2.suspend();
            WorkspaceBindingInstallJob.stop();
            Job[] jobArray2 = jobManager2.find(null);
            int n3 = jobArray2.length;
            int n4 = 0;
            while (true) {
                if (n4 >= n3) break;
                Job job2 = jobArray2[n4];
                if (job2 instanceof StringPoolJob) {
                    job2.cancel();
                }
                ++n4;
            }
            Thread joinWait = new Thread(jobManager2, logger2){
                private final /* synthetic */ IJobManager val$jobManager;
                private final /* synthetic */ Logger val$logger;
                {
                    this.val$jobManager = iJobManager;
                    this.val$logger = logger;
                }

                /*
                 * Unable to fully structure code
                 */
                public void run() {
                    block4: {
                        try {
                            this.val$jobManager.join(null, (IProgressMonitor)new NullProgressMonitor());
                            break block4;
                        }
                        catch (InterruptedException e) {
                            var5_2 = this.val$jobManager.find(null);
                            var4_3 = var5_2.length;
                            var3_4 = 0;
                            ** while (var3_4 < var4_3)
                        }
lbl-1000:
                        // 1 sources

                        {
                            job = var5_2[var3_4];
                            state = job.getState();
                            if (state == 4) {
                                this.val$logger.debug("  JOB: %s is still running", new Object[]{job.toString()});
                            }
                            ++var3_4;
                            continue;
                        }
                    }
                }
            };
            logger2.debug("Waiting for jobs to end", new Object[0]);
            joinWait.start();
            joinWait.join(30000L);
            joinWait.interrupt();
            Job[] jobArray3 = jobManager2.find(null);
            int n5 = jobArray3.length;
            n3 = 0;
            while (true) {
                if (n3 >= n5) {
                    jobBlocker.removeClassBlock(DelayedSnapshotJob.class);
                    jobManager2.resume();
                    WorkspaceCommand.saveWorkspace(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
                    monitor.done();
                    return n2;
                }
                Job job3 = jobArray3[n3];
                job3.cancel();
                ++n3;
            }
        }
        while (true) {
            if (job3 >= n) break;
            Job job4 = jobArray[job3];
            if (job4 instanceof StringPoolJob) {
                job4.cancel();
            }
            ++job3;
        }
        Thread joinWait = new /* invalid duplicate definition of identical inner class */;
        logger.debug("Waiting for jobs to end", new Object[0]);
        joinWait.start();
        joinWait.join(30000L);
        joinWait.interrupt();
        Job[] jobArray4 = jobManager.find(null);
        int n6 = jobArray4.length;
        n = 0;
        while (true) {
            if (n >= n6) {
                jobBlocker.removeClassBlock(DelayedSnapshotJob.class);
                jobManager.resume();
                WorkspaceCommand.saveWorkspace(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
                monitor.done();
                throw throwable2;
            }
            Job job5 = jobArray4[n];
            job5.cancel();
            ++n;
        }
    }
}

