/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.common.model;

import java.util.Map;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.common.model.ValueHolder;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyRef<T>
extends ValueHolder<T> {
    public static final String TAG = "propertyRef";
    public static final String ATTR_KEY = "key";
    private final Class<T> m_refClass;
    private final String m_key;

    public PropertyRef(Class<T> refClass, String key) {
        this.m_key = key;
        this.m_refClass = refClass;
    }

    @Override
    public T checkedGetValue(Map<String, ? extends Object> properties, int recursionGuard) {
        String expandedKey = ExpandingProperties.expand(properties, this.m_key, recursionGuard + 1);
        if (properties instanceof ExpandingProperties) {
            return this.m_refClass.cast(((ExpandingProperties)properties).getExpandedProperty(expandedKey, recursionGuard + 1));
        }
        Object replacementValue = properties.get(expandedKey);
        if (replacementValue == null) {
            CorePlugin.getLogger().warning(NLS.bind((String)Messages.The_property_0_has_not_been_set_and_will_default_to_null, (Object)this.m_key), new Object[0]);
        }
        return this.m_refClass.cast(ExpandingProperties.expand(properties, replacementValue, recursionGuard + 1));
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && Trivial.equalsAllowNull((Object)this.m_key, (Object)((PropertyRef)((Object)o)).m_key);
    }

    public String getDefaultTag() {
        return TAG;
    }

    @Override
    public int hashCode() {
        int hc = super.hashCode();
        hc = 37 * hc + (this.m_key == null ? 0 : this.m_key.hashCode());
        return hc;
    }

    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_KEY, (String)this.m_key);
    }
}

