/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.common.model.RxPart;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.buckminster.sax.AbstractSaxableElement;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RxAssembly
extends AbstractSaxableElement {
    public static final String TAG = "rxAssembly";
    public static final String ATTR_REPLACEMENT = "replacement";
    private final List<RxPart> m_parts;
    private final Pattern m_pattern;
    private final List<RxPart> m_parameters = new ArrayList<RxPart>();

    public RxAssembly(List<RxPart> parts) throws CoreException, PatternSyntaxException {
        this.m_parts = Utils.createUnmodifiableList(parts);
        StringBuilder bld = new StringBuilder();
        bld.append('^');
        for (RxPart part : parts) {
            part.addPattern(bld, this.m_parameters);
        }
        bld.append('$');
        String patternStr = bld.toString();
        this.m_pattern = Pattern.compile(patternStr);
        CorePlugin.getLogger().debug("URI pattern %s created", new Object[]{patternStr});
    }

    protected void emitElements(ContentHandler handler, String namespace, String prefix) throws SAXException {
        for (RxPart part : this.m_parts) {
            part.toSax(handler, namespace, prefix, part.getDefaultTag());
        }
    }

    public String getDefaultTag() {
        return TAG;
    }

    public Map<String, String> getMatchMap(CharSequence input) {
        if (input == null) {
            return null;
        }
        Logger logger = CorePlugin.getLogger();
        Matcher m = this.m_pattern.matcher(input);
        if (!m.matches()) {
            logger.debug("URI pattern does not match %s", new Object[]{input});
            return null;
        }
        int groupCount = m.groupCount();
        int top = this.m_parameters.size();
        if (logger.isDebugEnabled()) {
            logger.debug("URI pattern captured %d groups in %s", new Object[]{groupCount, input});
        }
        if (top != groupCount) {
            logger.warning(NLS.bind((String)Messages.URI_pattern_group_count_was_0_expected_1, (Object)groupCount, (Object)top), new Object[0]);
            top = groupCount;
        }
        if (top == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, String> matchMap = new HashMap<String, String>();
        int idx = 0;
        while (idx < top) {
            RxPart param = this.m_parameters.get(idx);
            String value = TextUtils.notEmptyString(m.group(idx + 1));
            if (value != null) {
                logger.debug("Assigning URI pattern parameter %s=\"%s\"", new Object[]{param.getName(), value});
                matchMap.put(param.getName(), value);
            }
            ++idx;
        }
        return matchMap;
    }

    public Pattern getPattern() {
        return this.m_pattern;
    }
}

