/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.common.parser;

import java.util.ArrayList;
import org.eclipse.buckminster.core.common.model.Flow;
import org.eclipse.buckminster.core.common.model.FlowWithAttributes;
import org.eclipse.buckminster.core.common.model.Text;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.buckminster.sax.ChildHandler;
import org.eclipse.buckminster.sax.ChildPoppedListener;
import org.eclipse.buckminster.sax.ISaxableElement;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class FlowHandler
extends ChildHandler
implements ChildPoppedListener {
    private static final ISaxableElement[] s_noChildren = new ISaxableElement[0];
    private final String m_localName;
    private String[] m_keyValuePairs;
    private ArrayList<ISaxableElement> m_elements;
    private StringBuilder m_text;

    protected FlowHandler(AbstractHandler parentHandler, String localName) {
        super(parentHandler);
        this.m_localName = localName;
    }

    private void addElement(ISaxableElement element) {
        if (this.m_elements == null) {
            this.m_elements = new ArrayList();
        }
        this.m_elements.add(element);
    }

    private void addTextIfAny() {
        if (this.m_text == null) {
            return;
        }
        int textLen = this.m_text.length();
        if (textLen == 0) {
            return;
        }
        char[] buf = new char[textLen];
        this.m_text.getChars(0, textLen, buf, 0);
        this.addElement(new Text(buf));
        this.m_text.setLength(0);
    }

    public void characters(char[] chars, int start, int length) throws SAXException {
        if (length == 0) {
            return;
        }
        if (this.m_text == null) {
            this.m_text = new StringBuilder();
        }
        this.m_text.append(chars, start, length);
    }

    public void childPopped(ChildHandler child) throws SAXException {
        this.addElement(((FlowHandler)child).createElement());
    }

    public Flow createElement() {
        this.addTextIfAny();
        ISaxableElement[] children = this.m_elements == null ? s_noChildren : this.m_elements.toArray(new ISaxableElement[this.m_elements.size()]);
        return this.createFlowElement(this.m_localName, this.m_keyValuePairs, children);
    }

    Flow createFlowElement(String localName, String[] keyValuePairs, ISaxableElement[] children) {
        return keyValuePairs.length == 0 ? new Flow(localName, children) : new FlowWithAttributes(localName, children, keyValuePairs);
    }

    public ChildHandler createHandler(String uri, String localName, Attributes attrs) throws SAXException {
        this.addTextIfAny();
        return new FlowHandler((AbstractHandler)this, localName);
    }

    public String getTAG() {
        return this.m_localName;
    }

    public void handleAttributes(Attributes attrs) {
        int numAttrs = attrs.getLength();
        if (this.m_elements != null) {
            this.m_elements.clear();
        }
        if (this.m_text != null) {
            this.m_text.setLength(0);
        }
        if (numAttrs > 0) {
            this.m_keyValuePairs = new String[numAttrs * 2];
            int idx = 0;
            while (idx < numAttrs) {
                int kaIdx = idx * 2;
                this.m_keyValuePairs[kaIdx] = attrs.getLocalName(idx);
                this.m_keyValuePairs[kaIdx + 1] = attrs.getValue(idx);
                ++idx;
            }
        } else {
            this.m_keyValuePairs = Trivial.EMPTY_STRING_ARRAY;
        }
    }
}

