/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.builder;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.buckminster.core.common.model.Documentation;
import org.eclipse.buckminster.core.cspec.IAttribute;
import org.eclipse.buckminster.core.cspec.ICSpecData;
import org.eclipse.buckminster.core.cspec.IComponentRequest;
import org.eclipse.buckminster.core.cspec.IGenerator;
import org.eclipse.buckminster.core.cspec.builder.ActionArtifactBuilder;
import org.eclipse.buckminster.core.cspec.builder.ActionBuilder;
import org.eclipse.buckminster.core.cspec.builder.ArtifactBuilder;
import org.eclipse.buckminster.core.cspec.builder.AttributeBuilder;
import org.eclipse.buckminster.core.cspec.builder.ComponentRequestBuilder;
import org.eclipse.buckminster.core.cspec.builder.GeneratorBuilder;
import org.eclipse.buckminster.core.cspec.builder.GroupBuilder;
import org.eclipse.buckminster.core.cspec.model.AttributeAlreadyDefinedException;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.cspec.model.DependencyAlreadyDefinedException;
import org.eclipse.buckminster.core.cspec.model.GeneratorAlreadyDefinedException;
import org.eclipse.buckminster.core.cspec.model.MissingAttributeException;
import org.eclipse.buckminster.core.cspec.model.MissingDependencyException;
import org.eclipse.buckminster.core.helpers.FilterUtils;
import org.eclipse.buckminster.core.version.IVersion;
import org.eclipse.buckminster.core.version.IVersionDesignator;
import org.eclipse.buckminster.core.version.VersionFactory;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.osgi.filter.FilterFactory;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.RequiredCapability;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSpecBuilder
implements ICSpecData {
    private static final String FEATURE_GROUP = ".feature.group";
    private HashMap<String, AttributeBuilder> m_attributes;
    private String m_componentType;
    private HashMap<String, ComponentRequestBuilder> m_dependencies;
    private Documentation m_documentation;
    private HashMap<String, GeneratorBuilder> m_generators;
    private String m_name;
    private URL m_projectInfo;
    private String m_shortDesc;
    private IVersion m_version;
    private Filter m_filter;

    public CSpecBuilder() {
    }

    public CSpecBuilder(IInstallableUnit iu) throws CoreException {
        String filterStr;
        String name = iu.getId();
        boolean isFeature = name.endsWith(FEATURE_GROUP);
        if (isFeature) {
            name = name.substring(0, name.length() - FEATURE_GROUP.length());
            this.setComponentTypeID("eclipse.feature");
        } else {
            this.setComponentTypeID("osgi.bundle");
        }
        this.setName(name);
        Version v = iu.getVersion();
        if (v != null) {
            this.setVersion(v.toString(), "OSGi");
        }
        if ((filterStr = iu.getFilter()) != null) {
            try {
                Filter filter = FilterFactory.newInstance((String)filterStr);
                filter = FilterUtils.replaceAttributeNames(filter, "osgi", "target");
                this.setFilter(filter);
            }
            catch (InvalidSyntaxException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
        RequiredCapability[] requiredCapabilityArray = iu.getRequiredCapabilities();
        int n = requiredCapabilityArray.length;
        int n2 = 0;
        while (n2 < n) {
            block15: {
                String ctype;
                RequiredCapability cap;
                block14: {
                    String namespace;
                    block12: {
                        block13: {
                            cap = requiredCapabilityArray[n2];
                            namespace = cap.getNamespace();
                            name = cap.getName();
                            if (!"org.eclipse.equinox.p2.iu".equals(namespace)) break block12;
                            if (!name.endsWith(FEATURE_GROUP)) break block13;
                            name = name.substring(0, name.length() - FEATURE_GROUP.length());
                            ctype = "eclipse.feature";
                            break block14;
                        }
                        if (!isFeature) break block15;
                        ctype = "osgi.bundle";
                        break block14;
                    }
                    if (!"osgi.bundle".equals(namespace)) break block15;
                    ctype = namespace;
                }
                ComponentRequestBuilder crb = new ComponentRequestBuilder();
                crb.setName(name);
                crb.setComponentTypeID(ctype);
                VersionRange vr = cap.getRange();
                if (vr != null) {
                    crb.setVersionDesignator(vr.toString(), "OSGi");
                }
                if ((filterStr = cap.getFilter()) != null) {
                    try {
                        Filter filter = FilterFactory.newInstance((String)filterStr);
                        filter = FilterUtils.replaceAttributeNames(filter, "osgi", "target");
                        crb.setFilter(filter);
                    }
                    catch (InvalidSyntaxException e) {
                        throw BuckminsterException.wrap((Throwable)e);
                    }
                }
                this.addDependency(crb);
            }
            ++n2;
        }
    }

    public ActionBuilder addAction(String actionName, boolean publ, String actorName, boolean always) throws AttributeAlreadyDefinedException {
        ActionBuilder bld = this.createActionBuilder();
        bld.setName(actionName);
        bld.setPublic(publ);
        bld.setActorName(actorName);
        bld.setAlways(always);
        this.addAttribute(bld);
        return bld;
    }

    public ArtifactBuilder addArtifact(String name, boolean publ, String type, IPath base) throws AttributeAlreadyDefinedException {
        ArtifactBuilder bld = this.createArtifactBuilder();
        bld.setName(name);
        bld.setPublic(publ);
        bld.setType(type);
        bld.setBase(base);
        this.addAttribute(bld);
        return bld;
    }

    public void addAttribute(IAttribute attribute) throws AttributeAlreadyDefinedException {
        String name = attribute.getName();
        if (this.m_attributes == null) {
            this.m_attributes = new HashMap();
        } else if (this.m_attributes.containsKey(name)) {
            throw new AttributeAlreadyDefinedException(this.m_name, name);
        }
        this.m_attributes.put(name, attribute.getAttributeBuilder(this));
    }

    public boolean addDependency(IComponentRequest dependency) throws CoreException {
        ComponentRequestBuilder bld;
        String name = dependency.getName();
        String depType = dependency.getComponentTypeID();
        if (dependency instanceof ComponentRequestBuilder) {
            bld = (ComponentRequestBuilder)dependency;
        } else {
            bld = this.createDependencyBuilder();
            bld.initFrom(dependency);
        }
        ComponentRequestBuilder old = this.getDependency(name, depType);
        if (old == null) {
            if (this.m_dependencies == null) {
                this.m_dependencies = new HashMap();
            }
            this.m_dependencies.put(name, bld);
            return true;
        }
        String oldType = old.getComponentTypeID();
        if (oldType != null && depType != null && !oldType.equals(depType)) {
            this.m_dependencies.remove(name);
            StringBuilder nameBld = new StringBuilder(name);
            nameBld.append("/!@@!/");
            int len = nameBld.length();
            nameBld.append(oldType);
            this.m_dependencies.put(nameBld.toString(), old);
            nameBld.setLength(len);
            nameBld.append(depType);
            this.m_dependencies.put(nameBld.toString(), bld);
            return true;
        }
        IVersionDesignator vd = old.getVersionDesignator();
        IVersionDesignator nvd = bld.getVersionDesignator();
        if (vd == null) {
            vd = nvd;
        } else if (nvd != null && (vd = vd.merge(nvd)) == null) {
            throw new DependencyAlreadyDefinedException(this.getName(), old.getName());
        }
        Filter fl = old.getFilter();
        Filter nfl = dependency.getFilter();
        if (fl == null || nfl == null) {
            fl = null;
        } else if (!fl.equals((Object)nfl)) {
            try {
                fl = FilterFactory.newInstance((String)("(|" + fl + nfl + ')'));
            }
            catch (InvalidSyntaxException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
        if (vd == old.getVersionDesignator() && fl == old.getFilter()) {
            return false;
        }
        if (oldType == null && depType != null) {
            old.setComponentTypeID(depType);
        }
        old.setVersionDesignator(vd);
        old.setFilter(fl);
        return false;
    }

    public void addGenerator(IGenerator generator) throws GeneratorAlreadyDefinedException {
        String name = generator.getGenerates();
        if (this.m_generators == null) {
            this.m_generators = new HashMap();
        } else if (this.m_generators.containsKey(name)) {
            throw new GeneratorAlreadyDefinedException(this.m_name, name);
        }
        GeneratorBuilder bld = this.createGeneratorBuilder();
        bld.initFrom(generator);
        this.m_generators.put(name, bld);
    }

    public GroupBuilder addGroup(String name, boolean publ) throws AttributeAlreadyDefinedException {
        GroupBuilder bld = this.createGroupBuilder();
        bld.setName(name);
        bld.setPublic(publ);
        this.addAttribute(bld);
        return bld;
    }

    public ActionBuilder addInternalAction(String actionName, boolean publ) throws AttributeAlreadyDefinedException {
        return this.addAction(actionName, publ, null, true);
    }

    public void clear() {
        this.m_name = null;
        this.m_componentType = null;
        this.m_version = null;
        this.m_filter = null;
        this.m_projectInfo = null;
        this.m_documentation = null;
        this.m_shortDesc = null;
        this.m_dependencies = null;
        this.m_attributes = null;
        this.m_generators = null;
    }

    public ActionArtifactBuilder createActionArtifactBuilder() {
        return new ActionArtifactBuilder(this);
    }

    public ActionBuilder createActionBuilder() {
        return new ActionBuilder(this);
    }

    public ArtifactBuilder createArtifactBuilder() {
        return new ArtifactBuilder(this);
    }

    public AttributeBuilder createAttributeBuilder() {
        return new AttributeBuilder(this);
    }

    public CSpec createCSpec() {
        return new CSpec(this);
    }

    public ComponentRequestBuilder createDependencyBuilder() {
        return new ComponentRequestBuilder();
    }

    public GeneratorBuilder createGeneratorBuilder() {
        return new GeneratorBuilder(this);
    }

    public GroupBuilder createGroupBuilder() {
        return new GroupBuilder(this);
    }

    public void finalWrapUp() {
        if (this.m_attributes != null && this.m_dependencies != null) {
            for (AttributeBuilder attr : this.m_attributes.values()) {
                if (attr instanceof GroupBuilder) {
                    ((GroupBuilder)attr).finalWrapUp(this.m_dependencies);
                    continue;
                }
                if (!(attr instanceof ActionBuilder)) continue;
                ((ActionBuilder)attr).getPrerequisitesBuilder().finalWrapUp(this.m_dependencies);
            }
        }
    }

    public ActionBuilder getActionBuilder(String name) {
        AttributeBuilder attr = this.m_attributes.get(name);
        return attr instanceof ActionBuilder ? (ActionBuilder)attr : null;
    }

    public Object getAdapter(Class adapterType) {
        if (CSpecBuilder.class.isAssignableFrom(adapterType)) {
            return this;
        }
        if (CSpec.class.isAssignableFrom(adapterType)) {
            return this.createCSpec();
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    public ArtifactBuilder getArtifactBuilder(String name) {
        AttributeBuilder attr = this.m_attributes.get(name);
        return attr instanceof ArtifactBuilder ? (ArtifactBuilder)attr : null;
    }

    @Override
    public AttributeBuilder getAttribute(String name) {
        return this.m_attributes == null ? null : this.m_attributes.get(name);
    }

    public Map<String, AttributeBuilder> getAttributes() {
        return this.m_attributes;
    }

    @Override
    public ComponentIdentifier getComponentIdentifier() {
        return new ComponentIdentifier(this.m_name, this.m_componentType, this.m_version);
    }

    @Override
    public String getComponentTypeID() {
        return this.m_componentType;
    }

    public Collection<ComponentRequestBuilder> getDependencies() {
        return this.m_dependencies == null ? Collections.emptyList() : this.m_dependencies.values();
    }

    @Override
    public ComponentRequestBuilder getDependency(String dependencyName, String componentType) throws MissingDependencyException {
        ComponentRequestBuilder dependency = null;
        if (this.m_dependencies != null && (dependency = this.m_dependencies.get(dependencyName)) == null && componentType != null) {
            dependency = this.m_dependencies.get(String.valueOf(dependencyName) + "/!@@!/" + componentType);
        }
        return dependency;
    }

    public Map<String, ComponentRequestBuilder> getDependencyMap() {
        return this.m_dependencies;
    }

    @Override
    public Documentation getDocumentation() {
        return this.m_documentation;
    }

    @Override
    public Filter getFilter() {
        return this.m_filter;
    }

    public GeneratorBuilder getGenerator(String generatorName) {
        return this.m_generators == null ? null : this.m_generators.get(generatorName);
    }

    public Map<String, GeneratorBuilder> getGenerators() {
        return this.m_generators;
    }

    public GroupBuilder getGroup(String name) {
        AttributeBuilder attr = this.m_attributes.get(name);
        return attr instanceof GroupBuilder ? (GroupBuilder)attr : null;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public URL getProjectInfo() {
        return this.m_projectInfo;
    }

    public ActionBuilder getRequiredAction(String name) throws MissingAttributeException {
        AttributeBuilder attr = this.m_attributes.get(name);
        if (attr instanceof ActionBuilder) {
            return (ActionBuilder)attr;
        }
        throw new MissingAttributeException(this.m_name, name);
    }

    public ArtifactBuilder getRequiredArtifact(String name) throws MissingAttributeException {
        AttributeBuilder attr = this.m_attributes.get(name);
        if (attr instanceof ArtifactBuilder) {
            return (ArtifactBuilder)attr;
        }
        throw new MissingAttributeException(this.m_name, name);
    }

    public AttributeBuilder getRequiredAttribute(String name) throws MissingAttributeException {
        AttributeBuilder attr = this.m_attributes.get(name);
        if (attr == null) {
            throw new MissingAttributeException(this.m_name, name);
        }
        return attr;
    }

    public ComponentRequestBuilder getRequiredDependency(String dependencyName, String componentType) throws MissingDependencyException {
        ComponentRequestBuilder dependency = this.getDependency(dependencyName, componentType);
        if (dependency == null) {
            throw new MissingDependencyException(this.m_name, dependencyName);
        }
        return dependency;
    }

    public GroupBuilder getRequiredGroup(String name) throws MissingAttributeException {
        AttributeBuilder attr = this.m_attributes.get(name);
        if (attr instanceof GroupBuilder) {
            return (GroupBuilder)attr;
        }
        throw new MissingAttributeException(this.m_name, name);
    }

    @Override
    public String getShortDesc() {
        return this.m_shortDesc;
    }

    public String getTagInfo(String parentInfo) {
        return CSpec.getTagInfo(this.getComponentIdentifier(), this.m_projectInfo, parentInfo);
    }

    @Override
    public IVersion getVersion() {
        return this.m_version;
    }

    public void initFrom(ICSpecData cspec) throws CoreException {
        this.m_name = cspec.getName();
        this.m_componentType = cspec.getComponentTypeID();
        this.m_version = cspec.getVersion();
        this.m_filter = cspec.getFilter();
        this.m_projectInfo = cspec.getProjectInfo();
        this.m_documentation = cspec.getDocumentation();
        this.m_shortDesc = cspec.getShortDesc();
        Map<String, ? extends IAttribute> attrs = cspec.getAttributes();
        if (attrs.size() > 0) {
            this.m_attributes = new HashMap(attrs.size());
            for (IAttribute iAttribute : attrs.values()) {
                this.m_attributes.put(iAttribute.getName(), iAttribute.getAttributeBuilder(this));
            }
        } else {
            this.m_attributes = null;
        }
        Collection<? extends IComponentRequest> collection = cspec.getDependencies();
        if (collection.size() > 0) {
            this.m_dependencies = new HashMap(collection.size());
            for (IComponentRequest iComponentRequest : collection) {
                this.addDependency(iComponentRequest);
            }
        } else {
            this.m_dependencies = null;
        }
        Map<String, ? extends IGenerator> map = cspec.getGenerators();
        if (map.size() > 0) {
            this.m_generators = new HashMap(map.size());
            for (IGenerator iGenerator : map.values()) {
                GeneratorBuilder gb = this.createGeneratorBuilder();
                gb.initFrom(iGenerator);
                this.m_generators.put(iGenerator.getGenerates(), gb);
            }
        } else {
            this.m_generators = null;
        }
    }

    public void removeAttribute(String name) {
        if (this.m_attributes != null) {
            this.m_attributes.remove(name);
        }
    }

    public void removeDependency(String name) {
        if (this.m_dependencies != null) {
            this.m_dependencies.remove(name);
        }
    }

    public void removeGenerator(String name) {
        if (this.m_generators != null) {
            this.m_generators.remove(name);
        }
    }

    public void setComponentTypeID(String componentType) {
        this.m_componentType = componentType;
    }

    public void setDocumentation(Documentation documentation) {
        this.m_documentation = documentation;
    }

    public void setFilter(Filter filter) {
        this.m_filter = filter;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setProjectInfo(URL projectInfo) {
        this.m_projectInfo = projectInfo;
    }

    public void setShortDesc(String shortDesc) {
        this.m_shortDesc = shortDesc;
    }

    public void setVersion(IVersion version) {
        this.m_version = version;
    }

    public void setVersion(String versionString, String versionTypeId) throws CoreException {
        if (versionString == null) {
            this.m_version = null;
            return;
        }
        if ((versionString = versionString.trim()).length() == 0) {
            this.m_version = null;
            return;
        }
        if (versionTypeId != null && (versionTypeId = versionTypeId.trim()).length() == 0) {
            versionTypeId = null;
        }
        this.m_version = VersionFactory.createVersion(versionTypeId, versionString);
    }
}

