/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.builder;

import org.eclipse.buckminster.core.cspec.IComponentIdentifier;
import org.eclipse.buckminster.core.cspec.IComponentRequest;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.version.IVersionDesignator;
import org.eclipse.buckminster.core.version.IVersionType;
import org.eclipse.buckminster.core.version.VersionFactory;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.core.runtime.CoreException;

public class ComponentRequestBuilder
implements IComponentRequest {
    private String m_name;
    private String m_componentType;
    private IVersionDesignator m_versionDesignator;
    private Filter m_filter;

    public void clear() {
        this.m_name = null;
        this.m_componentType = null;
        this.m_versionDesignator = null;
        this.m_filter = null;
    }

    public ComponentRequest createComponentRequest() {
        return new ComponentRequest(this);
    }

    public boolean designates(IComponentIdentifier id) {
        return !(!Trivial.equalsAllowNull((Object)this.getName(), (Object)id.getName()) || this.m_componentType != null && !this.m_componentType.equals(id.getComponentTypeID()) || this.m_versionDesignator != null && !this.m_versionDesignator.designates(id.getVersion()));
    }

    public String getComponentTypeID() {
        return this.m_componentType;
    }

    public Filter getFilter() {
        return this.m_filter;
    }

    public String getName() {
        return this.m_name;
    }

    public IVersionDesignator getVersionDesignator() {
        return this.m_versionDesignator;
    }

    public String getVersionDesignatorString() {
        return this.m_versionDesignator == null ? null : this.m_versionDesignator.toString();
    }

    public IVersionType getVersionType() {
        return this.m_versionDesignator == null ? null : this.m_versionDesignator.getVersion().getType();
    }

    public void initFrom(IComponentRequest request) {
        this.m_name = request.getName();
        this.m_componentType = request.getComponentTypeID();
        this.m_versionDesignator = request.getVersionDesignator();
        this.m_filter = request.getFilter();
    }

    public void setComponentTypeID(String componentType) {
        this.m_componentType = componentType;
    }

    public void setFilter(Filter filter) {
        this.m_filter = filter;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setVersionDesignator(IVersionDesignator designator) {
        this.m_versionDesignator = designator;
    }

    public void setVersionDesignator(String designatorStr, String versionType) throws CoreException {
        this.m_versionDesignator = designatorStr == null ? null : VersionFactory.createDesignator(versionType, designatorStr);
    }
}

