/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.buckminster.core.cspec.IAttribute;
import org.eclipse.buckminster.core.cspec.IGroup;
import org.eclipse.buckminster.core.cspec.IPrerequisite;
import org.eclipse.buckminster.core.cspec.builder.AttributeBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.builder.ComponentRequestBuilder;
import org.eclipse.buckminster.core.cspec.builder.PrerequisiteBuilder;
import org.eclipse.buckminster.core.cspec.builder.TopLevelAttributeBuilder;
import org.eclipse.buckminster.core.cspec.model.Group;
import org.eclipse.buckminster.core.cspec.model.Prerequisite;
import org.eclipse.buckminster.core.cspec.model.PrerequisiteAlreadyDefinedException;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupBuilder
extends TopLevelAttributeBuilder
implements IGroup {
    private final ArrayList<PrerequisiteBuilder> m_prerequisites = new ArrayList();
    private IPath m_rebase;

    public static int indexOfPrerequisite(List<? extends IPrerequisite> prerequisites, String prerequisiteKey) {
        int idx = prerequisites.size();
        while (--idx >= 0) {
            if (!prerequisites.get(idx).toString().equals(prerequisiteKey)) continue;
            return idx;
        }
        return -1;
    }

    GroupBuilder(CSpecBuilder cspecBuilder) {
        super(cspecBuilder);
    }

    @Override
    public void addPrerequisite(PrerequisiteBuilder prerequisite) throws PrerequisiteAlreadyDefinedException {
        String key = prerequisite.toString();
        if (GroupBuilder.indexOfPrerequisite(this.m_prerequisites, key) >= 0) {
            throw new PrerequisiteAlreadyDefinedException(this.getCSpecName(), this.getName(), key);
        }
        this.m_prerequisites.add(prerequisite);
    }

    public void addSelfRequirement() throws PrerequisiteAlreadyDefinedException {
        this.addLocalPrerequisite("buckminster.component.self");
    }

    @Override
    public void clear() {
        super.clear();
        this.m_prerequisites.clear();
        this.m_rebase = null;
    }

    @Override
    public Group createAttribute() {
        return new Group(this);
    }

    @Override
    public AttributeBuilder getAttributeBuilder(CSpecBuilder specBuilder) {
        return specBuilder == this.getCSpecBuilder() ? this : new GroupBuilder(specBuilder);
    }

    public PrerequisiteBuilder getPrerequisite(String prerequisteName) {
        int idx = GroupBuilder.indexOfPrerequisite(this.m_prerequisites, prerequisteName);
        return idx < 0 ? null : this.m_prerequisites.get(idx);
    }

    public List<Prerequisite> getPrerequisiteList() {
        int top;
        int n = top = this.m_prerequisites == null ? 0 : this.m_prerequisites.size();
        if (top == 0) {
            return Collections.emptyList();
        }
        ArrayList<Prerequisite> bld = new ArrayList<Prerequisite>(top);
        int idx = 0;
        while (idx < top) {
            bld.add(this.m_prerequisites.get(idx).createPrerequisite());
            ++idx;
        }
        return bld;
    }

    @Override
    public IPath getPrerequisiteRebase() {
        return this.m_rebase;
    }

    public List<PrerequisiteBuilder> getPrerequisites() {
        return this.m_prerequisites;
    }

    @Override
    public void initFrom(IAttribute attribute) {
        IGroup group = (IGroup)attribute;
        super.initFrom(group);
        for (IPrerequisite iPrerequisite : group.getPrerequisites()) {
            PrerequisiteBuilder pb = this.createPrerequisiteBuilder();
            pb.initFrom(iPrerequisite);
            this.m_prerequisites.add(pb);
        }
        this.m_rebase = group.getPrerequisiteRebase();
    }

    @Override
    public void removePrerequisite(String prerequisteName) {
        int idx = GroupBuilder.indexOfPrerequisite(this.m_prerequisites, prerequisteName);
        if (idx >= 0) {
            this.m_prerequisites.remove(idx);
        }
    }

    public void setPrerequisiteRebase(IPath rebase) {
        this.m_rebase = rebase == null ? null : rebase.addTrailingSeparator();
    }

    void finalWrapUp(Map<String, ComponentRequestBuilder> dependencies) {
        for (PrerequisiteBuilder pq : this.m_prerequisites) {
            pq.finalWrapUp(dependencies);
        }
    }
}

