/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.builder;

import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.buckminster.core.cspec.IPrerequisite;
import org.eclipse.buckminster.core.cspec.builder.AttributeBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecElementBuilder;
import org.eclipse.buckminster.core.cspec.builder.ComponentRequestBuilder;
import org.eclipse.buckminster.core.cspec.model.Prerequisite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrerequisiteBuilder
extends CSpecElementBuilder
implements IPrerequisite {
    private String m_alias;
    private final AttributeBuilder m_attributeBuilder;
    private String m_component;
    private String m_componentType;
    private boolean m_contributor = true;
    private Pattern m_excludePattern;
    private Pattern m_includePattern;
    private boolean m_optional = false;

    PrerequisiteBuilder(AttributeBuilder attributeBuilder) {
        super(attributeBuilder.getCSpecBuilder());
        this.m_attributeBuilder = attributeBuilder;
    }

    @Override
    public void clear() {
        super.clear();
        this.m_alias = null;
        this.m_component = null;
        this.m_componentType = null;
        this.m_contributor = true;
        this.m_optional = false;
        this.m_excludePattern = null;
        this.m_includePattern = null;
    }

    public Prerequisite createPrerequisite() {
        return new Prerequisite(this);
    }

    @Override
    public String getAlias() {
        return this.m_alias;
    }

    @Override
    public String getAttribute() {
        return this.getAttributeBuilder().getName();
    }

    public AttributeBuilder getAttributeBuilder() {
        return this.m_attributeBuilder;
    }

    @Override
    public String getComponentName() {
        return this.m_component;
    }

    @Override
    public String getComponentType() {
        return this.m_componentType;
    }

    @Override
    public Pattern getExcludePattern() {
        return this.m_excludePattern;
    }

    @Override
    public Pattern getIncludePattern() {
        return this.m_includePattern;
    }

    public void initFrom(IPrerequisite prerequisite) {
        super.initFrom(prerequisite.getName());
        this.m_alias = prerequisite.getAlias();
        this.m_component = prerequisite.getComponentName();
        this.m_componentType = prerequisite.getComponentType();
        this.m_optional = prerequisite.isOptional();
        this.m_contributor = prerequisite.isContributor();
        this.m_excludePattern = prerequisite.getExcludePattern();
        this.m_includePattern = prerequisite.getIncludePattern();
    }

    @Override
    public boolean isContributor() {
        return this.m_contributor;
    }

    @Override
    public boolean isExternal() {
        return this.m_component != null;
    }

    @Override
    public boolean isMatch(String component, String attribute) {
        return Prerequisite.isMatch(component, attribute, this.m_excludePattern, this.m_includePattern);
    }

    @Override
    public boolean isOptional() {
        return this.m_optional;
    }

    public void setAlias(String alias) {
        this.m_alias = alias;
    }

    public void setComponentName(String component) {
        this.m_component = component;
    }

    public void setComponentType(String type) {
        this.m_componentType = type;
    }

    public void setContributor(boolean contributor) {
        this.m_contributor = contributor;
    }

    public void setExcludePattern(Pattern excludePattern) {
        this.m_excludePattern = excludePattern;
    }

    public void setIncludePattern(Pattern includePattern) {
        this.m_includePattern = includePattern;
    }

    public void setOptional(boolean optional) {
        this.m_optional = optional;
    }

    public String toString() {
        if (this.m_component == null) {
            return this.getName();
        }
        StringBuilder bld = new StringBuilder();
        bld.append(this.m_component);
        if (this.m_componentType != null) {
            bld.append(':');
            bld.append(this.m_componentType);
        }
        bld.append('#');
        bld.append(this.getName());
        return bld.toString();
    }

    void finalWrapUp(Map<String, ComponentRequestBuilder> dependencies) {
        if (this.m_componentType != null && dependencies.containsKey(this.m_component)) {
            this.m_componentType = null;
        }
    }
}

