/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.builder;

import java.util.Map;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.cspec.IAttribute;
import org.eclipse.buckminster.core.cspec.IPrerequisite;
import org.eclipse.buckminster.core.cspec.builder.AttributeBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.builder.PrerequisiteBuilder;
import org.eclipse.buckminster.core.cspec.model.Attribute;
import org.eclipse.buckminster.core.cspec.model.PrerequisiteAlreadyDefinedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TopLevelAttributeBuilder
extends AttributeBuilder {
    private ExpandingProperties<String> m_installerHints = null;
    private boolean m_public = false;

    TopLevelAttributeBuilder(CSpecBuilder cspecBuilder) {
        super(cspecBuilder);
    }

    public final void addExternalPrerequisite(String name, String type, String attr) throws PrerequisiteAlreadyDefinedException {
        this.addPrerequisite(this.createPrerequisite(name, type, attr, null));
    }

    public void addInstallerHint(String key, String hint) {
        this.getInstallerHintsForAdd().put(key, hint, false);
    }

    public void addInstallerHint(String key, String hint, boolean mutable) {
        this.getInstallerHintsForAdd().put(key, hint, mutable);
    }

    public void addInstallerHints(Map<String, String> hints) {
        if (hints != null && hints.size() > 0) {
            this.getInstallerHintsForAdd().putAll(hints, true);
        }
    }

    public final void addLocalPrerequisite(AttributeBuilder attr) throws PrerequisiteAlreadyDefinedException {
        this.addLocalPrerequisite(attr.getName());
    }

    public final void addLocalPrerequisite(String attr) throws PrerequisiteAlreadyDefinedException {
        this.addPrerequisite(this.createPrerequisite(null, null, attr, null));
    }

    public final void addLocalPrerequisite(String attr, String alias) throws PrerequisiteAlreadyDefinedException {
        this.addPrerequisite(this.createPrerequisite(null, null, attr, alias));
    }

    public void addPrerequisite(PrerequisiteBuilder prerequisite) throws PrerequisiteAlreadyDefinedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        super.clear();
        this.m_installerHints = null;
        this.m_public = false;
    }

    @Override
    public abstract Attribute createAttribute();

    public PrerequisiteBuilder createPrerequisiteBuilder() {
        return new PrerequisiteBuilder(this);
    }

    @Override
    public Map<String, String> getInstallerHints() {
        return this.m_installerHints;
    }

    public ExpandingProperties<String> getInstallerHintsForAdd() {
        if (this.m_installerHints == null) {
            this.m_installerHints = new ExpandingProperties();
        }
        return this.m_installerHints;
    }

    @Override
    public void initFrom(IAttribute attribute) {
        super.initFrom(attribute);
        this.m_installerHints = null;
        this.m_public = attribute.isPublic();
        this.addInstallerHints(attribute.getInstallerHints());
    }

    @Override
    public boolean isPublic() {
        return this.m_public;
    }

    public void removePrerequisite(IPrerequisite pq) {
        this.removePrerequisite(pq.toString());
    }

    public void removePrerequisite(String prerequisiteName) {
        throw new UnsupportedOperationException();
    }

    public void setPublic(boolean flag) {
        this.m_public = flag;
    }

    private PrerequisiteBuilder createPrerequisite(String component, String type, String name, String alias) {
        PrerequisiteBuilder bld = this.createPrerequisiteBuilder();
        bld.setComponentName(component);
        bld.setComponentType(type);
        bld.setName(name);
        bld.setAlias(alias);
        return bld;
    }
}

