/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.common.model.SAXEmitter;
import org.eclipse.buckminster.core.cspec.IAction;
import org.eclipse.buckminster.core.cspec.IAttribute;
import org.eclipse.buckminster.core.cspec.IAttributeFilter;
import org.eclipse.buckminster.core.cspec.PathGroup;
import org.eclipse.buckminster.core.cspec.SaxablePath;
import org.eclipse.buckminster.core.cspec.builder.ActionBuilder;
import org.eclipse.buckminster.core.cspec.builder.AttributeBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.model.ActionArtifact;
import org.eclipse.buckminster.core.cspec.model.Artifact;
import org.eclipse.buckminster.core.cspec.model.Attribute;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.Group;
import org.eclipse.buckminster.core.cspec.model.Prerequisite;
import org.eclipse.buckminster.core.cspec.model.Prerequisites;
import org.eclipse.buckminster.core.cspec.model.TopLevelAttribute;
import org.eclipse.buckminster.core.cspec.model.UpToDatePolicy;
import org.eclipse.buckminster.core.internal.actor.ActorFactory;
import org.eclipse.buckminster.core.internal.actor.PerformManager;
import org.eclipse.buckminster.core.metadata.model.IModelCache;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.buckminster.sax.ISaxableElement;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Action
extends TopLevelAttribute
implements IAction {
    public static final String ATTR_ACTOR = "actor";
    public static final String ATTR_ALWAYS = "always";
    public static final String ATTR_ASSIGN_CONSOLE_SUPPORT = "assignConsoleSupport";
    public static final String ATTR_PRODUCT_FILE_COUNT = "fileCount";
    public static final String ATTR_UP_TO_DATE_POLICY = "upToDatePolicy";
    public static final String ELEM_ACTOR_PROPERTIES = "actorProperties";
    public static final String ELEM_PROPERTIES = "properties";
    public static final String ELEM_PRODUCTS = "products";
    public static final boolean ALWAYS_DEFAULT = false;
    public static final boolean ASSIGN_CONSOLE_SUPPORT_DEFAULT = true;
    private final Set<IPath> m_products;
    private final String m_productAlias;
    private final IPath m_productBase;
    private final String m_actorName;
    private final boolean m_always;
    private final int m_productFileCount;
    private final Map<String, String> m_actorProperties;
    private final Map<String, String> m_properties;
    private final boolean m_assignConsoleSupport;
    private final UpToDatePolicy m_upToDatePolicy;
    private Prerequisites m_prerequisites;
    public static final String BINDING_NAME = "binding.name";

    public Action(ActionBuilder builder) {
        super(builder);
        this.m_actorName = builder.getActorName();
        this.m_prerequisites = new Prerequisites(this, builder.getPrerequisitesBuilder());
        this.m_always = builder.isAlways();
        this.m_assignConsoleSupport = builder.isAssignConsoleSupport();
        this.m_productAlias = builder.getProductAlias();
        this.m_productBase = builder.getProductBase();
        this.m_productFileCount = builder.getProductFileCount();
        this.m_products = CSpec.createUnmodifiablePaths(builder.getProductPaths());
        this.m_actorProperties = ExpandingProperties.createUnmodifiableProperties(builder.getActorProperties());
        this.m_properties = ExpandingProperties.createUnmodifiableProperties(builder.getProperties());
        this.m_upToDatePolicy = builder.getUpToDatePolicy();
    }

    public void addInstallerHints(IModelCache ctx, Map<String, String> installerHints) throws CoreException {
        CSpec cspec = this.getCSpec();
        Stack<IAttributeFilter> filters = null;
        for (Prerequisite prereq : this.getPrerequisites(null)) {
            Attribute ag = prereq.getReferencedAttribute(cspec, ctx);
            if (!(ag instanceof TopLevelAttribute)) continue;
            if (prereq.isPatternFilter()) {
                if (filters == null) {
                    filters = new Stack<IAttributeFilter>();
                }
                filters.push(prereq);
                ((TopLevelAttribute)ag).getDeepInstallerHints(ctx, installerHints, filters);
                filters.pop();
                continue;
            }
            ((TopLevelAttribute)ag).getDeepInstallerHints(ctx, installerHints, filters);
        }
    }

    @Override
    public IAttribute copy() {
        Action copy = (Action)super.copy();
        copy.m_prerequisites = (Prerequisites)copy.m_prerequisites.copy();
        return copy;
    }

    @Override
    public String getActorName() {
        try {
            return this.isInternal() ? ActorFactory.getInstance().findInternalActionActorName(this.getName()) : this.m_actorName;
        }
        catch (CoreException ce) {
            throw new RuntimeException(ce);
        }
    }

    @Override
    public Map<String, String> getActorProperties() {
        return this.m_actorProperties;
    }

    public String getBindingName(Map<String, ? extends Object> globalProps) {
        Map<String, String> actionProps = this.getProperties();
        if (actionProps.containsKey(BINDING_NAME)) {
            ExpandingProperties<? extends Object> allProps = new ExpandingProperties<Object>(globalProps);
            allProps.putAll((Map<String, ? extends Object>)actionProps);
            return (String)allProps.get(BINDING_NAME);
        }
        return null;
    }

    public IPath getExpandedBase(IPath productBase, Map<String, ? extends Object> local) {
        if (productBase == null) {
            return this.getExpandedDefaultBase(local);
        }
        if (!(productBase = PerformManager.expandPath(local, productBase)).isAbsolute()) {
            productBase = this.getExpandedDefaultBase(local).append(productBase);
        }
        return productBase;
    }

    public IPath getExpandedDefaultBase(Map<String, ? extends Object> local) {
        return PerformManager.expandPath(local, Path.fromPortableString((String)"${buckminster.output}"));
    }

    @Override
    public Group getPrerequisiteGroup() {
        return this.m_prerequisites;
    }

    public IPath getPrerequisiteRebase() {
        return this.m_prerequisites.getPrerequisiteRebase();
    }

    @Override
    public List<Prerequisite> getPrerequisites(Stack<IAttributeFilter> filters) {
        return this.m_prerequisites.getPrerequisites(filters);
    }

    public String getPrerequisitesAlias() {
        return this.m_prerequisites.getName();
    }

    @Override
    public String getProductAlias() {
        return this.m_productAlias;
    }

    public List<ActionArtifact> getProductArtifacts() {
        return this.getCSpec().getActionArtifacts(this);
    }

    @Override
    public IPath getProductBase() {
        return this.m_productBase;
    }

    @Override
    public int getProductFileCount() {
        return this.m_productFileCount;
    }

    @Override
    public Set<IPath> getProductPaths() {
        return this.m_products;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.m_properties;
    }

    @Override
    public UpToDatePolicy getUpToDatePolicy() {
        return this.m_upToDatePolicy;
    }

    @Override
    public final boolean isAlways() {
        return this.m_always;
    }

    @Override
    public boolean isAssignConsoleSupport() {
        return this.m_assignConsoleSupport;
    }

    @Override
    public final boolean isInternal() {
        return this.m_actorName == null;
    }

    @Override
    public boolean isProducedByActions(IModelCache ctx) {
        return true;
    }

    public boolean isUpToDate(IModelCache ctx) throws CoreException {
        int expectedFileCount;
        Logger logger = CorePlugin.getLogger();
        String failLeadIn = "";
        boolean isDebug = logger.isDebugEnabled();
        if (isDebug) {
            failLeadIn = String.format("Action %s using 'up to date' policy %s: Rebuild needed: ", new Object[]{this, this.m_upToDatePolicy});
        }
        if (this.m_upToDatePolicy == UpToDatePolicy.ACTOR) {
            if (ActorFactory.getInstance().getActor(this).isUpToDate(this, ctx)) {
                return true;
            }
            if (isDebug) {
                logger.debug("%sActor decision", new Object[]{failLeadIn});
            }
            return false;
        }
        if (this.m_upToDatePolicy == UpToDatePolicy.MAPPER) {
            Map<String, Long> prereqFiles = this.getPrerequisiteRelativeFiles(ctx);
            Map<String, Long> productFiles = this.getProductRelativeFiles(ctx);
            int expectedFileCount2 = prereqFiles.size();
            if (this.m_productFileCount > 0) {
                expectedFileCount2 += this.m_productFileCount;
            }
            if (productFiles.size() < expectedFileCount2) {
                if (isDebug) {
                    logger.debug("%sFile count(%d) < expected(%d)", new Object[]{failLeadIn, productFiles.size(), expectedFileCount2});
                }
                return false;
            }
            for (Map.Entry<String, Long> entry : prereqFiles.entrySet()) {
                Long tsObj = productFiles.get(entry.getKey());
                if (tsObj == null) {
                    if (isDebug) {
                        logger.debug(String.format("%sNo product is matching requirement %s", failLeadIn, entry.getKey()), new Object[0]);
                    }
                    return false;
                }
                long productTs = tsObj;
                long prereqTs = entry.getValue();
                if (prereqTs <= productTs) continue;
                if (isDebug) {
                    logger.debug(String.format("%sThe product for %s of age %s is older then its matching requirement with age %s", failLeadIn, entry.getKey(), new Date(productTs), new Date(prereqTs)), new Object[0]);
                }
                return false;
            }
            if (isDebug) {
                logger.debug(String.format("Action %s using 'up to date' policy %s: Product is up to date", new Object[]{this, this.m_upToDatePolicy}), new Object[0]);
            }
            return true;
        }
        switch (this.m_upToDatePolicy) {
            case COUNT: {
                expectedFileCount = this.m_productFileCount;
                break;
            }
            case NOT_EMPTY: {
                expectedFileCount = 0;
                break;
            }
            default: {
                expectedFileCount = -1;
            }
        }
        int[] fileCountBin = new int[1];
        long oldest = this.getFirstModified(ctx, expectedFileCount, fileCountBin);
        int fileCount = fileCountBin[0];
        if (oldest == 0L || expectedFileCount > 0 && expectedFileCount > fileCount) {
            if (isDebug) {
                switch (this.m_upToDatePolicy) {
                    case DEFAULT: {
                        logger.debug(String.format("%sProduct has folders", failLeadIn), new Object[0]);
                        break;
                    }
                    case NOT_EMPTY: {
                        logger.debug(String.format("%sProduct is empty", failLeadIn), new Object[0]);
                        break;
                    }
                    default: {
                        logger.debug(String.format("%sFile count(%d) < expected(%d)", failLeadIn, fileCountBin[0], expectedFileCount), new Object[0]);
                    }
                }
            }
            return false;
        }
        fileCountBin[0] = 0;
        long prereqAge = this.getPrerequisiteGroup().getLastModified(ctx, oldest, fileCountBin);
        if (oldest >= prereqAge) {
            if (isDebug) {
                logger.debug(String.format("Action %s using 'up to date' policy %s: Product is up to date", new Object[]{this, this.m_upToDatePolicy}), new Object[0]);
            }
            return true;
        }
        if (isDebug) {
            logger.debug(String.format("%s: Product of age %s is older then prerequisite of age %s", failLeadIn, new Date(oldest), new Date(prereqAge)), new Object[0]);
        }
        return false;
    }

    @Override
    protected void addAttributes(AttributesImpl attrs) {
        super.addAttributes(attrs);
        if (this.m_actorName != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_ACTOR, (String)this.m_actorName);
        }
        if (this.m_always) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_ALWAYS, (String)Boolean.toString(this.m_always));
        }
        if (!this.m_assignConsoleSupport) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_ASSIGN_CONSOLE_SUPPORT, (String)Boolean.toString(this.m_assignConsoleSupport));
        }
    }

    @Override
    protected AttributeBuilder createAttributeBuilder(CSpecBuilder cspecBuilder) {
        return cspecBuilder.createActionBuilder();
    }

    @Override
    protected void emitElements(ContentHandler handler, String namespace, String prefix) throws SAXException {
        String qName;
        super.emitElements(handler, namespace, prefix);
        if (!this.m_actorProperties.isEmpty()) {
            qName = Utils.makeQualifiedName((String)prefix, (String)ELEM_ACTOR_PROPERTIES);
            handler.startElement(namespace, ELEM_ACTOR_PROPERTIES, qName, ISaxableElement.EMPTY_ATTRIBUTES);
            SAXEmitter.emitProperties(handler, this.m_actorProperties, namespace, prefix, true, false);
            handler.endElement(namespace, ELEM_ACTOR_PROPERTIES, qName);
        }
        if (!this.m_properties.isEmpty()) {
            qName = Utils.makeQualifiedName((String)prefix, (String)ELEM_PROPERTIES);
            handler.startElement(namespace, ELEM_PROPERTIES, qName, ISaxableElement.EMPTY_ATTRIBUTES);
            SAXEmitter.emitProperties(handler, this.m_properties, namespace, prefix, true, false);
            handler.endElement(namespace, ELEM_PROPERTIES, qName);
        }
        if (this.m_prerequisites.getPrerequisites().size() > 0) {
            this.m_prerequisites.toSax(handler, namespace, prefix, this.m_prerequisites.getDefaultTag());
        }
        AttributesImpl attrs = new AttributesImpl();
        if (this.m_productAlias != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)"alias", (String)this.m_productAlias);
        }
        if (this.m_productBase != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)"base", (String)this.m_productBase.toPortableString());
        }
        if (this.m_productFileCount >= 0) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_PRODUCT_FILE_COUNT, (String)Integer.toString(this.m_productFileCount));
        }
        if (this.m_upToDatePolicy != UpToDatePolicy.DEFAULT) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_UP_TO_DATE_POLICY, (String)this.m_upToDatePolicy.name());
        }
        ArrayList<Object> allProds = new ArrayList<Object>();
        for (IPath path : this.m_products) {
            allProds.add((Object)((SaxablePath)path));
        }
        allProds.addAll(this.getCSpec().getActionArtifacts(this));
        Utils.emitCollection((String)namespace, (String)prefix, (String)ELEM_PRODUCTS, null, (Attributes)attrs, allProds, (ContentHandler)handler);
    }

    @Override
    protected PathGroup[] internalGetPathGroups(IModelCache ctx, Map<String, ? extends Object> local, Stack<IAttributeFilter> filters) throws CoreException {
        CSpec cspec = this.getCSpec();
        ArrayList<PathGroup> pathGroups = new ArrayList<PathGroup>();
        int numProducts = this.m_products.size();
        if (this.m_productBase != null || numProducts > 0) {
            IPath iPath = this.getExpandedBase(this.m_productBase, local);
            IPath[] pathArr = this.m_products.toArray(new IPath[numProducts]);
            while (--numProducts >= 0) {
                pathArr[numProducts] = PerformManager.expandPath(local, pathArr[numProducts]);
            }
            pathGroups.add(new PathGroup(iPath, pathArr));
        }
        for (Artifact artifact : cspec.getActionArtifacts(this)) {
            PathGroup[] pathGroupArray = artifact.getPathGroups(ctx, filters);
            int n = pathGroupArray.length;
            int n2 = 0;
            while (n2 < n) {
                PathGroup pathGroup = pathGroupArray[n2];
                pathGroups.add(pathGroup);
                ++n2;
            }
        }
        return pathGroups.toArray(new PathGroup[pathGroups.size()]);
    }

    @Override
    void setCSPec(CSpec cspec) {
        super.setCSPec(cspec);
        this.m_prerequisites.setCSPec(cspec);
    }

    private Map<String, Long> getPrerequisiteRelativeFiles(IModelCache ctx) throws CoreException {
        HashMap<String, Long> filesAndDates = new HashMap<String, Long>();
        CSpec cspec = this.getCSpec();
        for (Prerequisite pq : this.getPrerequisites(null)) {
            Attribute ag;
            if (!pq.isContributor() || !((ag = pq.getReferencedAttribute(cspec, ctx)) instanceof TopLevelAttribute)) continue;
            ((TopLevelAttribute)ag).appendRelativeFiles(ctx, filesAndDates);
        }
        return filesAndDates;
    }

    private Map<String, Long> getProductRelativeFiles(IModelCache ctx) throws CoreException {
        HashMap<String, Long> filesAndDates = new HashMap<String, Long>();
        this.appendRelativeFiles(ctx, filesAndDates);
        return filesAndDates;
    }
}

