/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.UUID;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.common.model.Documentation;
import org.eclipse.buckminster.core.cspec.IAction;
import org.eclipse.buckminster.core.cspec.IActionArtifact;
import org.eclipse.buckminster.core.cspec.IAttribute;
import org.eclipse.buckminster.core.cspec.IAttributeFilter;
import org.eclipse.buckminster.core.cspec.ICSpecData;
import org.eclipse.buckminster.core.cspec.IComponentIdentifier;
import org.eclipse.buckminster.core.cspec.IGenerator;
import org.eclipse.buckminster.core.cspec.IGroup;
import org.eclipse.buckminster.core.cspec.IPrerequisite;
import org.eclipse.buckminster.core.cspec.PathGroup;
import org.eclipse.buckminster.core.cspec.QualifiedDependency;
import org.eclipse.buckminster.core.cspec.SaxablePath;
import org.eclipse.buckminster.core.cspec.WellknownActions;
import org.eclipse.buckminster.core.cspec.builder.AttributeBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.builder.ComponentRequestBuilder;
import org.eclipse.buckminster.core.cspec.builder.GeneratorBuilder;
import org.eclipse.buckminster.core.cspec.model.Action;
import org.eclipse.buckminster.core.cspec.model.ActionArtifact;
import org.eclipse.buckminster.core.cspec.model.Attribute;
import org.eclipse.buckminster.core.cspec.model.CircularReferenceException;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.cspec.model.Generator;
import org.eclipse.buckminster.core.cspec.model.MissingAttributeException;
import org.eclipse.buckminster.core.cspec.model.MissingDependencyException;
import org.eclipse.buckminster.core.cspec.model.Prerequisite;
import org.eclipse.buckminster.core.cspec.model.TopLevelAttribute;
import org.eclipse.buckminster.core.metadata.ModelCache;
import org.eclipse.buckminster.core.metadata.ReferentialIntegrityException;
import org.eclipse.buckminster.core.metadata.StorageManager;
import org.eclipse.buckminster.core.metadata.WorkspaceInfo;
import org.eclipse.buckminster.core.metadata.model.IModelCache;
import org.eclipse.buckminster.core.metadata.model.IUUIDPersisted;
import org.eclipse.buckminster.core.version.IVersion;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.buckminster.sax.UUIDKeyed;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSpec
extends UUIDKeyed
implements IUUIDPersisted,
ICSpecData {
    public static final String ATTR_FILTER = "filter";
    public static final String ATTR_PROJECT_INFO = "projectInfo";
    public static final String ATTR_SHORT_DESC = "shortDesc";
    public static final String ELEM_ACTIONS = "actions";
    public static final String ELEM_ARTIFACTS = "artifacts";
    public static final String ELEM_DEPENDENCIES = "dependencies";
    public static final String ELEM_GENERATORS = "generators";
    public static final String ELEM_DEPENDENCY = "dependency";
    public static final String ELEM_GROUPS = "groups";
    public static final String SELF_ARTIFACT = "buckminster.component.self";
    public static final String TAG = "cspec";
    public static final String COMPONENT_NAME_TYPE_SEPARATOR = "/!@@!/";
    public static final int SEQUENCE_NUMBER = 4;
    private static final Comparator<Attribute> s_attributeSorter = new Comparator<Attribute>(){

        @Override
        public int compare(Attribute o1, Attribute o2) {
            if (o1.isPublic() == o2.isPublic()) {
                return o1.getName().compareTo(o2.getName());
            }
            return o1.isPublic() ? -1 : 1;
        }
    };
    private final Map<String, Attribute> m_attributes;
    private final ComponentIdentifier m_componentIdentifier;
    private final Map<String, ComponentRequest> m_dependencies;
    private final Map<String, Generator> m_generators;
    private final Documentation m_documentation;
    private final String m_shortDesc;
    private final Attribute m_selfAttribute;
    private final Filter m_filter;
    private final URL m_projectInfo;

    public static Set<IPath> createUnmodifiablePaths(Set<IPath> aSet) {
        if (aSet == null || aSet.size() == 0) {
            aSet = Collections.emptySet();
        } else {
            HashSet<SaxablePath> saxablePaths = new HashSet<SaxablePath>();
            for (IPath path : aSet) {
                saxablePaths.add(SaxablePath.coerce(path));
            }
            aSet = Collections.unmodifiableSet(saxablePaths);
        }
        return aSet;
    }

    public static String getTagInfo(IComponentIdentifier ci, URL projectInfoURL, String parentInfo) {
        String path = null;
        String projectInfo = null;
        if (parentInfo != null) {
            int pathIdx = parentInfo.indexOf("path: ");
            if (pathIdx >= 0) {
                path = String.format("%s -> %s", parentInfo.substring(pathIdx), ci);
            }
            if (projectInfoURL == null && parentInfo.startsWith("project: ")) {
                projectInfo = parentInfo.substring(0, pathIdx - 2);
            }
        }
        if (projectInfoURL != null) {
            projectInfo = String.format("project: %s", projectInfoURL);
        }
        if (path == null) {
            path = String.format("path: %s", ci.toString());
        }
        String tagInfo = projectInfo == null ? path : String.format("%s, %s", projectInfo, path);
        return tagInfo;
    }

    /*
     * WARNING - void declaration
     */
    public CSpec(CSpecBuilder cspecBld) {
        int top;
        cspecBld.finalWrapUp();
        this.m_componentIdentifier = cspecBld.getComponentIdentifier();
        this.m_projectInfo = cspecBld.getProjectInfo();
        this.m_documentation = cspecBld.getDocumentation();
        this.m_shortDesc = cspecBld.getShortDesc();
        this.m_filter = cspecBld.getFilter();
        this.m_selfAttribute = new TopLevelAttribute(SELF_ARTIFACT){

            @Override
            protected AttributeBuilder createAttributeBuilder(CSpecBuilder cspecBuilder) {
                return null;
            }

            @Override
            protected PathGroup[] internalGetPathGroups(IModelCache ctx, Map<String, ? extends Object> local, Stack<IAttributeFilter> filters) throws CoreException {
                IPath me = CSpec.this.getComponentLocation();
                PathGroup meGroup = me.hasTrailingSeparator() ? new PathGroup(me, Trivial.EMPTY_PATH_ARRAY) : new PathGroup(me.removeLastSegments(1).addTrailingSeparator(), new IPath[]{new Path(me.lastSegment())});
                return new PathGroup[]{meGroup};
            }
        };
        this.m_selfAttribute.setCSPec(this);
        Map<String, AttributeBuilder> attributes = cspecBld.getAttributes();
        int n = top = attributes == null ? 0 : attributes.size();
        if (top == 0) {
            this.m_attributes = Collections.emptyMap();
        } else {
            Map<Object, Object> map;
            Collection<AttributeBuilder> values = attributes.values();
            if (top == 1) {
                Attribute attribute = values.iterator().next().createAttribute();
                attribute.setCSPec(this);
                map = Collections.singletonMap(attribute.getName(), attribute);
            } else {
                map = new HashMap(top);
                for (AttributeBuilder attributeBuilder : values) {
                    Attribute attr = attributeBuilder.createAttribute();
                    attr.setCSPec(this);
                    map.put(attr.getName(), attr);
                }
            }
            this.m_attributes = Collections.unmodifiableMap(map);
        }
        Map<String, ComponentRequestBuilder> dependencies = cspecBld.getDependencyMap();
        int n2 = top = dependencies == null ? 0 : dependencies.size();
        if (top == 0) {
            this.m_dependencies = Collections.emptyMap();
        } else {
            Map<Object, Object> map;
            if (top == 1) {
                ComponentRequestBuilder componentRequestBuilder = dependencies.values().iterator().next();
                map = Collections.unmodifiableMap(Collections.singletonMap(componentRequestBuilder.getName(), componentRequestBuilder.createComponentRequest()));
            } else {
                map = new TreeMap();
                for (Map.Entry entry : dependencies.entrySet()) {
                    map.put((String)entry.getKey(), ((ComponentRequestBuilder)entry.getValue()).createComponentRequest());
                }
            }
            this.m_dependencies = Collections.unmodifiableMap(map);
        }
        Map<String, GeneratorBuilder> generators = cspecBld.getGenerators();
        int n3 = top = generators == null ? 0 : generators.size();
        if (top == 0) {
            this.m_generators = Collections.emptyMap();
        } else {
            void var6_14;
            Collection<GeneratorBuilder> values = generators.values();
            if (top == 1) {
                GeneratorBuilder bld = values.iterator().next();
                Map<String, Generator> map = Collections.singletonMap(bld.getGenerates(), bld.createGenerator(this));
            } else {
                TreeMap<String, Generator> treeMap = new TreeMap<String, Generator>();
                for (GeneratorBuilder bld : values) {
                    treeMap.put(bld.getGenerates(), bld.createGenerator(this));
                }
            }
            this.m_generators = Collections.unmodifiableMap(var6_14);
        }
    }

    @Override
    public Attribute getAttribute(String name) {
        Attribute attr = this.m_attributes.get(name);
        if (attr == null && name.equals(SELF_ARTIFACT)) {
            attr = this.m_selfAttribute;
        }
        return attr;
    }

    public Map<String, Attribute> getAttributes() {
        return this.m_attributes;
    }

    public Attribute[] getAttributes(Collection<String> attributeNames) throws MissingAttributeException {
        int sz = attributeNames == null ? 0 : attributeNames.size();
        Attribute[] attributes = new Attribute[sz];
        int idx = 0;
        for (String str : attributeNames) {
            attributes[idx++] = this.getRequiredAttribute(str);
        }
        return attributes;
    }

    public Attribute[] getAttributes(String ... attributeNames) throws MissingAttributeException {
        return this.getAttributes(Arrays.asList(attributeNames));
    }

    public List<Attribute> getAttributesProducedByActions(boolean includePrivate) throws CoreException {
        ModelCache ctx = new ModelCache();
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (Attribute ag : this.m_attributes.values()) {
            if (!includePrivate && !ag.isPublic() || !ag.isProducedByActions(ctx)) continue;
            attributes.add(ag);
        }
        return attributes;
    }

    public Attribute getBindEntryPoint() {
        return this.getAttribute(WellknownActions.BUCKMINSTER.BIND_ENTRYPOINT.toString());
    }

    @Override
    public ComponentIdentifier getComponentIdentifier() {
        return this.m_componentIdentifier;
    }

    public IPath getComponentLocation() throws CoreException {
        return WorkspaceInfo.getComponentLocation(this);
    }

    @Override
    public String getComponentTypeID() {
        return this.m_componentIdentifier.getComponentTypeID();
    }

    public String getDefaultTag() {
        return TAG;
    }

    public Collection<ComponentRequest> getDependencies() {
        return this.m_dependencies.values();
    }

    @Override
    public ComponentRequest getDependency(String dependencyName, String componentType) throws MissingDependencyException {
        ComponentRequest dependency = this.m_dependencies.get(dependencyName);
        if (dependency != null) {
            return dependency;
        }
        if (componentType != null && (dependency = this.m_dependencies.get(String.valueOf(dependencyName) + COMPONENT_NAME_TYPE_SEPARATOR + componentType)) != null) {
            return dependency;
        }
        throw new MissingDependencyException(this.m_componentIdentifier.toString(), dependencyName);
    }

    @Override
    public Documentation getDocumentation() {
        return this.m_documentation;
    }

    @Override
    public Filter getFilter() {
        return this.m_filter;
    }

    public Map<String, Generator> getGenerators() {
        return this.m_generators;
    }

    @Override
    public String getName() {
        return this.m_componentIdentifier.getName();
    }

    public Attribute getPrebind() {
        return this.getAttribute(WellknownActions.BUCKMINSTER.PREBIND.toString());
    }

    @Override
    public URL getProjectInfo() {
        return this.m_projectInfo;
    }

    public List<QualifiedDependency> getQualifiedDependencies(boolean attributePrune) throws CoreException {
        HashMap<ComponentRequest, Set<String>> deps = new HashMap<ComponentRequest, Set<String>>();
        if (!attributePrune) {
            for (ComponentRequest componentRequest : this.getDependencies()) {
                deps.put(componentRequest, new HashSet());
            }
        }
        for (IAttribute iAttribute : this.getAttributes().values()) {
            this.addDependencyBundle(deps, iAttribute);
        }
        if (!this.m_generators.isEmpty()) {
            for (IGenerator iGenerator : this.m_generators.values()) {
                String component = iGenerator.getComponent();
                if (component == null) {
                    this.addDependencyBundle(deps, this.getRequiredAttribute(iGenerator.getAttribute()));
                    continue;
                }
                ComponentRequest dep = this.getDependency(component, null);
                HashSet<String> attrs = (HashSet<String>)deps.get(dep);
                if (attrs == null) {
                    attrs = new HashSet<String>();
                    deps.put(dep, attrs);
                }
                attrs.add(iGenerator.getAttribute());
            }
        }
        ArrayList<QualifiedDependency> arrayList = new ArrayList<QualifiedDependency>(deps.size());
        for (Map.Entry entry : deps.entrySet()) {
            arrayList.add(new QualifiedDependency((ComponentRequest)entry.getKey(), (Collection)entry.getValue()));
        }
        return arrayList;
    }

    public Attribute getReferencedAttribute(String componentName, String componentType, String attributeName, IModelCache ctx) throws CoreException {
        CSpec referencedCSpec;
        if (componentName == null) {
            referencedCSpec = this;
        } else {
            ComponentRequest dep = this.getDependency(componentName, componentType);
            if (!dep.isEnabled(ctx.getProperties())) {
                return null;
            }
            referencedCSpec = ctx.findCSpec(this, dep);
        }
        Attribute referencedAttr = referencedCSpec.getRequiredAttribute(attributeName);
        if (referencedAttr.isEnabled(ctx)) {
            if (referencedCSpec == this || referencedAttr.isPublic()) {
                return referencedAttr;
            }
            throw new MissingAttributeException(referencedCSpec.getComponentIdentifier().toString(), attributeName, true);
        }
        return null;
    }

    public Attribute getRequiredAttribute(String name) throws MissingAttributeException {
        Attribute attr = this.getAttribute(name);
        if (attr == null) {
            throw new MissingAttributeException(this.m_componentIdentifier.toString(), name);
        }
        return attr;
    }

    @Override
    public String getShortDesc() {
        return this.m_shortDesc;
    }

    public String getTagInfo(String parentInfo) {
        return CSpec.getTagInfo(this.m_componentIdentifier, this.m_projectInfo, parentInfo);
    }

    @Override
    public IVersion getVersion() {
        return this.m_componentIdentifier.getVersion();
    }

    @Override
    public boolean isPersisted(StorageManager sm) throws CoreException {
        return sm.getCSpecs().contains(this);
    }

    public boolean isPruneApplicable(RMContext context, Map<String, ? extends Object> properties, boolean pruneForAttributes, Set<String> attrNames) throws CoreException {
        Collection<ComponentRequest> deps = this.getDependencies();
        for (ComponentRequest dep : deps) {
            Filter filter = dep.getFilter();
            if (filter == null) continue;
            filter.addConsultedAttributes(context.getFilterAttributeUsageMap());
            if (filter.matchCase(properties)) continue;
            return true;
        }
        Set<String> allAttrNames = this.getAttributes().keySet();
        if (pruneForAttributes) {
            if (attrNames.isEmpty()) {
                attrNames = allAttrNames;
            }
        } else {
            attrNames = allAttrNames;
        }
        HashSet<String> referencedAttrNames = new HashSet<String>();
        for (String attrName : attrNames) {
            Attribute attr = this.getAttribute(attrName);
            if (attr == null) continue;
            this.addReferencedDependencies(null, referencedAttrNames, attr, null);
        }
        return !allAttrNames.equals(referencedAttrNames);
    }

    public CSpec prune(RMContext context, Map<String, ? extends Object> properties, boolean pruneForAttributes, Set<String> attrNames) throws CoreException {
        Collection<ComponentRequest> deps;
        if (!this.isPruneApplicable(context, properties, pruneForAttributes, attrNames)) {
            return this;
        }
        CSpecBuilder bld = new CSpecBuilder();
        bld.setComponentTypeID(this.getComponentTypeID());
        bld.setDocumentation(this.getDocumentation());
        bld.setName(this.getName());
        bld.setProjectInfo(this.getProjectInfo());
        bld.setShortDesc(this.getShortDesc());
        bld.setVersion(this.getVersion());
        bld.setFilter(this.getFilter());
        Set<String> allAttrNames = this.getAttributes().keySet();
        if (pruneForAttributes) {
            if (attrNames.isEmpty()) {
                attrNames = allAttrNames;
            }
        } else {
            attrNames = allAttrNames;
        }
        if (attrNames.isEmpty() && this.getGenerators().isEmpty()) {
            deps = this.getDependencies();
        } else {
            HashSet<ComponentRequest> hashSet = new HashSet<ComponentRequest>();
            HashSet<String> referencedAttrs = new HashSet<String>();
            for (String string : attrNames) {
                Attribute attr = this.getAttribute(string);
                if (attr == null) continue;
                this.addReferencedDependencies(hashSet, referencedAttrs, attr, null);
            }
            for (IGenerator iGenerator : this.getGenerators().values()) {
                String component = iGenerator.getComponent();
                if (component == null) {
                    this.addReferencedDependencies(hashSet, referencedAttrs, this.getRequiredAttribute(iGenerator.getAttribute()), null);
                    continue;
                }
                hashSet.add(this.getDependency(component, null));
            }
            deps = hashSet;
        }
        for (ComponentRequest componentRequest : deps) {
            Filter filter = componentRequest.getFilter();
            if (filter != null) {
                filter.addConsultedAttributes(context.getFilterAttributeUsageMap());
                if (!filter.matchCase(properties)) continue;
            }
            bld.addDependency(componentRequest);
        }
        for (String string : attrNames) {
            Attribute attribute = this.getAttribute(string);
            if (attribute == null || !this.dependenciesFulfilled(attribute, bld, null)) continue;
            bld.addAttribute(attribute);
        }
        for (IGenerator iGenerator : this.getGenerators().values()) {
            String string = iGenerator.getComponent();
            if (string == null ? bld.getAttribute(iGenerator.getAttribute()) == null : bld.getDependency(string, null) == null) continue;
            bld.addGenerator(iGenerator);
        }
        return bld.createCSpec();
    }

    @Override
    public void remove(StorageManager sm) throws CoreException {
        UUID thisId = this.getId();
        if (!sm.getResolutions().getReferencingKeys(thisId, "cspecId").isEmpty()) {
            throw new ReferentialIntegrityException(this, "remove", Messages.Referenced_from_Resolution);
        }
        sm.getCSpecs().removeElement(thisId);
    }

    @Override
    public void store(StorageManager sm) throws CoreException {
        sm.getCSpecs().putElement(this);
    }

    public void toSax(ContentHandler receiver) throws SAXException {
        receiver.startDocument();
        this.toSax(receiver, "http://www.eclipse.org/buckminster/CSpec-1.0", "cs", this.getDefaultTag());
        receiver.endDocument();
    }

    public void verifyConsistency() throws MissingDependencyException, MissingAttributeException, CircularReferenceException {
        for (Attribute attribute : this.m_attributes.values()) {
            if (attribute instanceof IActionArtifact) continue;
            this.verifyPrerequisites(attribute, null);
        }
        for (IGenerator iGenerator : this.m_generators.values()) {
            String component = iGenerator.getComponent();
            if (component == null) {
                this.getRequiredAttribute(iGenerator.getAttribute());
                continue;
            }
            this.getDependency(component, null);
        }
    }

    protected void addAttributes(AttributesImpl attrs) {
        IVersion version;
        Utils.addAttribute((AttributesImpl)attrs, (String)"name", (String)this.m_componentIdentifier.getName());
        String ctypeID = this.m_componentIdentifier.getComponentTypeID();
        if (ctypeID != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)"componentType", (String)ctypeID);
        }
        if ((version = this.m_componentIdentifier.getVersion()) != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)"version", (String)version.toString());
            Utils.addAttribute((AttributesImpl)attrs, (String)"versionType", (String)version.getType().getId());
        }
        if (this.m_projectInfo != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_PROJECT_INFO, (String)this.m_projectInfo.toString());
        }
        if (this.m_shortDesc != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_SHORT_DESC, (String)this.m_shortDesc);
        }
        if (this.m_filter != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_FILTER, (String)this.m_filter.toString());
        }
    }

    protected void emitElements(ContentHandler handler, String namespace, String prefix) throws SAXException {
        if (this.m_documentation != null) {
            this.m_documentation.toSax(handler, namespace, prefix, this.m_documentation.getDefaultTag());
        }
        Utils.emitCollection((String)namespace, (String)prefix, (String)ELEM_DEPENDENCIES, (String)ELEM_DEPENDENCY, this.m_dependencies.values(), (ContentHandler)handler);
        Utils.emitCollection((String)namespace, (String)prefix, (String)ELEM_GENERATORS, (String)"generator", this.m_generators.values(), (ContentHandler)handler);
        ArrayList<Attribute> topArtifacts = new ArrayList<Attribute>();
        ArrayList<Attribute> actions = new ArrayList<Attribute>();
        ArrayList<Attribute> groups = new ArrayList<Attribute>();
        for (Attribute attr : this.m_attributes.values()) {
            if (attr instanceof IAction) {
                actions.add(attr);
                continue;
            }
            if (attr instanceof IGroup) {
                groups.add(attr);
                continue;
            }
            if (attr instanceof IActionArtifact) continue;
            topArtifacts.add(attr);
        }
        Collections.sort(topArtifacts, s_attributeSorter);
        Collections.sort(actions, s_attributeSorter);
        Collections.sort(groups, s_attributeSorter);
        Utils.emitCollection((String)namespace, (String)prefix, (String)ELEM_ARTIFACTS, null, topArtifacts, (ContentHandler)handler);
        Utils.emitCollection((String)namespace, (String)prefix, (String)ELEM_ACTIONS, null, actions, (ContentHandler)handler);
        Utils.emitCollection((String)namespace, (String)prefix, (String)ELEM_GROUPS, null, groups, (ContentHandler)handler);
    }

    protected String getElementNamespace(String namespace) {
        return "http://www.eclipse.org/buckminster/CSpec-1.0";
    }

    protected String getElementPrefix(String prefix) {
        return "cs";
    }

    List<ActionArtifact> getActionArtifacts(Action action) {
        List<ActionArtifact> artifacts = null;
        String actionName = action.getName();
        for (IAttribute iAttribute : this.m_attributes.values()) {
            ActionArtifact aa;
            if (!(iAttribute instanceof IActionArtifact) || !(aa = (ActionArtifact)iAttribute).getActionName().equals(actionName)) continue;
            if (artifacts == null) {
                artifacts = new ArrayList<ActionArtifact>();
            }
            artifacts.add(aa);
        }
        if (artifacts == null) {
            artifacts = Collections.emptyList();
        }
        return artifacts;
    }

    private void addDependencyBundle(Map<ComponentRequest, Set<String>> deps, IAttribute dp) throws CoreException {
        for (IPrerequisite iPrerequisite : dp.getPrerequisites()) {
            if (iPrerequisite.isExternal()) {
                ComponentRequest rq = this.getDependency(iPrerequisite.getComponentName(), iPrerequisite.getComponentType());
                Set<String> attributes = deps.get(rq);
                if (attributes == null) {
                    attributes = new HashSet<String>();
                    deps.put(rq, attributes);
                }
                attributes.add(iPrerequisite.getAttribute());
                continue;
            }
            Attribute localGroup = this.getAttribute(iPrerequisite.getAttribute());
            if (localGroup instanceof IActionArtifact) {
                localGroup = ((ActionArtifact)localGroup).getAction();
            }
            this.addDependencyBundle(deps, localGroup);
        }
    }

    private void addReferencedDependencies(Set<ComponentRequest> dependencies, Set<String> attrNames, Attribute attr, Stack<IAttributeFilter> filters) throws CoreException {
        if (attrNames.contains(attr.getName())) {
            return;
        }
        attrNames.add(attr.getName());
        if (attr instanceof IActionArtifact) {
            this.addReferencedDependencies(dependencies, attrNames, ((ActionArtifact)attr).getAction(), filters);
            return;
        }
        for (Prerequisite prereq : attr.getPrerequisites(filters)) {
            if (prereq.isExternal()) {
                if (dependencies == null) continue;
                dependencies.add(this.getDependency(prereq.getComponentName(), prereq.getComponentType()));
                continue;
            }
            Attribute localAttr = this.getRequiredAttribute(prereq.getAttribute());
            if (prereq.isPatternFilter()) {
                if (filters == null) {
                    filters = new Stack();
                }
                filters.push(prereq);
                this.addReferencedDependencies(dependencies, attrNames, localAttr, filters);
                filters.pop();
                continue;
            }
            this.addReferencedDependencies(dependencies, attrNames, localAttr, filters);
        }
    }

    private boolean dependenciesFulfilled(Attribute attr, CSpecBuilder bld, Stack<IAttributeFilter> filters) throws CoreException {
        if (attr instanceof IActionArtifact) {
            attr = ((ActionArtifact)attr).getAction();
        }
        for (Prerequisite pq : attr.getPrerequisites(filters)) {
            if (pq.isExternal()) {
                if (bld.getDependency(pq.getComponentName(), pq.getComponentType()) != null) continue;
                return false;
            }
            if (pq.isPatternFilter()) {
                if (filters == null) {
                    filters = new Stack();
                }
                filters.push(pq);
            }
            if (!this.dependenciesFulfilled(this.getRequiredAttribute(pq.getAttribute()), bld, filters)) {
                return false;
            }
            if (!pq.isPatternFilter()) continue;
            filters.pop();
        }
        return true;
    }

    private void verifyNonCircularDependency(Stack<String> seenAttributes, Collection<Prerequisite> prereqs, Stack<IAttributeFilter> filters) throws MissingAttributeException, CircularReferenceException {
        for (Prerequisite prereq : prereqs) {
            List<Prerequisite> agPreqs;
            if (prereq.isExternal()) continue;
            Attribute ag = this.getRequiredAttribute(prereq.getAttribute());
            if (ag instanceof IActionArtifact) {
                ag = ((ActionArtifact)ag).getAction();
            }
            if (seenAttributes.contains(ag.getName())) {
                throw new CircularReferenceException(this.getComponentIdentifier().toString(), seenAttributes, ag.getName());
            }
            if (prereq.isPatternFilter()) {
                if (filters == null) {
                    filters = new Stack();
                }
                filters.push(prereq);
                agPreqs = ag.getPrerequisites(filters);
                filters.pop();
            } else {
                agPreqs = ag.getPrerequisites(filters);
            }
            if (agPreqs.size() <= 0) continue;
            seenAttributes.push(ag.getName());
            this.verifyNonCircularDependency(seenAttributes, agPreqs, filters);
            seenAttributes.pop();
        }
    }

    private void verifyPrerequisites(Attribute attr, Stack<IAttributeFilter> filters) throws MissingDependencyException, MissingAttributeException, CircularReferenceException {
        Stack<String> seenActions = new Stack<String>();
        for (Prerequisite prereq : attr.getPrerequisites(filters)) {
            List<Prerequisite> agPreqs;
            if (prereq.isExternal()) {
                this.getDependency(prereq.getComponentName(), prereq.getComponentType());
                continue;
            }
            Attribute ag = this.getRequiredAttribute(prereq.getAttribute());
            if (ag instanceof IActionArtifact) {
                ((ActionArtifact)ag).getAction();
            }
            if (prereq.isPatternFilter()) {
                if (filters == null) {
                    filters = new Stack();
                }
                filters.push(prereq);
            }
            if ((agPreqs = ag.getPrerequisites(filters)).size() > 0) {
                seenActions.clear();
                seenActions.push(ag.getName());
                this.verifyNonCircularDependency(seenActions, agPreqs, filters);
            }
            if (!prereq.isPatternFilter()) continue;
            filters.pop();
        }
    }
}

