/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.model;

import java.util.Map;
import org.eclipse.buckminster.core.cspec.IComponentIdentifier;
import org.eclipse.buckminster.core.cspec.IComponentName;
import org.eclipse.buckminster.core.cspec.model.ComponentName;
import org.eclipse.buckminster.core.version.IVersion;
import org.eclipse.buckminster.core.version.VersionFactory;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.core.runtime.CoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentIdentifier
extends ComponentName
implements IComponentIdentifier {
    private final IVersion m_version;
    public static final String ATTR_VERSION_TYPE = "versionType";
    public static final String ATTR_VERSION = "version";

    public static ComponentIdentifier parse(String componentIdentifierStr) throws CoreException {
        IVersion version = null;
        int verIdx = componentIdentifierStr.indexOf(36);
        if (verIdx >= 0) {
            String versionStr = componentIdentifierStr.substring(verIdx + 1);
            componentIdentifierStr = componentIdentifierStr.substring(0, verIdx);
            String versionType = null;
            int typeIdx = versionStr.indexOf(35);
            if (typeIdx > 0) {
                versionType = versionStr.substring(typeIdx + 1);
                versionStr = versionStr.substring(0, typeIdx);
            }
            version = VersionFactory.createVersion(versionType, versionStr);
        }
        String componentType = null;
        int catIdx = componentIdentifierStr.indexOf(58);
        if (catIdx >= 0) {
            componentType = componentIdentifierStr.substring(catIdx + 1);
            componentIdentifierStr = componentIdentifierStr.substring(0, catIdx);
        }
        return new ComponentIdentifier(componentIdentifierStr, componentType, version);
    }

    public ComponentIdentifier(String name, String componentTypeID, IVersion version) {
        super(name, componentTypeID);
        this.m_version = version;
    }

    @Override
    public int compareTo(IComponentName o) {
        int cmp = super.compareTo(o);
        if (cmp == 0) {
            cmp = o instanceof IComponentIdentifier ? Trivial.compareAllowNull((Comparable)this.m_version, (Comparable)((IComponentIdentifier)o).getVersion()) : 1;
        }
        return cmp;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return this == o || super.equals(o) && Trivial.equalsAllowNull((Object)this.m_version, (Object)((ComponentIdentifier)o).m_version);
    }

    @Override
    public String getDefaultTag() {
        return null;
    }

    @Override
    public Map<String, String> getProperties() {
        Map<String, String> p = super.getProperties();
        if (this.m_version != null) {
            p.put("buckminster.version", this.m_version.toString());
            p.put("buckminster.version.type", this.m_version.getType().getId());
        }
        return p;
    }

    @Override
    public final IVersion getVersion() {
        return this.m_version;
    }

    @Override
    public int hashCode() {
        int hc = super.hashCode();
        if (this.m_version != null) {
            hc *= 37;
            hc += this.m_version.hashCode();
        }
        return hc;
    }

    public boolean matches(ComponentIdentifier o) {
        return super.matches(o) && (this.m_version == null || o.m_version == null || this.m_version.equals(o.m_version));
    }

    @Override
    public ComponentName toPureComponentName() {
        return new ComponentName(this);
    }

    @Override
    public void toString(StringBuilder bld) {
        super.toString(bld);
        if (this.m_version != null) {
            bld.append('$');
            this.m_version.toString(bld);
            bld.append('#');
            bld.append(this.m_version.getType().getId());
        }
    }
}

