/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.model;

import java.util.Map;
import org.eclipse.buckminster.core.cspec.IComponentIdentifier;
import org.eclipse.buckminster.core.cspec.IComponentRequest;
import org.eclipse.buckminster.core.cspec.builder.ComponentRequestBuilder;
import org.eclipse.buckminster.core.cspec.model.ComponentName;
import org.eclipse.buckminster.core.cspec.model.ComponentRequestConflictException;
import org.eclipse.buckminster.core.version.IVersion;
import org.eclipse.buckminster.core.version.IVersionDesignator;
import org.eclipse.buckminster.core.version.IVersionType;
import org.eclipse.buckminster.core.version.VersionFactory;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentRequest
extends ComponentName
implements IComponentRequest {
    public static final String TAG = "component";
    public static final String ATTR_VERSION_DESIGNATOR = "versionDesignator";
    public static final String ATTR_VERSION_TYPE = "versionType";
    public static final String ATTR_FILTER = "filter";
    private final IVersionDesignator m_versionDesignator;
    private final Filter m_filter;

    public ComponentRequest(ComponentRequestBuilder bld) {
        super(bld.getName(), bld.getComponentTypeID());
        this.m_versionDesignator = bld.getVersionDesignator();
        this.m_filter = bld.getFilter();
    }

    public ComponentRequest(String name, String componentType, IVersionDesignator versionDesignator) {
        super(name, componentType);
        this.m_versionDesignator = versionDesignator;
        this.m_filter = null;
    }

    public ComponentRequest(String name, String componentType, String versionDesignatorStr, String versionTypeId) throws CoreException {
        this(name, componentType, versionDesignatorStr, versionTypeId, null);
    }

    public ComponentRequest(String name, String componentType, String versionDesignatorStr, String versionTypeId, Filter filter) throws CoreException {
        super(name, componentType);
        IVersionDesignator versionDesignator = null;
        if (versionDesignatorStr != null) {
            versionDesignator = VersionFactory.createDesignator(versionTypeId, versionDesignatorStr);
        }
        this.m_versionDesignator = versionDesignator;
        this.m_filter = filter;
    }

    public void appendViewName(StringBuilder bld) {
        bld.append(this.getName());
        String componentType = this.getComponentTypeID();
        if (componentType != null) {
            bld.append(':');
            bld.append(componentType);
        }
        if (this.m_filter != null) {
            bld.append(this.m_filter);
        }
    }

    @Override
    public boolean designates(IComponentIdentifier id) {
        return !(!Trivial.equalsAllowNull((Object)this.getName(), (Object)id.getName()) || this.getComponentTypeID() != null && !this.getComponentTypeID().equals(id.getComponentTypeID()) || this.m_versionDesignator != null && !this.m_versionDesignator.designates(id.getVersion()));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return super.equals(o) && Trivial.equalsAllowNull((Object)this.m_versionDesignator, (Object)((ComponentRequest)o).m_versionDesignator) && Trivial.equalsAllowNull((Object)this.m_filter, (Object)((ComponentRequest)o).m_filter);
    }

    @Override
    public String getDefaultTag() {
        return TAG;
    }

    @Override
    public Filter getFilter() {
        return this.m_filter;
    }

    @Override
    public Map<String, String> getProperties() {
        Map<String, String> p = super.getProperties();
        if (this.m_versionDesignator != null) {
            p.put("buckminster.version.designator", this.m_versionDesignator.toString());
            p.put("buckminster.version.type", this.m_versionDesignator.getVersion().getType().getId());
        }
        return p;
    }

    @Override
    public IVersionDesignator getVersionDesignator() {
        return this.m_versionDesignator;
    }

    public String getViewName() {
        StringBuilder bld = new StringBuilder();
        this.appendViewName(bld);
        return bld.toString();
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + (this.m_versionDesignator == null ? 0 : this.m_versionDesignator.hashCode());
        return 31 * hash + (this.m_filter == null ? 0 : this.m_filter.hashCode());
    }

    public boolean isEnabled(Map<String, ? extends Object> properties) {
        return this.m_filter == null || this.m_filter.matchCase(properties);
    }

    public ComponentRequest mergeDesignator(ComponentRequest that) throws CoreException {
        if (!Trivial.equalsAllowNull((Object)this.getName(), (Object)that.getName())) {
            throw new ComponentRequestConflictException(this, that);
        }
        String thisCType = this.getComponentTypeID();
        String thatCType = that.getComponentTypeID();
        if (thisCType == null) {
            thisCType = thatCType;
        } else if (thatCType != null && !thisCType.equals(thatCType)) {
            throw new ComponentRequestConflictException(this, that);
        }
        IVersionDesignator thisVD = this.getVersionDesignator();
        IVersionDesignator thatVD = that.getVersionDesignator();
        if (thisVD == null) {
            return thatVD == null ? this : that;
        }
        if (thatVD == null) {
            return this;
        }
        IVersionDesignator mergedVD = thisVD.merge(thatVD);
        if (mergedVD == thisVD) {
            return this;
        }
        if (mergedVD == null) {
            throw new ComponentRequestConflictException(this, that);
        }
        return new ComponentRequest(this.getName(), thisCType, mergedVD);
    }

    @Override
    public ComponentName toPureComponentName() {
        return new ComponentName(this);
    }

    @Override
    public void toString(StringBuilder bld) {
        super.toString(bld);
        if (this.m_versionDesignator != null) {
            bld.append('/');
            bld.append(this.m_versionDesignator);
            bld.append('#');
            bld.append(this.m_versionDesignator.getVersion().getType().getId());
        }
        if (this.m_filter != null) {
            bld.append(this.m_filter);
        }
    }

    @Override
    protected void addAttributes(AttributesImpl attrs) {
        super.addAttributes(attrs);
        if (this.m_versionDesignator != null) {
            IVersionType vt;
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_VERSION_DESIGNATOR, (String)this.m_versionDesignator.toString());
            IVersion version = this.m_versionDesignator.getVersion();
            if (version != null && (vt = version.getType()) != null) {
                Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_VERSION_TYPE, (String)vt.getId());
            }
        }
        if (this.m_filter != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_FILTER, (String)this.m_filter.toString());
        }
    }
}

