/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.model;

import org.eclipse.buckminster.core.cspec.IGenerator;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.NamedElement;
import org.eclipse.buckminster.sax.Utils;
import org.xml.sax.helpers.AttributesImpl;

public class Generator
extends NamedElement
implements IGenerator {
    public static final String ATTR_ATTRIBUTE = "attribute";
    public static final String ATTR_COMPONENT = "component";
    public static final String ATTR_GENERATES = "generates";
    public static final String TAG = "generator";
    private final CSpec m_cspec;
    private final String m_attribute;
    private final String m_component;

    public Generator(CSpec cspec, String component, String attribute, String generates) {
        super(generates);
        this.m_cspec = cspec;
        this.m_component = component;
        this.m_attribute = attribute;
    }

    protected void addAttributes(AttributesImpl attrs) {
        super.addAttributes(attrs);
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_ATTRIBUTE, (String)this.m_attribute);
        if (this.m_component != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_COMPONENT, (String)this.m_component);
        }
    }

    public String getAttribute() {
        return this.m_attribute;
    }

    public String getComponent() {
        return this.m_component;
    }

    public CSpec getCSpec() {
        return this.m_cspec;
    }

    public String getDefaultTag() {
        return TAG;
    }

    public String getGenerates() {
        return this.getName();
    }

    public String getNameAttributeName() {
        return ATTR_GENERATES;
    }
}

