/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.buckminster.core.cspec.IPrerequisite;
import org.eclipse.buckminster.core.cspec.builder.PrerequisiteBuilder;
import org.eclipse.buckminster.core.cspec.model.Attribute;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.NamedElement;
import org.eclipse.buckminster.core.metadata.model.IModelCache;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Prerequisite
extends NamedElement
implements IPrerequisite {
    public static final String ATTR_ALIAS = "alias";
    public static final String ATTR_COMPONENT = "component";
    public static final String ATTR_COMPONENT_TYPE = "componentType";
    public static final String ATTR_CONTRIBUTOR = "contributor";
    public static final String ATTR_EXCLUDE_PATTERN = "excludePattern";
    public static final String ATTR_INCLUDE_PATTERN = "includePattern";
    public static final String ATTR_OPTIONAL = "optional";
    public static final String TAG = "attribute";
    private final String m_alias;
    private final String m_componentName;
    private final String m_componentType;
    private final boolean m_contributor;
    private final Pattern m_excludePattern;
    private final Pattern m_includePattern;
    private final boolean m_optional;

    public static boolean isMatch(String component, String attribute, Pattern excludePattern, Pattern includePattern) {
        Matcher m;
        CharSequence tmp;
        if (attribute == null && component == null) {
            return false;
        }
        if (excludePattern == null && includePattern == null) {
            return true;
        }
        if (attribute == null) {
            tmp = component;
        } else {
            StringBuilder bld = new StringBuilder();
            if (component != null) {
                bld.append(component);
            }
            bld.append('#');
            bld.append(attribute);
            tmp = bld;
        }
        if (excludePattern != null && (m = excludePattern.matcher(tmp)).matches()) {
            return false;
        }
        return includePattern == null || (m = includePattern.matcher(tmp)).matches();
    }

    public Prerequisite(PrerequisiteBuilder bld) {
        super(bld.getName());
        this.m_alias = bld.getAlias();
        this.m_contributor = bld.isContributor();
        this.m_optional = bld.isOptional();
        this.m_componentName = bld.getComponentName();
        this.m_componentType = bld.getComponentType();
        this.m_excludePattern = bld.getExcludePattern();
        this.m_includePattern = bld.getIncludePattern();
    }

    public final String getAlias() {
        return this.m_alias;
    }

    public final String getAttribute() {
        return this.getName();
    }

    public final String getComponentName() {
        return this.m_componentName;
    }

    public final String getComponentType() {
        return this.m_componentType;
    }

    public String getDefaultTag() {
        return TAG;
    }

    public Pattern getExcludePattern() {
        return this.m_excludePattern;
    }

    public Pattern getIncludePattern() {
        return this.m_includePattern;
    }

    public Attribute getReferencedAttribute(CSpec ownerCSpec, IModelCache ctx) throws CoreException {
        return ownerCSpec.getReferencedAttribute(this.m_componentName, this.m_componentType, this.getName(), ctx);
    }

    public boolean isContributor() {
        return this.m_contributor;
    }

    public boolean isEnabled(IModelCache cache, CSpec cspec) throws CoreException {
        return this.isExternal() ? this.getReferencedAttribute(cspec, cache) != null : cspec.getAttribute(this.getAttribute()).isEnabled(cache);
    }

    public boolean isExternal() {
        return this.m_componentName != null;
    }

    public boolean isMatch(String component, String attribute) {
        return Prerequisite.isMatch(component, attribute, this.m_excludePattern, this.m_includePattern);
    }

    public final boolean isOptional() {
        return this.m_optional;
    }

    public boolean isPatternFilter() {
        return this.m_excludePattern != null || this.m_includePattern != null;
    }

    public final String toString() {
        if (this.m_componentName == null) {
            return this.getName();
        }
        return String.valueOf(this.m_componentName) + '#' + this.getAttribute();
    }

    protected void addAttributes(AttributesImpl attrs) {
        super.addAttributes(attrs);
        if (this.m_alias != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_ALIAS, (String)this.m_alias);
        }
        if (!this.m_contributor) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_CONTRIBUTOR, (String)"false");
        }
        if (this.m_excludePattern != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_EXCLUDE_PATTERN, (String)this.m_excludePattern.toString());
        }
        if (this.m_includePattern != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_INCLUDE_PATTERN, (String)this.m_includePattern.toString());
        }
        if (this.m_optional) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_OPTIONAL, (String)"true");
        }
        if (this.m_componentName != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_COMPONENT, (String)this.m_componentName);
        }
        if (this.m_componentType != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_COMPONENT_TYPE, (String)this.m_componentType);
        }
    }

    protected void emitElements(ContentHandler handler, String namespace, String prefix) throws SAXException {
    }
}

