/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.model;

import java.util.Collections;
import java.util.Map;
import java.util.Stack;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.common.model.SAXEmitter;
import org.eclipse.buckminster.core.cspec.IAttributeFilter;
import org.eclipse.buckminster.core.cspec.PathGroup;
import org.eclipse.buckminster.core.cspec.builder.AttributeBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.builder.TopLevelAttributeBuilder;
import org.eclipse.buckminster.core.cspec.model.Attribute;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.Prerequisite;
import org.eclipse.buckminster.core.helpers.FilterUtils;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.core.metadata.model.IModelCache;
import org.eclipse.buckminster.core.version.IVersion;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.sax.ISaxableElement;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TopLevelAttribute
extends Attribute
implements Cloneable {
    public static final String PROPERTY_PREFIX = "buckminster.";
    public static final String INSTALLER_HINT_PREFIX = "buckminster.install.";
    public static final String ELEM_INSTALLER_HINTS = "installerHints";
    public static final String PUBLIC_TAG = "public";
    public static final String PRIVATE_TAG = "private";
    public static final String DEFINITION_TAG = "definitions";
    public static final String DEFINE_TAG = "define";
    private final Map<String, String> m_installerHints;
    private final boolean m_public;

    TopLevelAttribute(String name) {
        super(name);
        this.m_public = false;
        this.m_installerHints = Collections.emptyMap();
    }

    TopLevelAttribute(TopLevelAttributeBuilder builder) {
        super(builder);
        this.m_public = builder.isPublic();
        this.m_installerHints = ExpandingProperties.createUnmodifiableProperties(builder.getInstallerHints());
    }

    @Override
    public void addDynamicProperties(Map<String, Object> properties) throws CoreException {
        String ctype;
        CSpec cspec = this.getCSpec();
        StringBuilder bld = new StringBuilder();
        bld.append(cspec.getName());
        IVersion version = cspec.getVersion();
        if (version != null) {
            bld.append('_');
            bld.append(version.replaceQualifier(null));
        }
        if (!"unknown".equals(ctype = cspec.getComponentTypeID())) {
            bld.append('-');
            bld.append(cspec.getComponentTypeID());
        }
        String uniqueFolder = bld.toString();
        String tempRootStr = (String)properties.get("buckminster.temp.root");
        IPath tempRoot = tempRootStr == null ? Path.fromOSString((String)System.getProperty("java.io.tmpdir")).append("buckminster") : Path.fromOSString((String)tempRootStr);
        String actionTemp = tempRoot.append(uniqueFolder).append("temp").toPortableString();
        String outputRoot = (String)properties.get("buckminster.output.root");
        if (outputRoot == null) {
            outputRoot = tempRoot.append("build").toOSString();
        }
        String actionOutput = Path.fromOSString((String)outputRoot).append(uniqueFolder).toPortableString();
        properties.put("buckminster.output", actionOutput);
        properties.put("buckminster.temp", actionTemp);
        properties.put("buckminster.home", cspec.getComponentLocation().toOSString());
        properties.putAll(cspec.getComponentIdentifier().getProperties());
    }

    public void appendRelativeFiles(IModelCache ctx, Map<String, Long> fileNames) throws CoreException {
        PathGroup[] pqs = this.getPathGroups(ctx, null);
        int idx = pqs.length;
        while (--idx >= 0) {
            pqs[idx].appendRelativeFiles(fileNames);
        }
    }

    public void getDeepInstallerHints(IModelCache ctx, Map<String, String> hints, Stack<IAttributeFilter> filters) throws CoreException {
        Map<String, String> myHints = this.getInstallerHints();
        if (myHints.size() > 0) {
            StringBuilder bld = new StringBuilder(100);
            bld.append(INSTALLER_HINT_PREFIX);
            int pfLen = INSTALLER_HINT_PREFIX.length();
            for (Map.Entry<String, String> hint : myHints.entrySet()) {
                String[] triplet;
                String key = hint.getKey();
                int slashIdx = key.lastIndexOf(47);
                if (slashIdx > 0 && (triplet = TextUtils.split(key.substring(slashIdx + 1), ".")).length == 3) {
                    Filter filter = FilterUtils.createFilter(triplet[0], triplet[1], triplet[2], null);
                    if (!filter.matchCase(ctx.getProperties())) continue;
                    key = key.substring(0, slashIdx);
                }
                bld.setLength(pfLen);
                bld.append(hint.getKey());
                bld.append('.');
                bld.append(this.getName());
                hints.put(bld.toString(), hint.getValue());
            }
        }
        CSpec cspec = this.getCSpec();
        for (Prerequisite child : this.getPrerequisites(filters)) {
            Attribute refAttr = child.getReferencedAttribute(cspec, ctx);
            if (!(refAttr instanceof TopLevelAttribute)) continue;
            if (child.isPatternFilter()) {
                if (filters == null) {
                    filters = new Stack();
                }
                filters.push(child);
                ((TopLevelAttribute)refAttr).getDeepInstallerHints(ctx, hints, filters);
                filters.pop();
                continue;
            }
            ((TopLevelAttribute)refAttr).getDeepInstallerHints(ctx, hints, filters);
        }
    }

    @Override
    public String getDefaultTag() {
        return this.isPublic() ? PUBLIC_TAG : PRIVATE_TAG;
    }

    public long getFirstModified(IModelCache ctx, int expectedFileCount, int[] fileCount) throws CoreException {
        PathGroup[] pqs = this.getPathGroups(ctx, null);
        int idx = pqs.length;
        if (idx == 0) {
            return 0L;
        }
        if (idx > 1 && expectedFileCount > 0) {
            expectedFileCount = -1;
        }
        long oldest = Long.MAX_VALUE;
        while (--idx >= 0) {
            long pgModTime = pqs[idx].getFirstModified(expectedFileCount, fileCount);
            if (pgModTime < oldest && (oldest = pgModTime) == 0L) break;
        }
        return oldest;
    }

    @Override
    public final Map<String, String> getInstallerHints() {
        return this.m_installerHints;
    }

    public long getLastModified(IModelCache ctx, long threshold, int[] fileCount) throws CoreException {
        PathGroup[] pqs = this.getPathGroups(ctx, null);
        int count = 0;
        int idx = pqs.length;
        int[] countBin = new int[1];
        long newest = 0L;
        while (--idx >= 0) {
            countBin[0] = 0;
            long pgModTime = pqs[idx].getLastModified(threshold, countBin);
            count += countBin[0];
            if (pgModTime > newest && (newest = pgModTime) > threshold) break;
        }
        fileCount[0] = count;
        return newest;
    }

    @Override
    public final PathGroup[] getPathGroups(IModelCache ctx, Stack<IAttributeFilter> filters) throws CoreException {
        PathGroup[] pga;
        if (filters == null || filters.isEmpty()) {
            String qName;
            Map<String, PathGroup[]> cache = ctx.getPathGroupsCache();
            pga = cache.get(qName = this.getQualifiedName());
            if (pga == null) {
                ExpandingProperties<Object> local = new ExpandingProperties<Object>(ctx.getProperties());
                this.addDynamicProperties(local);
                pga = this.internalGetPathGroups(ctx, local, filters);
                cache.put(qName, pga);
            }
        } else {
            ExpandingProperties<Object> local = new ExpandingProperties<Object>(ctx.getProperties());
            this.addDynamicProperties(local);
            pga = this.internalGetPathGroups(ctx, local, filters);
        }
        return pga;
    }

    public IPath getUniquePath(IPath root, IModelCache modelCtx) throws CoreException {
        PathGroup group;
        IPath[] paths;
        IPath uniquePath = null;
        PathGroup[] groups = this.getPathGroups(modelCtx, null);
        if (groups.length == 1 && (paths = (group = groups[0]).getPaths()).length == 1) {
            IPath base = group.getBase();
            if (base == null || !base.isAbsolute()) {
                if (root == null) {
                    root = this.getCSpec().getComponentLocation();
                }
                if (base == null) {
                    base = root;
                } else if (!base.isAbsolute()) {
                    base = root.append(base);
                }
            }
            uniquePath = base.append(paths[0]);
        }
        if (uniquePath == null) {
            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.Unable_to_determine_a_unique_product_path_for_0, (Object)this), (Object[])new Object[0]);
        }
        return uniquePath;
    }

    @Override
    public boolean isPublic() {
        return this.m_public;
    }

    @Override
    protected abstract AttributeBuilder createAttributeBuilder(CSpecBuilder var1);

    @Override
    protected void emitElements(ContentHandler handler, String namespace, String prefix) throws SAXException {
        super.emitElements(handler, namespace, prefix);
        if (!this.m_installerHints.isEmpty()) {
            String qName = Utils.makeQualifiedName((String)prefix, (String)ELEM_INSTALLER_HINTS);
            handler.startElement(namespace, ELEM_INSTALLER_HINTS, qName, ISaxableElement.EMPTY_ATTRIBUTES);
            SAXEmitter.emitProperties(handler, this.m_installerHints, namespace, prefix, true, false);
            handler.endElement(namespace, ELEM_INSTALLER_HINTS, qName);
        }
    }

    protected abstract PathGroup[] internalGetPathGroups(IModelCache var1, Map<String, ? extends Object> var2, Stack<IAttributeFilter> var3) throws CoreException;
}

