/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.parser;

import org.eclipse.buckminster.core.cspec.builder.ArtifactBuilder;
import org.eclipse.buckminster.core.cspec.builder.TopLevelAttributeBuilder;
import org.eclipse.buckminster.core.cspec.model.PathAlreadyDefinedException;
import org.eclipse.buckminster.core.cspec.parser.PathHandler;
import org.eclipse.buckminster.core.cspec.parser.TopLevelAttributeHandler;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.buckminster.sax.ChildHandler;
import org.eclipse.core.runtime.Path;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ArtifactHandler
extends TopLevelAttributeHandler {
    private final PathHandler m_pathHandler = new PathHandler((AbstractHandler)this);

    public ArtifactHandler(AbstractHandler parent, boolean publ) {
        super(parent, publ);
    }

    public void childPopped(ChildHandler child) throws SAXException {
        if (child == this.m_pathHandler) {
            try {
                this.getArtifactBuilder().addPath(this.m_pathHandler.getPath());
            }
            catch (PathAlreadyDefinedException e) {
                throw new SAXParseException(e.getMessage(), this.getDocumentLocator());
            }
        } else {
            super.childPopped(child);
        }
    }

    protected TopLevelAttributeBuilder createAttributeBuilder() {
        return this.getCSpecBuilder().createArtifactBuilder();
    }

    public ChildHandler createHandler(String uri, String localName, Attributes attrs) throws SAXException {
        PathHandler ch = "path".equals(localName) ? this.m_pathHandler : super.createHandler(uri, localName, attrs);
        return ch;
    }

    final ArtifactBuilder getArtifactBuilder() {
        return (ArtifactBuilder)this.getBuilder();
    }

    public void handleAttributes(Attributes attrs) throws SAXException {
        String pathStr;
        super.handleAttributes(attrs);
        ArtifactBuilder builder = this.getArtifactBuilder();
        builder.setType(ArtifactHandler.getOptionalStringValue((Attributes)attrs, (String)"type"));
        String tmp = ArtifactHandler.getOptionalStringValue((Attributes)attrs, (String)"base");
        if (tmp != null) {
            builder.setBase(Path.fromPortableString((String)tmp));
        }
        if ((pathStr = ArtifactHandler.getOptionalStringValue((Attributes)attrs, (String)"path")) != null) {
            try {
                builder.addPath(Path.fromPortableString((String)pathStr));
            }
            catch (PathAlreadyDefinedException e) {
                throw new SAXParseException(e.getMessage(), this.getDocumentLocator());
            }
        }
    }
}

