/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.parser;

import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.cspec.builder.ActionArtifactBuilder;
import org.eclipse.buckminster.core.cspec.builder.ActionBuilder;
import org.eclipse.buckminster.core.cspec.builder.AttributeBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.builder.TopLevelAttributeBuilder;
import org.eclipse.buckminster.core.cspec.model.AttributeAlreadyDefinedException;
import org.eclipse.buckminster.core.cspec.model.UpToDatePolicy;
import org.eclipse.buckminster.core.cspec.parser.ActionHandler;
import org.eclipse.buckminster.core.cspec.parser.ArtifactHandler;
import org.eclipse.buckminster.core.cspec.parser.CSpecElementHandler;
import org.eclipse.buckminster.core.cspec.parser.IAttributeBuilderSupport;
import org.eclipse.buckminster.core.cspec.parser.ICSpecBuilderSupport;
import org.eclipse.buckminster.core.cspec.parser.PathHandler;
import org.eclipse.buckminster.core.parser.ExtensionAwareHandler;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.buckminster.sax.ChildHandler;
import org.eclipse.buckminster.sax.ChildPoppedListener;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ProductsHandler
extends ExtensionAwareHandler
implements ChildPoppedListener,
ICSpecBuilderSupport,
IAttributeBuilderSupport {
    public static final String TAG = "products";
    private final PathHandler m_pathHandler = new PathHandler((AbstractHandler)this);
    private final ProductArtifactHandler m_privateHandler = new ProductArtifactHandler((AbstractHandler)this, false);
    private final ProductArtifactHandler m_publicHandler = new ProductArtifactHandler((AbstractHandler)this, true);

    ProductsHandler(AbstractHandler parent) {
        super(parent);
    }

    final void addProductArtifact(AttributeBuilder artifact) throws SAXException {
        try {
            this.getCSpecBuilder().addAttribute(artifact);
        }
        catch (AttributeAlreadyDefinedException e) {
            throw new SAXParseException(e.getMessage(), this.getDocumentLocator());
        }
    }

    public void childPopped(ChildHandler child) throws SAXException {
        if (child == this.m_pathHandler) {
            ((ActionBuilder)this.getAttributeBuilder()).addProductPath(this.m_pathHandler.getPath());
        } else if (child == this.m_publicHandler) {
            this.addProductArtifact(this.m_publicHandler.getAttributeBuilder());
        } else if (child == this.m_privateHandler) {
            this.addProductArtifact(this.m_privateHandler.getAttributeBuilder());
        }
    }

    public ChildHandler createHandler(String uri, String localName, Attributes attrs) throws SAXException {
        ExtensionAwareHandler ch = null;
        ch = "path".equals(localName) ? this.m_pathHandler : ("public".equals(localName) ? this.m_publicHandler : ("private".equals(localName) ? this.m_privateHandler : super.createHandler(uri, localName, attrs)));
        return ch;
    }

    final String getActionName() {
        return ((CSpecElementHandler)this.getParentHandler()).getBuilder().getName();
    }

    public TopLevelAttributeBuilder getAttributeBuilder() {
        return ((IAttributeBuilderSupport)this.getParentHandler()).getAttributeBuilder();
    }

    public CSpecBuilder getCSpecBuilder() {
        return ((ICSpecBuilderSupport)this.getParentHandler()).getCSpecBuilder();
    }

    public void handleAttributes(Attributes attrs) throws SAXException {
        ActionHandler parent = (ActionHandler)this.getParentHandler();
        parent.setProductAlias(ProductsHandler.getOptionalStringValue((Attributes)attrs, (String)"alias"));
        parent.setProductFileCount(ProductsHandler.getOptionalIntValue((Attributes)attrs, (String)"fileCount", (int)-1));
        String tmp = ProductsHandler.getOptionalStringValue((Attributes)attrs, (String)"base");
        if (tmp != null) {
            parent.setProductBase(Path.fromPortableString((String)tmp));
        }
        if ((tmp = ProductsHandler.getOptionalStringValue((Attributes)attrs, (String)"upToDatePolicy")) != null) {
            try {
                parent.setUpToDatePolicy(UpToDatePolicy.valueOf(tmp));
            }
            catch (IllegalArgumentException e) {
                throw new SAXParseException(NLS.bind((String)Messages._0_is_not_a_valid_UpToDatePolicy, (Object)tmp), this.getDocumentLocator());
            }
        }
    }

    public static class ProductArtifactHandler
    extends ArtifactHandler {
        public ProductArtifactHandler(AbstractHandler parent, boolean publ) {
            super(parent, publ);
        }

        protected TopLevelAttributeBuilder createAttributeBuilder() {
            return this.getCSpecBuilder().createActionArtifactBuilder();
        }

        public void handleAttributes(Attributes attrs) throws SAXException {
            super.handleAttributes(attrs);
            ((ActionArtifactBuilder)this.getBuilder()).setActionName(((ProductsHandler)this.getParentHandler()).getActionName());
        }
    }
}

