/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspecext.builder;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.cspec.builder.ActionBuilder;
import org.eclipse.buckminster.core.cspec.builder.GroupBuilder;
import org.eclipse.buckminster.core.cspec.builder.PrerequisiteBuilder;
import org.eclipse.buckminster.core.cspec.model.Action;
import org.eclipse.buckminster.core.cspec.model.Prerequisite;
import org.eclipse.buckminster.core.cspec.model.PrerequisiteAlreadyDefinedException;
import org.eclipse.buckminster.core.cspecext.builder.AlterAttributeBuilder;
import org.eclipse.buckminster.core.cspecext.model.AlterAction;
import org.eclipse.buckminster.core.cspecext.model.AlterAttribute;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlterActionBuilder
extends AlterAttributeBuilder {
    private final HashMap<String, Prerequisite> m_alteredPrerequisites = new HashMap();
    private final HashSet<String> m_removedPrerequisites = new HashSet();
    private final ExpandingProperties<String> m_alteredActorProperties = new ExpandingProperties();
    private final HashSet<String> m_removedActorProperties = new HashSet();
    private final ExpandingProperties<String> m_alteredProperties = new ExpandingProperties();
    private final HashSet<String> m_removedProperties = new HashSet();
    private final HashSet<IPath> m_removedPaths = new HashSet();

    public AlterActionBuilder(ActionBuilder baseBuilder) {
        super(baseBuilder);
    }

    public void addAlterActorProperty(String key, String value) {
        this.m_alteredActorProperties.put(key, value);
    }

    public void addAlterPrerequisite(Prerequisite value) throws PrerequisiteAlreadyDefinedException {
        String key = value.toString();
        if (this.m_alteredPrerequisites.containsKey(key)) {
            throw new PrerequisiteAlreadyDefinedException(this.getCSpecName(), this.getName(), key);
        }
        List<PrerequisiteBuilder> basePreqs = ((ActionBuilder)this.getBaseBuilder()).getPrerequisitesBuilder().getPrerequisites();
        if (GroupBuilder.indexOfPrerequisite(basePreqs, key) >= 0) {
            throw new PrerequisiteAlreadyDefinedException(this.getCSpecName(), this.getName(), key);
        }
        this.m_alteredPrerequisites.put(key, value);
    }

    public void addAlterProperty(String key, String value) {
        this.m_alteredProperties.put(key, value);
    }

    public void addRemoveActorProperty(String key) {
        this.m_removedActorProperties.add(key);
    }

    public void addRemovePrerequisite(String key) {
        this.m_removedPrerequisites.add(key);
    }

    public void addRemoveProductPath(IPath path) {
        this.m_removedPaths.add(path);
    }

    public void addRemoveProperty(String key) {
        this.m_removedProperties.add(key);
    }

    @Override
    public void clear() {
        super.clear();
        this.m_alteredPrerequisites.clear();
        this.m_removedPrerequisites.clear();
        this.m_alteredActorProperties.clear();
        this.m_removedActorProperties.clear();
        this.m_alteredProperties.clear();
        this.m_removedProperties.clear();
        this.m_removedPaths.clear();
    }

    @Override
    public AlterAttribute<?> createAlterAttribute() {
        return new AlterAction(this.createBase(), this.getRemovedHints(), this.getAlteredHints(), this.m_removedPrerequisites, this.m_alteredPrerequisites, this.m_removedActorProperties, this.m_alteredActorProperties, this.m_removedProperties, this.m_alteredProperties, this.m_removedPaths);
    }

    public ExpandingProperties<String> getAlterActorProperties() {
        return this.m_alteredActorProperties;
    }

    public ExpandingProperties<String> getAlterProperties() {
        return this.m_alteredProperties;
    }

    @Override
    Action createBase() {
        return ((ActionBuilder)this.getBaseBuilder()).createAttribute();
    }
}

