/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspecext.builder;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.model.AttributeAlreadyDefinedException;
import org.eclipse.buckminster.core.cspec.model.DependencyAlreadyDefinedException;
import org.eclipse.buckminster.core.cspec.model.TopLevelAttribute;
import org.eclipse.buckminster.core.cspecext.builder.AlterAttributeBuilder;
import org.eclipse.buckminster.core.cspecext.builder.AlterDependencyBuilder;
import org.eclipse.buckminster.core.cspecext.model.AlterAttribute;
import org.eclipse.buckminster.core.cspecext.model.AlterDependency;
import org.eclipse.buckminster.core.cspecext.model.CSpecExtension;
import org.eclipse.core.runtime.CoreException;

public class AlterCSpecBuilder {
    private final CSpecBuilder m_baseBuilder;
    private final HashSet<String> m_removedDependencies = new HashSet();
    private final HashSet<String> m_removedAttributes = new HashSet();
    private final Map<String, AlterAttributeBuilder> m_alteredAttributes = new HashMap<String, AlterAttributeBuilder>();
    private final Map<String, AlterDependencyBuilder> m_alteredDependencies = new HashMap<String, AlterDependencyBuilder>();
    private String m_name;

    public AlterCSpecBuilder(CSpecBuilder baseBuilder) {
        this.m_baseBuilder = baseBuilder;
    }

    public void addAlterAttribute(AlterAttributeBuilder value) throws AttributeAlreadyDefinedException {
        String key = value.getName();
        if (this.m_alteredAttributes.containsKey(key)) {
            throw new AttributeAlreadyDefinedException(this.m_name, key);
        }
        this.m_alteredAttributes.put(key, value);
    }

    public void addAlterDependency(AlterDependencyBuilder value) throws DependencyAlreadyDefinedException {
        String key = value.getName();
        if (this.m_alteredDependencies.containsKey(key)) {
            throw new DependencyAlreadyDefinedException(this.m_name, key);
        }
        this.m_alteredDependencies.put(key, value);
    }

    public void addRemoveAttribute(String key) {
        this.m_removedAttributes.add(key);
    }

    public void addRemoveDependency(String key) {
        this.m_removedDependencies.add(key);
    }

    public void clear() {
        this.m_removedAttributes.clear();
        this.m_alteredAttributes.clear();
        this.m_removedDependencies.clear();
        this.m_alteredDependencies.clear();
        this.m_baseBuilder.clear();
        this.m_name = null;
    }

    public CSpecExtension createAlteredCSpec() throws CoreException {
        HashMap<String, AlterAttribute<? extends TopLevelAttribute>> alterAttributes = new HashMap<String, AlterAttribute<? extends TopLevelAttribute>>(this.m_alteredAttributes.size());
        for (Map.Entry<String, AlterAttributeBuilder> entry : this.m_alteredAttributes.entrySet()) {
            alterAttributes.put(entry.getKey(), entry.getValue().createAlterAttribute());
        }
        HashMap<String, AlterDependency> alterDependencies = new HashMap<String, AlterDependency>(this.m_alteredDependencies.size());
        for (Map.Entry<String, AlterDependencyBuilder> entry : this.m_alteredDependencies.entrySet()) {
            alterDependencies.put(entry.getKey(), entry.getValue().createAlterDependency());
        }
        return new CSpecExtension(this.m_baseBuilder.createCSpec(), this.m_removedDependencies, alterDependencies, this.m_removedAttributes, alterAttributes);
    }

    public CSpecBuilder getBaseBuilder() {
        return this.m_baseBuilder;
    }

    public final String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }
}

