/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspecext.model;

import java.util.Map;
import java.util.Set;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.cspec.IAction;
import org.eclipse.buckminster.core.cspec.builder.ActionBuilder;
import org.eclipse.buckminster.core.cspec.builder.PrerequisitesBuilder;
import org.eclipse.buckminster.core.cspec.builder.TopLevelAttributeBuilder;
import org.eclipse.buckminster.core.cspec.model.Action;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.Prerequisite;
import org.eclipse.buckminster.core.cspecext.model.AlterAttribute;
import org.eclipse.buckminster.core.cspecext.model.AlterGroup;
import org.eclipse.buckminster.core.cspecext.model.CSpecExtension;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlterAction
extends AlterAttribute<Action> {
    public static final String ELEM_ALTER_PREREQUISITES = "alterPrerequisites";
    public static final String ELEM_ALTER_ACTOR_PROPERTIES = "alterActorProperties";
    public static final String ELEM_ALTER_PROPERTIES = "alterProperties";
    public static final String ELEM_ALTER_PRODUCTS = "alterProducts";
    public static final String ELEM_REMOVE_PRODUCT_PATH = "removeProductPath";
    public static final String ELEM_REMOVE_ATTRIBUTE = "removeAttribute";
    private final Map<String, String> m_alteredActorProperties;
    private final Set<String> m_removedActorProperties;
    private final Map<String, String> m_alteredProperties;
    private final Set<String> m_removedProperties;
    private final Set<IPath> m_removedPaths;
    private final Map<String, Prerequisite> m_alteredPrerequisites;
    private final Set<String> m_removedPrerequisites;

    public AlterAction(Action base, Set<String> removedHints, Map<String, String> alteredHints, Set<String> removedPrerequisites, Map<String, Prerequisite> alteredPrerequisites, Set<String> removedActorProperties, Map<String, String> alteredActorProperties, Set<String> removedProperties, Map<String, String> alteredProperties, Set<IPath> removedPaths) {
        super(base, removedHints, alteredHints);
        this.m_alteredPrerequisites = Utils.createUnmodifiableMap(alteredPrerequisites);
        this.m_removedPrerequisites = Utils.createUnmodifiableSet(removedPrerequisites);
        this.m_alteredActorProperties = ExpandingProperties.createUnmodifiableProperties(alteredActorProperties);
        this.m_removedActorProperties = Utils.createUnmodifiableSet(removedActorProperties);
        this.m_alteredProperties = ExpandingProperties.createUnmodifiableProperties(alteredProperties);
        this.m_removedProperties = Utils.createUnmodifiableSet(removedProperties);
        this.m_removedPaths = CSpec.createUnmodifiablePaths(removedPaths);
    }

    protected void alterActorProperties(ActionBuilder original) throws CoreException {
        AlterAction.performPropertyAlterations(original.getCSpecName(), original.getName(), "actorProperty", original.getActorProperties(), this.m_alteredActorProperties, ((Action)this.getBase()).getActorProperties(), this.m_removedActorProperties);
    }

    @Override
    public void alterAttribute(TopLevelAttributeBuilder attrBld) throws CoreException {
        ActionBuilder actionBld = (ActionBuilder)attrBld;
        IAction base = (IAction)this.getBase();
        PrerequisitesBuilder groupBld = actionBld.getPrerequisitesBuilder();
        AlterGroup ag = new AlterGroup(((Action)this.getBase()).getPrerequisiteGroup(), null, null, this.m_removedPrerequisites, this.m_alteredPrerequisites);
        ag.alterAttribute(groupBld);
        this.alterProductPaths(actionBld);
        this.alterInstallerHints(actionBld);
        this.alterActorProperties(actionBld);
        this.alterProperties(actionBld);
        this.alterDocumentation(actionBld);
        actionBld.setProductAlias(CSpecExtension.overrideCheckNull(actionBld.getProductAlias(), base.getProductAlias()));
        actionBld.setProductBase(CSpecExtension.overrideCheckNull(actionBld.getProductBase(), base.getProductBase()));
    }

    protected void alterProductPaths(ActionBuilder original) throws CoreException {
        AlterAction.alterPaths(original.getCSpecName(), original.getName(), original.getProductPaths(), ((Action)this.getBase()).getProductPaths(), this.m_removedPaths);
    }

    protected void alterProperties(ActionBuilder original) throws CoreException {
        AlterAction.performPropertyAlterations(original.getCSpecName(), original.getName(), "property", original.getProperties(), this.m_alteredProperties, ((Action)this.getBase()).getProperties(), this.m_removedProperties);
    }
}

