/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspecext.model;

import java.util.Map;
import java.util.Set;
import org.eclipse.buckminster.core.common.model.Documentation;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.cspec.builder.MissingPathException;
import org.eclipse.buckminster.core.cspec.builder.TopLevelAttributeBuilder;
import org.eclipse.buckminster.core.cspec.model.Attribute;
import org.eclipse.buckminster.core.cspec.model.NamedElement;
import org.eclipse.buckminster.core.cspec.model.PathAlreadyDefinedException;
import org.eclipse.buckminster.core.cspec.model.PropertyAlreadyDefinedException;
import org.eclipse.buckminster.core.cspec.model.TopLevelAttribute;
import org.eclipse.buckminster.core.cspecext.model.MissingPropertyException;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AlterAttribute<T extends TopLevelAttribute> {
    public static final String ELEM_ALTER_INSTALLER_HINTS = "alterInstallerHints";
    private final T m_base;
    private final Map<String, String> m_alteredHints;
    private final Set<String> m_removedHints;

    static void alterPaths(String compName, String attrName, Set<IPath> original, Set<IPath> added, Set<IPath> removed) throws CoreException {
        if (!added.isEmpty() || !removed.isEmpty()) {
            for (IPath path : removed) {
                if (original.contains(path)) continue;
                throw new MissingPathException(compName, attrName, path);
            }
            for (IPath path : added) {
                if (!original.contains(path)) continue;
                throw new PathAlreadyDefinedException(compName, attrName, path);
            }
            original.addAll(original);
            original.removeAll(removed);
            original.addAll(added);
        }
    }

    static void performPropertyAlterations(String compName, String attrName, String propertyCategory, Map<String, String> original, Map<String, String> altered, Map<String, String> added, Set<String> removed) throws CoreException {
        if (removed.isEmpty() && altered.isEmpty() && added.isEmpty()) {
            return;
        }
        for (String key : removed) {
            if (original.containsKey(key)) continue;
            throw new MissingPropertyException(compName, attrName, propertyCategory, key);
        }
        for (String key : altered.keySet()) {
            if (original.containsKey(key)) continue;
            throw new MissingPropertyException(compName, attrName, propertyCategory, key);
        }
        for (String key : added.keySet()) {
            if (!original.containsKey(key)) continue;
            throw new PropertyAlreadyDefinedException(compName, attrName, propertyCategory, key);
        }
        for (String key : removed) {
            original.remove(key);
        }
        original.putAll(added);
        original.putAll(altered);
    }

    protected AlterAttribute(T base, Set<String> removedHints, Map<String, String> alteredHints) {
        this.m_base = base;
        this.m_removedHints = Utils.createUnmodifiableSet(removedHints);
        this.m_alteredHints = ExpandingProperties.createUnmodifiableProperties(alteredHints);
    }

    public abstract void alterAttribute(TopLevelAttributeBuilder var1) throws CoreException;

    public void alterDocumentation(TopLevelAttributeBuilder original) {
        Documentation origDoc = original.getDocumentation();
        Documentation baseDoc = ((Attribute)this.m_base).getDocumentation();
        original.setDocumentation(origDoc == null ? baseDoc : origDoc.merge(baseDoc));
    }

    public void alterInstallerHints(TopLevelAttributeBuilder original) throws CoreException {
        AlterAttribute.performPropertyAlterations(original.getCSpecName(), original.getName(), "installer hint", original.getInstallerHints(), this.m_alteredHints, ((TopLevelAttribute)this.m_base).getInstallerHints(), this.m_removedHints);
    }

    protected final T getBase() {
        return this.m_base;
    }

    public String getName() {
        return ((NamedElement)((Object)this.m_base)).getName();
    }

    public boolean isTypeConformant(TopLevelAttribute origAttr) {
        return origAttr.getClass().equals(this.m_base.getClass());
    }
}

