/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspecext.model;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.buckminster.core.cspec.IPrerequisite;
import org.eclipse.buckminster.core.cspec.builder.GroupBuilder;
import org.eclipse.buckminster.core.cspec.builder.PrerequisiteBuilder;
import org.eclipse.buckminster.core.cspec.builder.TopLevelAttributeBuilder;
import org.eclipse.buckminster.core.cspec.model.Group;
import org.eclipse.buckminster.core.cspec.model.Prerequisite;
import org.eclipse.buckminster.core.cspec.model.PrerequisiteAlreadyDefinedException;
import org.eclipse.buckminster.core.cspecext.model.AlterAttribute;
import org.eclipse.buckminster.core.cspecext.model.CSpecExtension;
import org.eclipse.buckminster.core.cspecext.model.MissingPrerequisiteException;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlterGroup
extends AlterAttribute<Group> {
    public static final String ELEM_ALTER_ATTRIBUTE = "alterAttribute";
    public static final String ELEM_REMOVE = "remove";
    private final Map<String, Prerequisite> m_alteredPrerequisites;
    private final Set<String> m_removedPrerequisites;

    public AlterGroup(Group base, Set<String> removedHints, Map<String, String> alteredHints, Set<String> removedPrerequisites, Map<String, Prerequisite> alteredPrerequisites) {
        super(base, removedHints, alteredHints);
        this.m_removedPrerequisites = Utils.createUnmodifiableSet(removedPrerequisites);
        this.m_alteredPrerequisites = Utils.createUnmodifiableMap(alteredPrerequisites);
    }

    @Override
    public void alterAttribute(TopLevelAttributeBuilder original) throws CoreException {
        Group base = (Group)this.getBase();
        GroupBuilder gBld = (GroupBuilder)original;
        this.alterInstallerHints(gBld);
        this.alterPrerequisiteMap(gBld);
        this.alterDocumentation(gBld);
        gBld.setPrerequisiteRebase(CSpecExtension.overrideCheckNull(gBld.getPrerequisiteRebase(), base.getPrerequisiteRebase()));
    }

    protected void alterPrerequisiteMap(GroupBuilder original) throws CoreException {
        Group base = (Group)this.getBase();
        String attrName = original.getName();
        String compName = original.getCSpecName();
        List<PrerequisiteBuilder> pqs = original.getPrerequisites();
        List<Prerequisite> addedPqs = base.getPrerequisites();
        if (!(addedPqs.isEmpty() && this.m_alteredPrerequisites.isEmpty() && this.m_removedPrerequisites.isEmpty())) {
            for (String string : this.m_removedPrerequisites) {
                if (GroupBuilder.indexOfPrerequisite(pqs, string) >= 0) continue;
                throw new MissingPrerequisiteException(compName, attrName, string);
            }
            for (String string : this.m_alteredPrerequisites.keySet()) {
                if (GroupBuilder.indexOfPrerequisite(pqs, string) >= 0) continue;
                throw new MissingPrerequisiteException(compName, attrName, string);
            }
            for (IPrerequisite iPrerequisite : addedPqs) {
                String pqName = iPrerequisite.toString();
                if (GroupBuilder.indexOfPrerequisite(pqs, pqName) < 0) continue;
                throw new PrerequisiteAlreadyDefinedException(compName, attrName, pqName);
            }
            for (String string : this.m_removedPrerequisites) {
                pqs.remove(string);
            }
            for (IPrerequisite iPrerequisite : this.m_alteredPrerequisites.values()) {
                pqs.get(GroupBuilder.indexOfPrerequisite(pqs, iPrerequisite.toString())).initFrom(iPrerequisite);
            }
            for (Prerequisite prerequisite : addedPqs) {
                PrerequisiteBuilder bld = original.createPrerequisiteBuilder();
                bld.initFrom(prerequisite);
                original.addPrerequisite(bld);
            }
        }
    }
}

