/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.ctype;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.builder.GroupBuilder;
import org.eclipse.buckminster.core.cspec.model.AttributeAlreadyDefinedException;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.cspec.model.PrerequisiteAlreadyDefinedException;
import org.eclipse.buckminster.core.ctype.ComponentTypeMismatchException;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.ctype.IMetaFile;
import org.eclipse.buckminster.core.ctype.IResolutionBuilder;
import org.eclipse.buckminster.core.helpers.AbstractExtension;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.core.metadata.model.BOMNode;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.version.IVersion;
import org.eclipse.buckminster.core.version.IVersionDesignator;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractComponentType
extends AbstractExtension
implements IComponentType {
    private static final IMetaFile[] s_noMetaFiles = new IMetaFile[0];
    private Pattern m_desiredNamePattern;
    private IMetaFile[] m_metaFiles = s_noMetaFiles;
    private String m_nameSubstitution;
    private IPath m_relativeLocation;
    private Pattern m_substituteNamePattern;

    public static GroupBuilder addSelfAsJarArtifactGroups(CSpecBuilder cspec) throws PrerequisiteAlreadyDefinedException, AttributeAlreadyDefinedException {
        GroupBuilder archives = cspec.createGroupBuilder();
        archives.setName("java.binary.archives");
        archives.setPublic(true);
        archives.addSelfRequirement();
        cspec.addAttribute(archives);
        GroupBuilder generic = cspec.createGroupBuilder();
        generic.setName("java.binaries");
        generic.setPublic(true);
        generic.addLocalPrerequisite(archives);
        cspec.addAttribute(generic);
        return generic;
    }

    public static String[] getComponentTypeIDs(boolean includeEmptyEntry) {
        IConfigurationElement[] elems = AbstractComponentType.getElements();
        int idx = elems.length;
        ArrayList<String> names = new ArrayList<String>(idx + 1);
        if (includeEmptyEntry) {
            names.add("");
        }
        while (--idx >= 0) {
            names.add(elems[idx].getAttribute("id"));
        }
        Collections.sort(names);
        return names.toArray(new String[names.size()]);
    }

    public static IComponentType[] getComponentTypes() throws CoreException {
        CorePlugin plugin = CorePlugin.getDefault();
        String[] cids = AbstractComponentType.getComponentTypeIDs(false);
        int idx = cids.length;
        IComponentType[] ctypes = new IComponentType[idx];
        while (--idx >= 0) {
            ctypes[idx] = plugin.getComponentType(cids[idx]);
        }
        return ctypes;
    }

    private static IConfigurationElement[] getElements() {
        IExtensionRegistry exReg = Platform.getExtensionRegistry();
        return exReg.getConfigurationElementsFor("org.eclipse.buckminster.core.componentTypes");
    }

    public IVersion getComponentVersion(ProviderMatch rInfo, IProgressMonitor monitor) throws CoreException {
        BOMNode node = this.getResolution(rInfo, true, monitor);
        return node.getResolution().getComponentIdentifier().getVersion();
    }

    public Pattern getDesiredNamePattern() {
        return this.m_desiredNamePattern;
    }

    public IMetaFile[] getMetaFiles() {
        return this.m_metaFiles;
    }

    public String getNameSubstitution() {
        return this.m_nameSubstitution;
    }

    public String getProjectName(String componentName) throws CoreException {
        String repl;
        if (componentName == null) {
            return null;
        }
        Pattern desiredMatch = this.getDesiredNamePattern();
        if (desiredMatch == null || desiredMatch.matcher(componentName).find()) {
            return componentName;
        }
        Pattern repFrom = this.getSubstituteNamePattern();
        String repTo = this.getNameSubstitution();
        if (repFrom == null || repTo == null) {
            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.Component_type_0_defines_desiredNamePattern_but_no_substitution, (Object)this.getId()), (Object[])new Object[0]);
        }
        Matcher matcher = repFrom.matcher(componentName);
        if (matcher.matches() && (repl = matcher.replaceAll(repTo).trim()).length() > 0) {
            componentName = repl;
        }
        return componentName;
    }

    public IPath getRelativeLocation() {
        return this.m_relativeLocation;
    }

    protected BOMNode getResolution(ProviderMatch rInfo, boolean forResolutionAidOnly, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(null, 2000);
        IComponentReader[] reader = new IComponentReader[1];
        try {
            reader[0] = rInfo.getReader(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)200));
            ComponentRequest request = rInfo.getNodeQuery().getComponentRequest();
            String componentType = request.getComponentTypeID();
            if (componentType != null && !this.getId().equals(componentType)) {
                throw new ComponentTypeMismatchException(request.getName(), componentType, this.getId());
            }
            IResolutionBuilder builder = this.getResolutionBuilder(reader[0], MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)800));
            BOMNode bOMNode = builder.build(reader, forResolutionAidOnly, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1000));
            return bOMNode;
        }
        finally {
            IOUtils.close((Closeable)reader[0]);
        }
    }

    public final BOMNode getResolution(ProviderMatch rInfo, IProgressMonitor monitor) throws CoreException {
        return this.getResolution(rInfo, false, monitor);
    }

    public Pattern getSubstituteNamePattern() {
        return this.m_substituteNamePattern;
    }

    public IVersionDesignator getTypeSpecificDesignator(IVersionDesignator designator) {
        return designator;
    }

    public boolean hasAllRequiredMetaFiles(IPath path) {
        IMetaFile[] iMetaFileArray = this.getMetaFiles();
        int n = iMetaFileArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMetaFile metaFile = iMetaFileArray[n2];
            if (!metaFile.isOptional() && !path.append(metaFile.getPath()).toFile().exists()) {
                boolean found = false;
                IPath[] iPathArray = metaFile.getAliases();
                int n3 = iPathArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IPath alias = iPathArray[n4];
                    if (path.append(alias).toFile().exists()) {
                        found = true;
                        break;
                    }
                    ++n4;
                }
                if (!found) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    public boolean isMetaFileBased() {
        IMetaFile[] iMetaFileArray = this.getMetaFiles();
        int n = iMetaFileArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMetaFile metaFile = iMetaFileArray[n2];
            if (!metaFile.isOptional()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setExtensionParameter(String key, String value) throws CoreException {
        if ("relativeLocation".equals(key)) {
            this.m_relativeLocation = value == null ? null : Path.fromPortableString((String)value);
        } else if ("desiredNamePattern".equals(key)) {
            this.m_desiredNamePattern = value == null ? null : Pattern.compile(value);
        } else if ("substituteNamePattern".equals(key)) {
            this.m_substituteNamePattern = value == null ? null : Pattern.compile(value);
        } else if ("nameSubstitution".equals(key)) {
            this.m_nameSubstitution = value;
        } else {
            super.setExtensionParameter(key, value);
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        super.setInitializationData(config, propertyName, data);
        String tmp = config.getAttribute("relativeLocation");
        this.m_relativeLocation = tmp == null ? null : Path.fromPortableString((String)tmp);
        tmp = config.getAttribute("desiredNamePattern");
        this.m_desiredNamePattern = tmp == null ? null : Pattern.compile(tmp);
        tmp = config.getAttribute("substituteNamePattern");
        this.m_substituteNamePattern = tmp == null ? null : Pattern.compile(tmp);
        this.m_nameSubstitution = config.getAttribute("nameSubstitution");
        ArrayList<MetaFile> metaFiles = null;
        IConfigurationElement[] iConfigurationElementArray = config.getChildren("metaFile");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement metaFile = iConfigurationElementArray[n2];
            tmp = metaFile.getAttribute("path");
            if (tmp != null && (tmp = tmp.trim()).length() == 0) {
                tmp = null;
            }
            if (tmp != null) {
                IPath[] aliases;
                IPath path = Path.fromPortableString((String)tmp);
                boolean optional = "true".equalsIgnoreCase(metaFile.getAttribute("optional"));
                ArrayList<Path> aliasesBld = null;
                String[] stringArray = TextUtils.split(metaFile.getAttribute("aliases"), ",");
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String alias = stringArray[n4];
                    if ((alias = alias.trim()).length() > 0) {
                        if (aliasesBld == null) {
                            aliasesBld = new ArrayList<Path>();
                        }
                        aliasesBld.add(new Path(alias));
                    }
                    ++n4;
                }
                IPath[] iPathArray = aliases = aliasesBld == null ? Trivial.EMPTY_PATH_ARRAY : aliasesBld.toArray(new IPath[aliasesBld.size()]);
                if (metaFiles == null) {
                    metaFiles = new ArrayList<MetaFile>();
                }
                metaFiles.add(new MetaFile(path, optional, aliases));
            }
            ++n2;
        }
        this.m_metaFiles = metaFiles == null ? s_noMetaFiles : metaFiles.toArray(new IMetaFile[metaFiles.size()]);
    }

    static class MetaFile
    implements IMetaFile {
        private final IPath[] m_aliases;
        private final boolean m_optional;
        private final IPath m_path;

        public MetaFile(IPath path, boolean optional, IPath[] aliases) {
            this.m_path = path;
            this.m_optional = optional;
            this.m_aliases = aliases;
        }

        public IPath[] getAliases() {
            return this.m_aliases;
        }

        public IPath getPath() {
            return this.m_path;
        }

        public boolean isOptional() {
            return this.m_optional;
        }
    }
}

