/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.helpers;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.common.model.IProperties;
import org.eclipse.buckminster.core.helpers.MapUnion;
import org.eclipse.buckminster.core.helpers.PropertiesWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BMProperties
implements IProperties<String> {
    private static final IProperties<String> s_systemProperties = new PropertiesWrapper(){

        protected Properties getProperties() {
            return System.getProperties();
        }
    };
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private final Map<String, String> m_map;

    public static IProperties<String> getSystemProperties() {
        return s_systemProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store(Map<String, ? extends Object> props, OutputStream out, String comments) throws IOException {
        BufferedWriter awriter = new BufferedWriter(new OutputStreamWriter(out, "8859_1"));
        if (comments != null) {
            BMProperties.writeln(awriter, "#" + comments);
        }
        BMProperties.writeln(awriter, "#" + new Date().toString());
        Map<String, ? extends Object> map = props;
        synchronized (map) {
            for (Map.Entry<String, ? extends Object> e : props.entrySet()) {
                String key = e.getKey();
                key = BMProperties.saveConvert(key, true);
                BMProperties.writeln(awriter, String.valueOf(key) + "=" + BMProperties.saveConvert(e.getValue(), false));
            }
        }
        awriter.flush();
    }

    private static String saveConvert(Object value, boolean escapeSpace) {
        String theString = value.toString();
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuffer outBuffer = new StringBuffer(bufLen);
        int x = 0;
        while (x < len) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                } else {
                    outBuffer.append(aChar);
                }
            } else {
                switch (aChar) {
                    case ' ': {
                        if (x == 0 || escapeSpace) {
                            outBuffer.append('\\');
                        }
                        outBuffer.append(' ');
                        break;
                    }
                    case '\t': {
                        outBuffer.append('\\');
                        outBuffer.append('t');
                        break;
                    }
                    case '\n': {
                        outBuffer.append('\\');
                        outBuffer.append('n');
                        break;
                    }
                    case '\r': {
                        outBuffer.append('\\');
                        outBuffer.append('r');
                        break;
                    }
                    case '\f': {
                        outBuffer.append('\\');
                        outBuffer.append('f');
                        break;
                    }
                    case '!': 
                    case '#': 
                    case '=': {
                        outBuffer.append('\\');
                        outBuffer.append(aChar);
                        break;
                    }
                    default: {
                        if (aChar < ' ' || aChar > '~') {
                            outBuffer.append('\\');
                            outBuffer.append('u');
                            outBuffer.append(BMProperties.toHex(aChar >> 12 & 0xF));
                            outBuffer.append(BMProperties.toHex(aChar >> 8 & 0xF));
                            outBuffer.append(BMProperties.toHex(aChar >> 4 & 0xF));
                            outBuffer.append(BMProperties.toHex(aChar & 0xF));
                            break;
                        }
                        outBuffer.append(aChar);
                    }
                }
            }
            ++x;
        }
        return outBuffer.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    private static void writeln(BufferedWriter bw, String s) throws IOException {
        bw.write(s);
        bw.newLine();
    }

    public BMProperties() {
        this.m_map = new HashMap<String, String>();
    }

    public BMProperties(InputStream inStream) throws IOException {
        final Properties loader = new Properties();
        loader.load(inStream);
        this.m_map = new PropertiesWrapper(){

            protected Properties getProperties() {
                return loader;
            }
        };
    }

    public BMProperties(Map<String, String> defaultProps) {
        AbstractMap props = new HashMap<String, String>();
        if (defaultProps != null) {
            props = new MapUnion<String, String>(props, defaultProps);
        }
        this.m_map = props;
    }

    public BMProperties(Map<String, String> mutableProps, Map<String, String> defaultProps) {
        if (defaultProps != null) {
            mutableProps = new MapUnion<String, String>(mutableProps, defaultProps);
        }
        this.m_map = mutableProps;
    }

    public BMProperties(final Properties defaultProps) {
        this.m_map = new PropertiesWrapper(){

            protected Properties getProperties() {
                return defaultProps;
            }
        };
    }

    @Override
    public void clear() {
        this.m_map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.m_map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.m_map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.m_map.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this == o || o instanceof Map && o.equals(this.m_map);
    }

    @Override
    public String get(Object key) {
        return this.m_map.get(key);
    }

    @Override
    public int hashCode() {
        return this.m_map.hashCode();
    }

    @Override
    public Set<String> immutableKeySet() {
        return this.m_map instanceof IProperties ? ((IProperties)this.m_map).immutableKeySet() : this.m_map.keySet();
    }

    @Override
    public boolean isEmpty() {
        return this.m_map.isEmpty();
    }

    @Override
    public boolean isMutable(String key) {
        return this.m_map instanceof IProperties ? ((IProperties)this.m_map).isMutable(key) : true;
    }

    @Override
    public Set<String> keySet() {
        return this.m_map.keySet();
    }

    @Override
    public Set<String> mutableKeySet() {
        return this.m_map instanceof IProperties ? ((IProperties)this.m_map).mutableKeySet() : this.m_map.keySet();
    }

    @Override
    public Set<String> overlayKeySet() {
        if (this.m_map instanceof IProperties) {
            return ((IProperties)this.m_map).overlayKeySet();
        }
        if (this.m_map instanceof MapUnion) {
            return ((MapUnion)this.m_map).overlayKeySet();
        }
        return this.m_map.keySet();
    }

    @Override
    public String put(String key, String value) {
        return this.m_map.put(key, value);
    }

    @Override
    public String put(String key, String value, boolean mutable) {
        if (this.m_map instanceof IProperties) {
            return ((IProperties)this.m_map).put(key, value, mutable);
        }
        if (!mutable) {
            throw new UnsupportedOperationException(Messages.Put_immutable);
        }
        return this.m_map.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> t) {
        this.m_map.putAll(t);
    }

    @Override
    public String remove(Object key) {
        return this.m_map.remove(key);
    }

    @Override
    public void setMutable(String key, boolean flag) throws UnsupportedOperationException {
        if (this.m_map instanceof IProperties) {
            ((IProperties)this.m_map).setMutable(key, flag);
        } else if (!flag) {
            throw new UnsupportedOperationException(Messages.SetMutable);
        }
    }

    @Override
    public int size() {
        return this.m_map.size();
    }

    @Override
    public void store(OutputStream out, String comments) throws IOException {
        BMProperties.store(this.m_map, out, comments);
    }

    @Override
    public boolean supportsMutability() {
        return this.m_map instanceof IProperties ? ((IProperties)this.m_map).supportsMutability() : false;
    }

    @Override
    public Collection<String> values() {
        return this.m_map.values();
    }
}

