/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.helpers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.helpers.FileHandle;
import org.eclipse.buckminster.core.helpers.ShortDurationFileCache;
import org.eclipse.buckminster.runtime.FileInfoBuilder;
import org.eclipse.buckminster.runtime.IFileInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

class CacheEntry {
    private int m_openFileCounter = 0;
    private boolean m_removePending = false;
    private FileHandle m_tempFile;
    private IFileInfo m_fileInfo = null;

    CacheEntry() {
    }

    public synchronized void initialize(ShortDurationFileCache cache, ShortDurationFileCache.Materializer materializer, IProgressMonitor monitor, FileInfoBuilder fileInfo) throws CoreException, IOException {
        boolean success = false;
        try {
            if (this.m_tempFile == null) {
                this.m_tempFile = materializer.materialize(monitor, fileInfo);
                if (this.m_tempFile.isTemporary()) {
                    this.m_tempFile.getFile().deleteOnExit();
                }
                if (fileInfo != null) {
                    this.m_fileInfo = new FileInfoBuilder((IFileInfo)fileInfo);
                }
                cache.schedule(materializer.getKey());
            } else if (fileInfo != null && this.m_fileInfo != null) {
                fileInfo.initFrom(this.m_fileInfo);
            }
            success = true;
        }
        finally {
            if (!success) {
                cache.remove(materializer.getKey());
            }
        }
    }

    public synchronized InputStream open() throws FileNotFoundException {
        if (this.m_removePending) {
            throw new FileNotFoundException(Messages.File_is_closed);
        }
        if (this.m_tempFile.isTemporary()) {
            ++this.m_openFileCounter;
            return new DeletingInputStream(this.m_tempFile.getFile());
        }
        return new FileInputStream(this.m_tempFile.getFile());
    }

    public final synchronized void remove() {
        if (this.m_openFileCounter > 0) {
            this.m_removePending = true;
        } else if (this.m_tempFile != null && this.m_tempFile.isTemporary() && !this.m_removePending) {
            this.m_removePending = true;
            this.m_tempFile.getFile().delete();
        }
    }

    class DeletingInputStream
    extends FileInputStream {
        DeletingInputStream(File file) throws FileNotFoundException {
            super(file);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            try {
                super.close();
            }
            catch (Throwable throwable) {
                CacheEntry cacheEntry = CacheEntry.this;
                synchronized (cacheEntry) {
                    CacheEntry cacheEntry2 = CacheEntry.this;
                    int n = cacheEntry2.m_openFileCounter - 1;
                    cacheEntry2.m_openFileCounter = n;
                    if (n < 1 && CacheEntry.this.m_removePending) {
                        CacheEntry.this.m_tempFile.getFile().delete();
                    }
                }
                throw throwable;
            }
            CacheEntry cacheEntry = CacheEntry.this;
            synchronized (cacheEntry) {
                CacheEntry cacheEntry3 = CacheEntry.this;
                int n = cacheEntry3.m_openFileCounter - 1;
                cacheEntry3.m_openFileCounter = n;
                if (n < 1 && CacheEntry.this.m_removePending) {
                    CacheEntry.this.m_tempFile.getFile().delete();
                }
            }
        }
    }
}

