/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.helpers;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapUnion<K, V>
extends AbstractMap<K, V> {
    private final HashMap<K, K> m_antiMap;
    private final Map<K, V> m_immutable;
    private final Map<K, V> m_overlay;

    public MapUnion(Map<K, V> mutable, Map<? extends K, ? extends V> immutable) {
        this.m_overlay = mutable;
        this.m_immutable = immutable;
        this.m_antiMap = new HashMap();
    }

    private MapUnion(Map<K, V> mutable, Map<K, V> immutable, HashMap<K, K> antiMap) {
        this.m_overlay = mutable;
        this.m_immutable = immutable;
        int shadowCount = 0;
        for (K key : this.m_overlay.keySet()) {
            if (!this.m_immutable.containsKey(key)) continue;
            ++shadowCount;
        }
        this.m_antiMap = antiMap;
    }

    @Override
    public void clear() {
        this.m_overlay.clear();
        this.m_antiMap.clear();
        for (K key : this.m_immutable.keySet()) {
            this.m_antiMap.put(key, key);
        }
    }

    @Override
    public Object clone() {
        HashMap<K, V> mutable = new HashMap<K, V>();
        mutable.putAll(this.m_overlay);
        HashMap<K, K> antiMap = new HashMap<K, K>();
        antiMap.putAll(this.m_antiMap);
        return new MapUnion(mutable, this.m_immutable, antiMap);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.m_overlay.containsKey(key) || this.m_immutable.containsKey(key) && !this.m_antiMap.containsKey(key);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new EntryIterator();
            }

            @Override
            public int size() {
                return MapUnion.this.size();
            }
        };
    }

    @Override
    public V get(Object key) {
        V value = this.m_overlay.get(key);
        if (value == null && !this.m_overlay.containsKey(key) && (value = this.m_immutable.get(key)) != null && this.m_antiMap.containsKey(key)) {
            value = null;
        }
        return value;
    }

    @Override
    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return new KeyIterator();
            }

            @Override
            public int size() {
                return MapUnion.this.size();
            }
        };
    }

    public Set<K> overlayKeySet() {
        return this.m_overlay.keySet();
    }

    @Override
    public V put(K key, V value) {
        this.m_antiMap.remove(key);
        return this.m_overlay.put(key, value);
    }

    @Override
    public V remove(Object key) {
        V value = null;
        if (this.m_overlay.containsKey(key)) {
            if (this.m_immutable.containsKey(key)) {
                this.m_antiMap.put(key, key);
            }
            value = this.m_overlay.remove(key);
        } else if (this.m_immutable.containsKey(key) && !this.m_antiMap.containsKey(key)) {
            value = this.m_immutable.get(key);
            this.m_antiMap.put(key, key);
        }
        return value;
    }

    @Override
    public int size() {
        int immutableVisibleCount = 0;
        for (K key : this.m_immutable.keySet()) {
            if (this.m_overlay.containsKey(key) || this.m_antiMap.containsKey(key)) continue;
            ++immutableVisibleCount;
        }
        return this.m_overlay.size() + immutableVisibleCount;
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return new ValueIterator();
            }

            @Override
            public int size() {
                return MapUnion.this.size();
            }
        };
    }

    static /* synthetic */ Map access$1(MapUnion mapUnion) {
        return mapUnion.m_immutable;
    }

    static /* synthetic */ HashMap access$2(MapUnion mapUnion) {
        return mapUnion.m_antiMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class AbstractIterator<X>
    implements Iterator<X> {
        private Iterator<K> m_currentIterator;
        private K m_currentKey;
        private boolean m_phase1;

        AbstractIterator() {
            this.m_currentIterator = MapUnion.this.m_overlay.keySet().iterator();
            this.m_currentKey = null;
            this.m_phase1 = true;
        }

        @Override
        public boolean hasNext() {
            this.m_currentKey = this.getValidKey(this.m_currentKey);
            return this.m_currentKey != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        K nextKey() {
            Object key = this.getValidKey(this.m_currentKey);
            if (key == null) {
                throw new NoSuchElementException();
            }
            this.m_currentKey = null;
            return key;
        }

        /*
         * Unable to fully structure code
         */
        private K getValidKey(K key) {
            if (this.m_phase1) {
                if (key != null) {
                    return key;
                }
                if (this.m_currentIterator.hasNext()) {
                    return this.m_currentIterator.next();
                }
                this.m_currentIterator = MapUnion.access$1(MapUnion.this).keySet().iterator();
                this.m_phase1 = false;
            }
            if (key == null || MapUnion.access$0(MapUnion.this).containsKey(key) || MapUnion.access$2(MapUnion.this).containsKey(key)) ** GOTO lbl13
            return key;
lbl-1000:
            // 1 sources

            {
                key = this.m_currentIterator.next();
                if (MapUnion.access$0(MapUnion.this).containsKey(key) || MapUnion.access$2(MapUnion.this).containsKey(key)) continue;
                return key;
lbl13:
                // 2 sources

                ** while (this.m_currentIterator.hasNext())
            }
lbl14:
            // 1 sources

            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EntryIterator
    extends AbstractIterator<Map.Entry<K, V>> {
        EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return new UnionEntry(this.nextKey());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class KeyIterator
    extends AbstractIterator<K> {
        KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextKey();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class UnionEntry
    implements Map.Entry<K, V> {
        private final K m_key;

        public UnionEntry(K key) {
            this.m_key = key;
        }

        @Override
        public K getKey() {
            return this.m_key;
        }

        @Override
        public V getValue() {
            return MapUnion.this.get(this.m_key);
        }

        @Override
        public V setValue(V value) {
            return MapUnion.this.put(this.m_key, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ValueIterator
    extends AbstractIterator<V> {
        ValueIterator() {
        }

        @Override
        public V next() {
            return MapUnion.this.get(this.nextKey());
        }
    }
}

