/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.helpers;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnmodifiableMapUnion<K, V>
extends AbstractMap<K, V> {
    private final Map<? extends K, ? extends V> m_map;
    private final Map<? extends K, ? extends V> m_overlay;

    public UnmodifiableMapUnion(Map<? extends K, ? extends V> overlay, Map<? extends K, ? extends V> map) {
        this.m_overlay = overlay;
        this.m_map = map;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.m_overlay.containsKey(key) || this.m_map.containsKey(key);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new EntryIterator();
            }

            @Override
            public int size() {
                return UnmodifiableMapUnion.this.size();
            }
        };
    }

    @Override
    public V get(Object key) {
        V value = this.m_overlay.get(key);
        if (value == null && !this.m_overlay.containsKey(key)) {
            value = this.m_map.get(key);
        }
        return value;
    }

    @Override
    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return new KeyIterator();
            }

            @Override
            public int size() {
                return UnmodifiableMapUnion.this.size();
            }
        };
    }

    public Set<? extends K> overlayKeySet() {
        return this.m_overlay.keySet();
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        int immutableVisibleCount = 0;
        for (K key : this.m_map.keySet()) {
            if (this.m_overlay.containsKey(key)) continue;
            ++immutableVisibleCount;
        }
        return this.m_overlay.size() + immutableVisibleCount;
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return new ValueIterator();
            }

            @Override
            public int size() {
                return UnmodifiableMapUnion.this.size();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class AbstractIterator<X>
    implements Iterator<X> {
        private Iterator<? extends K> m_currentIterator;
        private K m_currentKey;
        private boolean m_phase1;

        AbstractIterator() {
            this.m_currentIterator = UnmodifiableMapUnion.this.m_overlay.keySet().iterator();
            this.m_currentKey = null;
            this.m_phase1 = true;
        }

        @Override
        public boolean hasNext() {
            this.m_currentKey = this.getValidKey();
            return this.m_currentKey != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        K nextKey() {
            Object key = this.getValidKey();
            if (key == null) {
                throw new NoSuchElementException();
            }
            this.m_currentKey = null;
            return key;
        }

        private K getValidKey() {
            if (this.m_currentKey != null) {
                return this.m_currentKey;
            }
            if (this.m_phase1) {
                if (this.m_currentIterator.hasNext()) {
                    this.m_currentKey = this.m_currentIterator.next();
                    return this.m_currentKey;
                }
                this.m_currentIterator = UnmodifiableMapUnion.this.m_map.keySet().iterator();
                this.m_phase1 = false;
            }
            while (this.m_currentIterator.hasNext()) {
                Object key = this.m_currentIterator.next();
                if (UnmodifiableMapUnion.this.m_overlay.containsKey(key)) continue;
                this.m_currentKey = key;
                break;
            }
            return this.m_currentKey;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EntryIterator
    extends AbstractIterator<Map.Entry<K, V>> {
        EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return new UnionEntry(this.nextKey());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class KeyIterator
    extends AbstractIterator<K> {
        KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextKey();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class UnionEntry
    implements Map.Entry<K, V> {
        private final K m_key;

        public UnionEntry(K key) {
            this.m_key = key;
        }

        @Override
        public K getKey() {
            return this.m_key;
        }

        @Override
        public V getValue() {
            return UnmodifiableMapUnion.this.get(this.m_key);
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ValueIterator
    extends AbstractIterator<V> {
        ValueIterator() {
        }

        @Override
        public V next() {
            return UnmodifiableMapUnion.this.get(this.nextKey());
        }
    }
}

