/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.internal.actor;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.actor.IActor;
import org.eclipse.buckminster.core.actor.IGlobalContext;
import org.eclipse.buckminster.core.actor.IPerformManager;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.cspec.IAction;
import org.eclipse.buckminster.core.cspec.IActionArtifact;
import org.eclipse.buckminster.core.cspec.IAttribute;
import org.eclipse.buckminster.core.cspec.ICSpecData;
import org.eclipse.buckminster.core.cspec.PathGroup;
import org.eclipse.buckminster.core.cspec.model.Action;
import org.eclipse.buckminster.core.cspec.model.ActionArtifact;
import org.eclipse.buckminster.core.cspec.model.Attribute;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.cspec.model.Prerequisite;
import org.eclipse.buckminster.core.helpers.NullOutputStream;
import org.eclipse.buckminster.core.internal.actor.ActorFactory;
import org.eclipse.buckminster.core.internal.actor.GlobalContext;
import org.eclipse.buckminster.core.internal.actor.PerformContext;
import org.eclipse.buckminster.core.metadata.AmbigousComponentException;
import org.eclipse.buckminster.core.metadata.MissingComponentException;
import org.eclipse.buckminster.core.metadata.WorkspaceInfo;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformManager
implements IPerformManager {
    private static final PerformManager INSTANCE = new PerformManager();
    private static final PrintStream s_nullPrintStream = new PrintStream(NullOutputStream.INSTANCE);

    public static IPath expandPath(Map<String, ? extends Object> properties, IPath path) {
        if (path != null) {
            path = new Path(ExpandingProperties.expand(properties, path.toPortableString(), 0));
        }
        return path;
    }

    public static PerformManager getInstance() {
        return INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private static void addAttributeChildren(GlobalContext ctx, Attribute attribute, Set<String> seen, List<Action> ordered) throws CoreException {
        if (attribute instanceof ActionArtifact) {
            attribute = ((ActionArtifact)attribute).getAction();
        }
        if (!seen.contains(attrId = attribute.toString())) {
            seen.add(attrId);
            cspec = attribute.getCSpec();
            for (Prerequisite preq : attribute.getPrerequisites()) {
                block11: {
                    ag = null;
                    try {
                        ag = preq.getReferencedAttribute(cspec, ctx);
                        break block11;
                    }
                    catch (MissingComponentException e) {
                        if (!"buckminster.component.self".equals(preq.getAttribute())) {
                            throw e;
                        }
                        generators = WorkspaceInfo.getGenerators(preq.getComponentName());
                        if (generators.size() == 0) {
                            throw e;
                        }
                        generatorCSpec = null;
                        generatorAttribute = null;
                        ** for (generator : generators)
                    }
lbl-1000:
                    // 1 sources

                    {
                        candidate = WorkspaceInfo.getResolution(new ComponentRequest(generator.getComponent(), null, null), false).getCSpec();
                        if (candidate.equals(cspec)) {
                            generatorCSpec = candidate;
                            generatorAttribute = generator.getAttribute();
                            break;
                        }
                        if (generatorCSpec != null) {
                            throw new AmbigousComponentException(generator.getComponent());
                        }
                        generatorCSpec = candidate;
                        generatorAttribute = generator.getAttribute();
                        continue;
                    }
lbl31:
                    // 2 sources

                    PerformManager.addAttributeChildren(ctx, generatorCSpec.getAttribute(generatorAttribute), seen, ordered);
                }
                if (ag == null) continue;
                PerformManager.addAttributeChildren(ctx, ag, seen, ordered);
            }
            if (attribute instanceof IAction) {
                ordered.add((Action)attribute);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static List<Action> getOrderedActionList(GlobalContext ctx, List<? extends IAttribute> attributes) throws CoreException {
        HashSet<String> seen = new HashSet<String>();
        ArrayList<Action> ordered = new ArrayList<Action>();
        for (IAttribute iAttribute : attributes) {
            PerformManager.addAttributeChildren(ctx, (Attribute)iAttribute, seen, ordered);
        }
        for (IAttribute iAttribute : attributes) {
            void var4_9;
            String attrId;
            if (iAttribute instanceof IActionArtifact) {
                Action action = ((ActionArtifact)iAttribute).getAction();
            }
            if (seen.contains(attrId = var4_9.toString())) continue;
            seen.add(attrId);
            if (!(var4_9 instanceof IAction)) continue;
            ordered.add((Action)var4_9);
        }
        return ordered;
    }

    private static void makeWorkspaceAwareOfProducts(PerformContext ctx, Action action, IProgressMonitor monitor) throws CoreException {
        GlobalContext globalCtx = ctx.getGlobalContext();
        if (globalCtx.isWorkspaceRefreshPending()) {
            return;
        }
        PathGroup[] pathGroups = action.getPathGroups(ctx, null);
        if (pathGroups.length == 0) {
            globalCtx.setWorkspaceRefreshPending(true);
            return;
        }
        monitor.beginTask(null, 100 * pathGroups.length);
        try {
            HashSet<IPath> alreadyRefreshed = new HashSet<IPath>();
            PathGroup[] pathGroupArray = pathGroups;
            int n = pathGroups.length;
            int n2 = 0;
            while (n2 < n) {
                PathGroup pathGroup = pathGroupArray[n2];
                IProgressMonitor groupMonitor = MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100);
                IPath[] paths = pathGroup.getPaths();
                groupMonitor.beginTask(null, 10 * paths.length);
                IPath base = pathGroup.getBase();
                IPath[] iPathArray = paths;
                int n3 = paths.length;
                int n4 = 0;
                while (n4 < n3) {
                    IPath path = iPathArray[n4];
                    PerformManager.refreshAndSetDerivedPath(path.isAbsolute() ? path : base.append(path), alreadyRefreshed, MonitorUtils.subMonitor((IProgressMonitor)groupMonitor, (int)10));
                    ++n4;
                }
                groupMonitor.done();
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void refreshAndSetDerivedPath(IPath path, HashSet<IPath> alreadyRefreshed, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(null, 100);
        try {
            String leaf = null;
            if (!path.hasTrailingSeparator()) {
                leaf = path.lastSegment();
                path = path.removeLastSegments(1).addTrailingSeparator();
            }
            if (alreadyRefreshed.contains(path)) {
                return;
            }
            alreadyRefreshed.add(path);
            IContainer container = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(path);
            if (container == null) {
                return;
            }
            if (!(container instanceof IProject)) {
                PerformManager.refreshParents(container.getParent(), MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
            } else {
                MonitorUtils.worked((IProgressMonitor)monitor, (int)50);
            }
            container.refreshLocal(2, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
            if (leaf != null) {
                IFile file = container.getFile((IPath)new Path(leaf));
                if (!file.exists()) return;
                file.setDerived(true);
                return;
            }
            container.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    resource.setDerived(true);
                    return true;
                }
            });
            return;
        }
        finally {
            monitor.done();
        }
    }

    private static void refreshParents(IContainer container, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("", -1);
        try {
            if (container != null) {
                if (!(container instanceof IProject)) {
                    PerformManager.refreshParents(container.getParent(), MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1));
                }
                container.refreshLocal(0, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1));
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IGlobalContext perform(ICSpecData cspec, String attributeName, Map<String, ? extends Object> props, boolean forced, boolean quiet, IProgressMonitor monitor) throws CoreException {
        return this.perform(Collections.singletonList(((CSpec)cspec.getAdapter(CSpec.class)).getRequiredAttribute(attributeName)), props, forced, quiet, monitor);
    }

    @Override
    public IStatus perform(List<? extends IAttribute> attributes, IGlobalContext global, IProgressMonitor monitor) throws CoreException {
        MultiStatus status;
        GlobalContext globalCtx = (GlobalContext)global;
        List<Action> actionList = PerformManager.getOrderedActionList(globalCtx, attributes);
        monitor.beginTask(null, 100 * actionList.size());
        Logger logger = CorePlugin.getLogger();
        if (logger.isDebugEnabled()) {
            StringBuilder bld = new StringBuilder(40 + actionList.size() * 40);
            bld.append(Messages.Actions_to_perform_in_order);
            for (Action action : actionList) {
                bld.append("\n  ");
                action.toString(bld);
            }
            logger.debug(bld.toString(), new Object[0]);
        }
        MultiStatus retStatus = new MultiStatus(CorePlugin.getID(), 0, "", null);
        block7: for (Action action : actionList) {
            PrintStream err;
            PrintStream out;
            if (globalCtx.hasPerformedAction(action)) {
                MonitorUtils.worked((IProgressMonitor)monitor, (int)100);
                continue;
            }
            globalCtx.addPerformedAction(action);
            IActor actor = ActorFactory.getInstance().getActor(action);
            if (action.isAssignConsoleSupport()) {
                out = Logger.getOutStream();
                err = Logger.getErrStream();
            } else {
                out = s_nullPrintStream;
                err = s_nullPrintStream;
            }
            IProgressMonitor cancellationMonitor = MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1);
            cancellationMonitor.beginTask(null, -1);
            PerformContext ctx = new PerformContext(globalCtx, action, out, err, cancellationMonitor);
            if (!ctx.isForced() && action.isUpToDate(ctx)) {
                cancellationMonitor.done();
                MonitorUtils.worked((IProgressMonitor)monitor, (int)99);
                continue;
            }
            IStatus status2 = actor.perform(ctx, (IProgressMonitor)new SubProgressMonitor(monitor, 89, 4));
            cancellationMonitor.done();
            MonitorUtils.testCancelStatus((IProgressMonitor)monitor);
            switch (status2.getSeverity()) {
                case 1: 
                case 2: {
                    retStatus.add(status2);
                }
                case 0: {
                    PerformManager.makeWorkspaceAwareOfProducts(ctx, action, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)10));
                    break;
                }
                case 8: {
                    throw new OperationCanceledException();
                }
                case 4: {
                    retStatus.add(status2);
                }
                default: {
                    break block7;
                }
            }
        }
        IStatus[] children = retStatus.getChildren();
        Object object = status = children.length == 1 ? children[0] : retStatus;
        if (status.getSeverity() == 4) {
            throw new CoreException((IStatus)status);
        }
        return status;
    }

    @Override
    public IGlobalContext perform(List<? extends IAttribute> attributes, Map<String, ? extends Object> userProps, boolean forced, boolean quiet, IProgressMonitor monitor) throws CoreException {
        GlobalContext globalCtx = new GlobalContext(userProps, forced, quiet);
        monitor.beginTask(null, 1000);
        try {
            globalCtx.setStatus(this.perform(attributes, globalCtx, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)900)));
            GlobalContext globalContext = globalCtx;
            return globalContext;
        }
        finally {
            globalCtx.removeScheduled(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
            if (globalCtx.isWorkspaceRefreshPending()) {
                ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
            }
            monitor.done();
        }
    }
}

