/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.internal.ctype;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.UUID;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.cspec.AbstractResolutionBuilder;
import org.eclipse.buckminster.core.cspec.QualifiedDependency;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.builder.ComponentRequestBuilder;
import org.eclipse.buckminster.core.cspec.model.ComponentName;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.ctype.MissingCSpecSourceException;
import org.eclipse.buckminster.core.helpers.FilterUtils;
import org.eclipse.buckminster.core.metadata.model.BOMNode;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.metadata.model.ResolvedNode;
import org.eclipse.buckminster.core.metadata.model.UnresolvedNode;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.SiteFeatureReader;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.resolver.ResolverNode;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.version.IVersion;
import org.eclipse.buckminster.core.version.VersionFactory;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.VersionedIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiteFeatureResolutionBuilder
extends AbstractResolutionBuilder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResolverNode getResolverNode(Map<ComponentName, ResolverNode> nodes, RMContext context, QualifiedDependency qDep, String tagInfo) throws CoreException {
        boolean infant;
        ResolverNode nr;
        ComponentName key = qDep.getRequest().toPureComponentName();
        Map<ComponentName, ResolverNode> map = nodes;
        synchronized (map) {
            nr = nodes.get(key);
            boolean bl = infant = nr == null;
            if (infant) {
                nr = new ResolverNode(context.getNodeQuery(qDep), tagInfo);
                nodes.put(key, nr);
            }
        }
        if (!infant) {
            nr.addDependencyQualification(qDep);
        }
        return nr;
    }

    @Override
    public synchronized BOMNode build(IComponentReader[] readerHandle, boolean forResolutionAidOnly, IProgressMonitor monitor) throws CoreException {
        IComponentReader reader = readerHandle[0];
        if (!(reader instanceof SiteFeatureReader)) {
            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages._0_resolution_builder_can_only_work_with_a_site_feature_reader, (Object)this.getId()), (Object[])new Object[0]);
        }
        monitor.beginTask(null, 100);
        try {
            IFeature siteFeature = ((SiteFeatureReader)reader).getFeature(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
            if (siteFeature == null) {
                throw new MissingCSpecSourceException(reader.getProviderMatch());
            }
            if (forResolutionAidOnly) {
                ResolvedNode resolvedNode = this.createNode(reader, this.getCSpecBuilder(siteFeature), null);
                return resolvedNode;
            }
            NodeQuery query = reader.getNodeQuery();
            QualifiedDependency qdep = new QualifiedDependency(query.getComponentRequest(), null);
            ResolverNode rNode = this.buildCSpecFromSiteFeature(reader, new HashMap<ComponentName, ResolverNode>(), siteFeature, new UnresolvedNode(qdep), null, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
            BOMNode node = rNode.collectNodes(new HashMap<UUID, BOMNode>(), new Stack<Resolution>(), true);
            if (node == null) {
                node = new UnresolvedNode(query.getQualifiedDependency());
            }
            BOMNode bOMNode = node;
            return bOMNode;
        }
        finally {
            monitor.done();
        }
    }

    private ResolverNode buildCSpecFromSiteFeature(IComponentReader reader, Map<ComponentName, ResolverNode> nodes, IFeature siteFeature, BOMNode depNode, String tagInfo, IProgressMonitor monitor) throws CoreException {
        NodeQuery query = reader.getNodeQuery();
        RMContext context = query.getContext();
        ResolverNode node = SiteFeatureResolutionBuilder.getResolverNode(nodes, context, depNode.getQualifiedDependency(), tagInfo);
        if (node.isResolved() || query.skipComponent()) {
            MonitorUtils.complete((IProgressMonitor)monitor);
            return node;
        }
        IIncludedFeatureReference[] refs = siteFeature.getRawIncludedFeatureReferences();
        int numChildren = refs.length;
        monitor.beginTask(null, 10 + numChildren * 10);
        CSpecBuilder cspecBld = this.getCSpecBuilder(siteFeature);
        MonitorUtils.worked((IProgressMonitor)monitor, (int)5);
        node.startResolvingChildren(depNode);
        ResolverNode[] children = null;
        if (numChildren > 0) {
            QualifiedDependency[] qDeps = new QualifiedDependency[numChildren];
            VersionMatch[] matches = new VersionMatch[numChildren];
            IComponentType ctype = CorePlugin.getDefault().getComponentType("site.feature");
            ArrayList<ResolverNode> childArr = new ArrayList<ResolverNode>(numChildren);
            Provider provider = reader.getProviderMatch().getProvider();
            int idx = 0;
            while (idx < numChildren) {
                IIncludedFeatureReference ref = refs[idx];
                VersionedIdentifier vid = ref.getVersionedIdentifier();
                IVersion version = VersionFactory.OSGiType.coerce(vid.getVersion());
                ComponentRequestBuilder bld = cspecBld.createDependencyBuilder();
                bld.setName(vid.getIdentifier());
                bld.setComponentTypeID(this.getComponentTypeID());
                bld.setVersionDesignator(version == null ? null : VersionFactory.createExplicitDesignator(version));
                bld.setFilter(FilterUtils.createFilter(ref.getOS(), ref.getWS(), ref.getOSArch(), ref.getName()));
                cspecBld.addDependency(bld);
                matches[idx] = new VersionMatch(version, null, -1L, null, null);
                qDeps[idx] = new QualifiedDependency(bld.createComponentRequest(), null);
                ++idx;
            }
            String childTagInfo = cspecBld.getTagInfo(tagInfo);
            int idx2 = 0;
            while (idx2 < numChildren) {
                QualifiedDependency qdep = qDeps[idx2];
                NodeQuery childQuery = context.getNodeQuery(qdep);
                IFeature refFeature = refs[idx2].getFeature(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)4));
                IComponentReader childReader = reader.getReaderType().getReader(provider, ctype, childQuery, matches[idx2], MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1));
                try {
                    childArr.add(this.buildCSpecFromSiteFeature(childReader, nodes, refFeature, new UnresolvedNode(qdep), childTagInfo, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)5)));
                }
                finally {
                    IOUtils.close((Closeable)childReader);
                }
                ++idx2;
            }
            children = childArr.toArray(new ResolverNode[childArr.size()]);
        }
        node.setResolution(this.createResolution(reader, cspecBld, null), children);
        MonitorUtils.worked((IProgressMonitor)monitor, (int)5);
        monitor.done();
        return node;
    }

    @Override
    public String getComponentTypeID() {
        return "site.feature";
    }

    private CSpecBuilder getCSpecBuilder(IFeature siteFeature) {
        CSpecBuilder cspecBld = new CSpecBuilder();
        VersionedIdentifier vi = siteFeature.getVersionedIdentifier();
        cspecBld.setName(vi.getIdentifier());
        cspecBld.setComponentTypeID(this.getComponentTypeID());
        cspecBld.setVersion(VersionFactory.OSGiType.coerce(vi.getVersion()));
        return cspecBld;
    }
}

