/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.internal.version;

import java.util.regex.Pattern;
import org.eclipse.buckminster.core.internal.version.TripletVersionType;
import org.eclipse.buckminster.core.version.IVersion;
import org.eclipse.buckminster.core.version.OSGiVersion;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.update.core.VersionedIdentifier;
import org.osgi.framework.Version;

public class OSGiVersionType
extends TripletVersionType {
    private static final Pattern s_OSGiVersionPattern = Pattern.compile("^(\\d+)(?:\\.(\\d+)(?:\\.(\\d+)(?:\\.([^\\(\\)\\[\\],]+))?)?)?([\\)\\],]|$)");

    public IVersion coerce(Object object) {
        if (object instanceof Version) {
            Version v = (Version)object;
            return new OSGiVersion(this, v.getMajor(), v.getMinor(), v.getMicro(), v.getQualifier());
        }
        if (object instanceof PluginVersionIdentifier) {
            PluginVersionIdentifier pvi = (PluginVersionIdentifier)object;
            return new OSGiVersion(this, pvi.getMajorComponent(), pvi.getMinorComponent(), pvi.getServiceComponent(), pvi.getQualifierComponent());
        }
        if (object instanceof VersionedIdentifier) {
            return this.coerce(((VersionedIdentifier)object).getVersion());
        }
        return super.coerce(object);
    }

    IVersion createVersion(int major, int minor, int micro, String qual, String stringForm) {
        return new OSGiVersion(this, major, minor, micro, qual);
    }

    Pattern getVersionPattern() {
        return s_OSGiVersionPattern;
    }
}

