/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.internal.version;

import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.internal.version.StringVersionType;
import org.eclipse.buckminster.core.version.AbstractVersion;
import org.eclipse.buckminster.core.version.IVersion;

public class StringVersion
extends AbstractVersion {
    private final String m_version;

    StringVersion(StringVersionType type, String version) {
        super(type);
        this.m_version = version;
    }

    public int compareTo(IVersion o) {
        if (!(o instanceof StringVersion)) {
            throw new IllegalArgumentException(Messages.Not_a_StringVersion);
        }
        return this.m_version.compareTo(((StringVersion)o).m_version);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringVersion)) {
            return false;
        }
        StringVersion that = (StringVersion)o;
        return this.m_version.equals(that.m_version);
    }

    public int hashCode() {
        return this.m_version.hashCode();
    }

    public long toLong() {
        try {
            return Long.parseLong(this.toString());
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public String toString() {
        return this.m_version;
    }

    public void toString(StringBuilder bld) {
        bld.append(this.m_version);
    }
}

