/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.internal.version;

import java.util.Date;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.internal.version.TimestampVersionType;
import org.eclipse.buckminster.core.version.AbstractVersion;
import org.eclipse.buckminster.core.version.IVersion;

public class TimestampVersion
extends AbstractVersion {
    private final Date m_timestamp;

    TimestampVersion(TimestampVersionType type, Date date) {
        super(type);
        this.m_timestamp = date;
    }

    public int compareTo(IVersion o) {
        if (!(o instanceof TimestampVersion)) {
            throw new IllegalArgumentException(Messages.Not_a_TimestampVersion);
        }
        return this.getTimestamp().compareTo(((TimestampVersion)o).getTimestamp());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimestampVersion)) {
            return false;
        }
        TimestampVersion that = (TimestampVersion)o;
        return this.compareTo(that) == 0;
    }

    public final Date getTimestamp() {
        return this.m_timestamp;
    }

    public int hashCode() {
        return this.m_timestamp.hashCode();
    }

    public long toLong() {
        return this.m_timestamp.getTime();
    }

    public String toString() {
        return TimestampVersionType.toString(this);
    }

    public void toString(StringBuilder bld) {
        bld.append(TimestampVersionType.toString(this));
    }
}

