/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.internal.version;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.internal.version.AbstractVersionType;
import org.eclipse.buckminster.core.internal.version.TimestampVersion;
import org.eclipse.buckminster.core.version.IVersion;
import org.eclipse.buckminster.core.version.VersionSyntaxException;

public class TimestampVersionType
extends AbstractVersionType {
    private static SimpleDateFormat s_timestampFormat = new SimpleDateFormat("yyyyMMdd'.'HHmmss");
    private static SimpleDateFormat s_dateFormat = new SimpleDateFormat("yyyyMMdd");

    static {
        TimeZone utc = TimeZone.getTimeZone("UTC");
        s_timestampFormat.setTimeZone(utc);
        s_dateFormat.setTimeZone(utc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Date ts) {
        String string;
        SimpleDateFormat simpleDateFormat = s_timestampFormat;
        synchronized (simpleDateFormat) {
            string = s_timestampFormat.format(ts);
        }
        if (string.endsWith(".000000")) {
            string = string.substring(0, string.length() - 7);
        }
        return string;
    }

    public static String toString(TimestampVersion tsv) {
        return TimestampVersionType.toString(tsv.getTimestamp());
    }

    public IVersion coerce(Object object) {
        return object instanceof Date ? new TimestampVersion(this, (Date)object) : super.coerce(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IVersion fromString(String versionString, int startPos, int[] endPosRet) throws VersionSyntaxException {
        Date ts;
        if (versionString == null) {
            return null;
        }
        ParsePosition pp = new ParsePosition(startPos);
        SimpleDateFormat simpleDateFormat = s_timestampFormat;
        synchronized (simpleDateFormat) {
            ts = s_timestampFormat.parse(versionString, pp);
        }
        if (pp.getErrorIndex() >= 0) {
            pp.setErrorIndex(-1);
            simpleDateFormat = s_dateFormat;
            synchronized (simpleDateFormat) {
                ts = s_dateFormat.parse(versionString, pp);
            }
            if (pp.getErrorIndex() >= 0) {
                throw new VersionSyntaxException(Messages.Not_a_valid_Timestamp_version, versionString, pp.getErrorIndex());
            }
        }
        endPosRet[0] = pp.getIndex();
        return new TimestampVersion(this, ts);
    }
}

