/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.internal.version;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.internal.version.AbstractVersionType;
import org.eclipse.buckminster.core.version.IVersion;
import org.eclipse.buckminster.core.version.IVersionType;
import org.eclipse.buckminster.core.version.TripletVersion;
import org.eclipse.buckminster.core.version.VersionSyntaxException;
import org.eclipse.osgi.util.NLS;

public class TripletVersionType
extends AbstractVersionType {
    private static final Pattern s_TripletVersionPattern = Pattern.compile("^(\\d+)(?:\\.(\\d+)(?:\\.(\\d+))?)?(?:[-.]?([^\\(\\)\\[\\],]+))?([\\)\\],]|$)");

    private static boolean hasGroup(String stringForm, int group) {
        if (stringForm == null) {
            return false;
        }
        Matcher m = s_TripletVersionPattern.matcher(stringForm);
        if (!m.find()) {
            return false;
        }
        return m.group(group) != null;
    }

    public static boolean hasMicro(String stringForm) {
        return TripletVersionType.hasGroup(stringForm, 3);
    }

    public static boolean hasMinor(String stringForm) {
        return TripletVersionType.hasGroup(stringForm, 2);
    }

    private static int intGroup(Matcher m, int groupNumber) {
        String g = m.group(groupNumber);
        return g == null ? 0 : Integer.parseInt(g);
    }

    IVersion createVersion(int major, int minor, int micro, String qual, String stringForm) {
        return new TripletVersion(this, major, minor, micro, qual, stringForm);
    }

    public IVersion fromString(String versionString, int startPos, int[] endPosRet) throws VersionSyntaxException {
        if (versionString == null) {
            return null;
        }
        Matcher m = this.getVersionPattern().matcher(versionString.substring(startPos));
        if (m.find()) {
            endPosRet[0] = startPos + m.end() - m.group(5).length();
            try {
                return this.createVersion(TripletVersionType.intGroup(m, 1), TripletVersionType.intGroup(m, 2), TripletVersionType.intGroup(m, 3), m.group(4), versionString.substring(startPos, endPosRet[0]));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new VersionSyntaxException(NLS.bind((String)Messages.Not_a_valid_0_version, (Object)this.getId()), versionString, startPos);
    }

    Pattern getVersionPattern() {
        return s_TripletVersionPattern;
    }

    public boolean isComparableTo(IVersionType other) {
        return other instanceof TripletVersionType;
    }
}

