/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.internal.version;

import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.internal.version.OSGiVersionType;
import org.eclipse.buckminster.core.version.IVersion;
import org.eclipse.buckminster.core.version.IVersionDesignator;
import org.eclipse.buckminster.core.version.IVersionType;
import org.eclipse.buckminster.core.version.VersionFactory;
import org.eclipse.buckminster.core.version.VersionSyntaxException;
import org.eclipse.core.runtime.CoreException;

public abstract class VersionDesignator
implements IVersionDesignator {
    private final IVersion m_version;

    public static IVersionDesignator create(IVersion low, boolean includeLow, IVersion high, boolean includeHigh) {
        if (includeLow) {
            if (high == null) {
                return new GreaterOrEqual(low);
            }
            int cmp = low.compareTo(high);
            if (cmp == 0) {
                return includeHigh ? new PerfectMatch(low) : null;
            }
            return cmp < 0 ? new Range(low, includeLow, high, includeHigh) : null;
        }
        if (high == null) {
            return null;
        }
        int cmp = low.compareTo(high);
        if (cmp == 0) {
            return null;
        }
        return cmp < 0 ? new Range(low, includeLow, high, includeHigh) : null;
    }

    public static IVersionDesignator explicit(IVersion version) {
        return new PerfectMatch(version);
    }

    public static IVersionDesignator explicitFromString(IVersionType versionType, String versionString) throws VersionSyntaxException {
        return VersionDesignator.explicit(versionType.fromString(versionString));
    }

    public static IVersionDesignator fromString(IVersionType versionType, String versionString) throws VersionSyntaxException {
        VersionDesignator result;
        if (versionString == null) {
            throw new IllegalArgumentException(Messages.Version_string_cannot_be_null);
        }
        int top = versionString.length();
        if (top == 0) {
            throw new IllegalArgumentException(Messages.Version_string_cannot_be_empty);
        }
        int idx = 0;
        while (idx < top && Character.isWhitespace(versionString.charAt(idx))) {
            ++idx;
        }
        boolean fromInclusive = false;
        int[] endPosHolder = new int[1];
        block0 : switch (versionString.charAt(idx)) {
            case '[': {
                fromInclusive = true;
            }
            case '(': {
                ++idx;
                while (idx < top && Character.isWhitespace(versionString.charAt(idx))) {
                    ++idx;
                }
                IVersion fromVersion = versionType.fromString(versionString, idx, endPosHolder);
                idx = endPosHolder[0];
                while (idx < top && Character.isWhitespace(versionString.charAt(idx))) {
                    ++idx;
                }
                if (idx >= top || versionString.charAt(idx) != ',') {
                    if (fromInclusive && versionString.charAt(idx) == ']') {
                        result = new PerfectMatch(fromVersion);
                        break;
                    }
                    throw new VersionSyntaxException(Messages.Expected_comma, versionString, idx);
                }
                ++idx;
                while (idx < top && Character.isWhitespace(versionString.charAt(idx))) {
                    ++idx;
                }
                IVersion toVersion = versionType.fromString(versionString, idx, endPosHolder);
                idx = endPosHolder[0];
                while (idx < top && Character.isWhitespace(versionString.charAt(idx))) {
                    ++idx;
                }
                char endChar = idx < top ? versionString.charAt(idx) : (char)'\u0000';
                boolean toInclusive = false;
                switch (endChar) {
                    case ']': {
                        toInclusive = true;
                    }
                    case ')': {
                        int compare = fromVersion.compareTo(toVersion);
                        if (compare > 0 || compare == 0 && (!fromInclusive || !toInclusive)) {
                            throw new VersionSyntaxException(Messages.Negative_version_range, versionString, 0);
                        }
                        result = compare == 0 ? new PerfectMatch(fromVersion) : new Range(fromVersion, fromInclusive, toVersion, toInclusive);
                        break block0;
                    }
                }
                throw new VersionSyntaxException(Messages.Expected_squared_or_round_brackets, versionString, idx);
            }
            default: {
                result = new GreaterOrEqual(versionType.fromString(versionString));
            }
        }
        return result;
    }

    public static IVersionDesignator GTEqual(IVersion version) {
        return new GreaterOrEqual(version);
    }

    protected VersionDesignator(IVersion version) {
        this.m_version = version;
    }

    public final IVersionDesignator.ComparisonResult compare(IVersionDesignator designator) {
        return designator.getVersion().getType().isComparableTo(this.m_version.getType()) ? this.internalCompare(designator) : IVersionDesignator.ComparisonResult.Disparate;
    }

    public boolean designates(IVersion version) {
        return version == null ? false : (version.getType().isComparableTo(this.m_version.getType()) ? this.internalDesignates(version) : false);
    }

    public final boolean designates(String version) throws VersionSyntaxException {
        return version == null ? false : this.internalDesignates(this.m_version.getType().fromString(version));
    }

    public final boolean equals(Object o) {
        return o instanceof IVersionDesignator && this.compare((IVersionDesignator)o) == IVersionDesignator.ComparisonResult.Equal;
    }

    public IVersion getToVersion() {
        return this.m_version;
    }

    public IVersion getVersion() {
        return this.m_version;
    }

    public boolean hasUpperBound() {
        return true;
    }

    public boolean includesLowerBound() {
        return true;
    }

    public boolean includesUpperBound() {
        return true;
    }

    abstract IVersionDesignator.ComparisonResult internalCompare(IVersionDesignator var1);

    abstract boolean internalDesignates(IVersion var1);

    public boolean isExplicit() {
        return false;
    }

    public IVersionDesignator merge(IVersionDesignator that) throws CoreException {
        IVersionDesignator self = this;
        IVersionType thisType = this.getVersion().getType();
        IVersionType thatType = that.getVersion().getType();
        if (thisType instanceof OSGiVersionType) {
            if (!(thatType instanceof OSGiVersionType)) {
                that = VersionFactory.createDesignator(thisType, that.toString());
            }
        } else if (thatType instanceof OSGiVersionType) {
            self = VersionFactory.createDesignator(thatType, this.toString());
        }
        switch (self.compare(that)) {
            case ContainedBy: 
            case Equal: {
                return self;
            }
            case Contains: {
                return that;
            }
            case IntersectHigh: {
                return VersionDesignator.create(self.getVersion(), self.includesLowerBound(), that.getToVersion(), that.includesUpperBound());
            }
            case IntersectLow: {
                return VersionDesignator.create(that.getVersion(), that.includesLowerBound(), self.getToVersion(), self.includesUpperBound());
            }
        }
        return null;
    }

    static class GreaterOrEqual
    extends VersionDesignator {
        GreaterOrEqual(IVersion version) {
            super(version);
        }

        public IVersion getToVersion() {
            return null;
        }

        public int hashCode() {
            return this.getVersion().hashCode();
        }

        public boolean hasUpperBound() {
            return false;
        }

        public boolean includesUpperBound() {
            return false;
        }

        IVersionDesignator.ComparisonResult internalCompare(IVersionDesignator o) {
            IVersion tVersion = this.getVersion();
            int cr = tVersion.compareTo(o.getVersion());
            if (o instanceof GreaterOrEqual) {
                return cr < 0 ? IVersionDesignator.ComparisonResult.Contains : (cr == 0 ? IVersionDesignator.ComparisonResult.Equal : IVersionDesignator.ComparisonResult.ContainedBy);
            }
            if (o instanceof PerfectMatch) {
                return cr > 0 ? IVersionDesignator.ComparisonResult.Disparate : IVersionDesignator.ComparisonResult.Contains;
            }
            if (cr > 0) {
                return o.designates(tVersion) ? IVersionDesignator.ComparisonResult.IntersectLow : IVersionDesignator.ComparisonResult.Disparate;
            }
            return IVersionDesignator.ComparisonResult.Contains;
        }

        boolean internalDesignates(IVersion version) {
            return version.compareTo(this.getVersion()) >= 0;
        }

        public boolean isIdeal(IVersion version) {
            return false;
        }

        public String toString() {
            return this.getVersion().toString();
        }
    }

    static class PerfectMatch
    extends VersionDesignator {
        PerfectMatch(IVersion version) {
            super(version);
        }

        public int hashCode() {
            int hash = this.getVersion().hashCode();
            return hash * 31 ^ hash;
        }

        IVersionDesignator.ComparisonResult internalCompare(IVersionDesignator o) {
            return o.designates(this.getVersion()) ? (o instanceof PerfectMatch ? IVersionDesignator.ComparisonResult.Equal : IVersionDesignator.ComparisonResult.ContainedBy) : IVersionDesignator.ComparisonResult.Disparate;
        }

        boolean internalDesignates(IVersion version) {
            return this.getVersion().compareTo(version) == 0;
        }

        public boolean isExplicit() {
            return true;
        }

        public boolean isIdeal(IVersion version) {
            return this.getVersion().equals(version);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            String ver = this.getVersion().toString();
            bld.append('[');
            bld.append(ver);
            bld.append(',');
            bld.append(ver);
            bld.append(']');
            return bld.toString();
        }
    }

    static class Range
    extends VersionDesignator {
        private final IVersion m_toVersion;
        private final boolean m_fromInclusive;
        private final boolean m_toInclusive;

        Range(IVersion fromVersion, boolean fromInclusive, IVersion toVersion, boolean toInclusive) {
            super(fromVersion);
            this.m_fromInclusive = fromInclusive;
            this.m_toVersion = toVersion;
            this.m_toInclusive = toInclusive;
        }

        public IVersion getToVersion() {
            return this.m_toVersion;
        }

        public int hashCode() {
            int hash = this.getVersion().hashCode();
            hash = hash * 31 ^ this.m_toVersion.hashCode();
            hash <<= 2;
            if (!this.m_fromInclusive) {
                hash |= 1;
            }
            if (this.m_toInclusive) {
                hash |= 2;
            }
            return hash;
        }

        public boolean includesLowerBound() {
            return this.m_fromInclusive;
        }

        public boolean includesUpperBound() {
            return this.m_toInclusive;
        }

        IVersionDesignator.ComparisonResult internalCompare(IVersionDesignator o) {
            int compareTo;
            if (!(o instanceof Range)) {
                switch (o.compare(this)) {
                    case Contains: {
                        return IVersionDesignator.ComparisonResult.ContainedBy;
                    }
                    case ContainedBy: {
                        return IVersionDesignator.ComparisonResult.Contains;
                    }
                    case IntersectLow: {
                        return IVersionDesignator.ComparisonResult.IntersectHigh;
                    }
                    case IntersectHigh: {
                        return IVersionDesignator.ComparisonResult.IntersectLow;
                    }
                }
                return IVersionDesignator.ComparisonResult.Equal;
            }
            IVersion mv = this.getVersion();
            IVersion ov = o.getVersion();
            Range or = (Range)o;
            int compareEnd = this.m_toVersion.compareTo(ov);
            if (compareEnd < 0 || compareEnd == 0 && (!this.m_toInclusive || !or.m_fromInclusive)) {
                return IVersionDesignator.ComparisonResult.Disparate;
            }
            int compareStart = mv.compareTo(or.m_toVersion);
            if (compareStart > 0 || compareStart == 0 && (!this.m_fromInclusive || !or.m_toInclusive)) {
                return IVersionDesignator.ComparisonResult.Disparate;
            }
            int compareFrom = mv.compareTo(ov);
            if (compareFrom == 0) {
                if (this.m_fromInclusive) {
                    if (!or.m_fromInclusive) {
                        compareFrom = -1;
                    }
                } else if (or.m_fromInclusive) {
                    compareFrom = 1;
                }
            }
            if ((compareTo = this.m_toVersion.compareTo(or.m_toVersion)) == 0) {
                if (this.m_toInclusive) {
                    if (!or.m_toInclusive) {
                        compareTo = 1;
                    }
                } else if (or.m_toInclusive) {
                    compareTo = -1;
                }
            }
            if (compareFrom < 0) {
                return compareTo >= 0 ? IVersionDesignator.ComparisonResult.Contains : IVersionDesignator.ComparisonResult.IntersectHigh;
            }
            if (compareFrom > 0) {
                return compareTo <= 0 ? IVersionDesignator.ComparisonResult.ContainedBy : IVersionDesignator.ComparisonResult.IntersectLow;
            }
            return compareTo == 0 ? IVersionDesignator.ComparisonResult.Equal : (compareTo < 0 ? IVersionDesignator.ComparisonResult.ContainedBy : IVersionDesignator.ComparisonResult.Contains);
        }

        boolean internalDesignates(IVersion version) {
            int compare = this.getVersion().compareTo(version);
            if (compare > 0 || compare == 0 && !this.m_fromInclusive) {
                return false;
            }
            compare = this.m_toVersion.compareTo(version);
            return compare > 0 || compare == 0 && this.m_toInclusive;
        }

        public boolean isIdeal(IVersion version) {
            return this.m_toInclusive && this.m_toVersion.equals(version);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append(this.m_fromInclusive ? (char)'[' : '(');
            bld.append(this.getVersion());
            bld.append(',');
            bld.append(this.m_toVersion);
            bld.append(this.m_toInclusive ? (char)']' : ')');
            return bld.toString();
        }
    }
}

