/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.materializer;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.core.materializer.AbstractMaterializer;
import org.eclipse.buckminster.core.materializer.MaterializationContext;
import org.eclipse.buckminster.core.metadata.IResolution;
import org.eclipse.buckminster.core.metadata.StorageManager;
import org.eclipse.buckminster.core.metadata.model.Materialization;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.reader.SiteFeatureReaderType;
import org.eclipse.buckminster.core.site.ISiteFeatureConverter;
import org.eclipse.buckminster.core.version.VersionFactory;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.VersionedIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractSiteMaterializer
extends AbstractMaterializer {
    AbstractSiteMaterializer() {
    }

    private static void addFeatureComponents(IFeature feature, Set<ComponentIdentifier> components, IProgressMonitor monitor) throws CoreException {
        ComponentIdentifier ci;
        VersionedIdentifier vi;
        IIncludedFeatureReference[] refs = feature.getRawIncludedFeatureReferences();
        monitor.beginTask(null, refs.length * 100);
        IIncludedFeatureReference[] iIncludedFeatureReferenceArray = refs;
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            IIncludedFeatureReference ref = iIncludedFeatureReferenceArray[n2];
            vi = ref.getVersionedIdentifier();
            ci = new ComponentIdentifier(vi.getIdentifier(), "eclipse.feature", VersionFactory.OSGiType.coerce(vi.getVersion()));
            if (components.add(ci)) {
                IFeature incFeature = ref.getFeature(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
                AbstractSiteMaterializer.addFeatureComponents(incFeature, components, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
            }
            ++n2;
        }
        iIncludedFeatureReferenceArray = feature.getRawPluginEntries();
        n = iIncludedFeatureReferenceArray.length;
        n2 = 0;
        while (n2 < n) {
            IIncludedFeatureReference plugin = iIncludedFeatureReferenceArray[n2];
            vi = plugin.getVersionedIdentifier();
            ci = new ComponentIdentifier(vi.getIdentifier(), "osgi.bundle", VersionFactory.OSGiType.coerce(vi.getVersion()));
            components.add(ci);
            ++n2;
        }
        monitor.done();
    }

    private static void collectSites(MaterializationContext context, List<Resolution> resolutions, Map<IPath, Map<String, FeaturesPerSite>> sites, IProgressMonitor monitor) throws CoreException {
        ArrayList<Resolution> siteFeatures = new ArrayList<Resolution>(resolutions.size());
        ArrayList<Resolution> plugins = new ArrayList<Resolution>();
        ArrayList<Resolution> features = new ArrayList<Resolution>();
        for (Resolution resolution : resolutions) {
            if ("site.feature".equals(resolution.getComponentTypeId())) {
                siteFeatures.add(resolution);
            }
            if ("osgi.bundle".equals(resolution.getComponentTypeId())) {
                plugins.add(resolution);
                continue;
            }
            if (!"eclipse.feature".equals(resolution.getComponentTypeId())) continue;
            features.add(resolution);
        }
        if (!plugins.isEmpty() || !features.isEmpty()) {
            IReaderType pdeReaderType;
            try {
                pdeReaderType = CorePlugin.getDefault().getReaderType("eclipse.platform");
            }
            catch (CoreException e) {
                throw BuckminsterException.fromMessage((String)Messages.Unable_to_install_plugins_from_update_site_PDE_missing, (Object[])new Object[0]);
            }
            File tempSite = FileUtils.createTempFolder("bmsite", "tmp");
            siteFeatures.addAll(((ISiteFeatureConverter)((Object)pdeReaderType)).convertToSiteFeatures(context, tempSite, features, plugins));
        }
        for (Resolution resolution : siteFeatures) {
            try {
                FeaturesPerSite fps;
                IPath installLocation = context.getInstallLocation(resolution);
                String siteURL = resolution.getRepository();
                Map<String, FeaturesPerSite> sitesInLocation = sites.get(installLocation);
                if (sitesInLocation == null) {
                    sitesInLocation = new HashMap<String, FeaturesPerSite>();
                    sites.put(installLocation, sitesInLocation);
                }
                if ((fps = sitesInLocation.get(siteURL)) == null) {
                    fps = new FeaturesPerSite(SiteFeatureReaderType.getSite(siteURL, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100)));
                    sitesInLocation.put(siteURL, fps);
                }
                fps.add(resolution);
            }
            catch (Exception e) {
                context.addRequestStatus(resolution.getRequest(), BuckminsterException.wrap((Throwable)e).getStatus());
            }
        }
    }

    private static Set<ComponentIdentifier> getSiteComponents(ISite site, IProgressMonitor monitor) throws CoreException {
        ISiteFeatureReference[] refs = site.getRawFeatureReferences();
        monitor.beginTask(null, refs.length * 100);
        HashSet<ComponentIdentifier> components = new HashSet<ComponentIdentifier>();
        ISiteFeatureReference[] iSiteFeatureReferenceArray = refs;
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            ISiteFeatureReference ref = iSiteFeatureReferenceArray[n2];
            VersionedIdentifier vi = ref.getVersionedIdentifier();
            ComponentIdentifier ci = new ComponentIdentifier(vi.getIdentifier(), "eclipse.feature", VersionFactory.OSGiType.coerce(vi.getVersion()));
            if (components.add(ci)) {
                IFeature feature = ref.getFeature(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
                if (feature == null) {
                    components.remove(ci);
                } else {
                    AbstractSiteMaterializer.addFeatureComponents(feature, components, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
                }
            } else {
                monitor.worked(100);
            }
            ++n2;
        }
        monitor.done();
        return components;
    }

    @Override
    public boolean canWorkInParallel() {
        return false;
    }

    protected abstract ISite getDestinationSite(MaterializationContext var1, IPath var2, IProgressMonitor var3) throws CoreException;

    protected abstract void installFeatures(MaterializationContext var1, ISite var2, ISite var3, ISiteFeatureReference[] var4, IProgressMonitor var5) throws CoreException;

    private Set<ComponentIdentifier> installFeatures(final MaterializationContext context, Set<ComponentIdentifier> allInstalled, Map<IPath, Map<String, FeaturesPerSite>> sites, IProgressMonitor monitor) throws CoreException {
        int count = 0;
        Set<IPath> destinations = sites.keySet();
        for (IPath path : destinations) {
            count += sites.get(path).size();
        }
        HashSet<ComponentIdentifier> installDelta = new HashSet<ComponentIdentifier>();
        monitor.beginTask(null, destinations.size() * 100 + count * 100);
        try {
            for (IPath path : destinations) {
                ISite mirrorSite = this.getDestinationSite(context, path, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100));
                for (FeaturesPerSite fps : sites.get(path).values()) {
                    final IResolution first = fps.getResolutions()[0];
                    ILogListener listener = new ILogListener(){

                        public void logging(IStatus status, String plugin) {
                            switch (status.getSeverity()) {
                                case 2: 
                                case 4: {
                                    Platform.removeLogListener((ILogListener)this);
                                    context.addRequestStatus(first.getRequest(), status);
                                    Platform.addLogListener((ILogListener)this);
                                }
                            }
                        }
                    };
                    Platform.addLogListener((ILogListener)listener);
                    try {
                        try {
                            context.addRequestStatus(first.getRequest(), (IStatus)new Status(1, CorePlugin.getID(), Messages.Start_mirroring));
                            Set<ComponentIdentifier> beforeInstall = AbstractSiteMaterializer.getSiteComponents(mirrorSite, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)5));
                            this.installFeatures(context, mirrorSite, fps.getSite(), fps.getFeatureRefs(), MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)90));
                            Set<ComponentIdentifier> afterInstall = AbstractSiteMaterializer.getSiteComponents(mirrorSite, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)5));
                            allInstalled.addAll(afterInstall);
                            afterInstall.removeAll(beforeInstall);
                            installDelta.addAll(afterInstall);
                        }
                        catch (CoreException e) {
                            if (!context.isContinueOnError()) {
                                throw e;
                            }
                            context.addRequestStatus(first.getRequest(), e.getStatus());
                            context.addRequestStatus(first.getRequest(), (IStatus)new Status(1, CorePlugin.getID(), Messages.End_mirroring));
                            Platform.removeLogListener((ILogListener)listener);
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        context.addRequestStatus(first.getRequest(), (IStatus)new Status(1, CorePlugin.getID(), Messages.End_mirroring));
                        Platform.removeLogListener((ILogListener)listener);
                        throw throwable;
                    }
                    context.addRequestStatus(first.getRequest(), (IStatus)new Status(1, CorePlugin.getID(), Messages.End_mirroring));
                    Platform.removeLogListener((ILogListener)listener);
                }
            }
            HashSet<ComponentIdentifier> hashSet = installDelta;
            return hashSet;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Materialization> materialize(List<Resolution> resolutions, MaterializationContext context, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(null, 100);
        allInstalled = new HashSet<ComponentIdentifier>();
        installDelta = null;
        try {
            sites = new HashMap<IPath, Map<String, FeaturesPerSite>>();
            siteCollectorMon = MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50);
            siteCollectorMon.beginTask(null, resolutions.size() * 100);
            try {
                AbstractSiteMaterializer.collectSites(context, resolutions, sites, siteCollectorMon);
            }
            finally {
                siteCollectorMon.done();
            }
            installDelta = this.installFeatures(context, allInstalled, sites, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
            var10_9 = Collections.emptyList();
            return var10_9;
        }
        finally {
            statistics = context.getMaterializationStatistics();
            sm = StorageManager.getDefault();
            ** for (res : resolutions)
        }
lbl-1000:
        // 1 sources

        {
            ci = res.getComponentIdentifier();
            if (!allInstalled.contains(ci)) {
                statistics.addFailed(ci);
                continue;
            }
            installLocation = context.getInstallLocation(res);
            mat = new Materialization(installLocation, ci);
            res.store(sm);
            mat.store(sm);
            if (installDelta != null && installDelta.contains(ci)) {
                statistics.addReplaced(ci);
                continue;
            }
            statistics.addKept(ci);
            continue;
        }
lbl35:
        // 1 sources

        monitor.done();
        return var10_9;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FeaturesPerSite
    extends ArrayList<ISiteFeatureReference> {
        private final HashSet<Resolution> m_includedRes = new HashSet();
        private final ISite m_site;

        FeaturesPerSite(ISite site) {
            this.m_site = site;
        }

        void add(Resolution res) throws CoreException {
            if (!this.m_includedRes.contains(res)) {
                ISiteFeatureReference v = SiteFeatureReaderType.getSiteFeatureReference(this.m_site, res.getComponentIdentifier());
                if (v != null) {
                    super.add(v);
                }
                this.m_includedRes.add(res);
            }
        }

        ISiteFeatureReference[] getFeatureRefs() {
            return this.toArray(new ISiteFeatureReference[this.size()]);
        }

        IResolution[] getResolutions() {
            return this.m_includedRes.toArray(new Resolution[this.m_includedRes.size()]);
        }

        ISite getSite() {
            return this.m_site;
        }
    }
}

