/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.materializer;

import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.materializer.AbstractMaterializer;
import org.eclipse.buckminster.core.materializer.MaterializationContext;
import org.eclipse.buckminster.core.metadata.model.BillOfMaterials;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class InstallerJob
extends WorkspaceJob {
    private final MaterializationContext m_context;

    public static void run(MaterializationContext context) throws CoreException {
        try {
            InstallerJob mbJob = new InstallerJob(context);
            mbJob.schedule();
            mbJob.join();
            IStatus status = mbJob.getResult();
            if (status.getSeverity() == 8) {
                throw new OperationCanceledException();
            }
            if (!status.isOK()) {
                throw new CoreException(status);
            }
        }
        catch (InterruptedException e) {
            throw new OperationCanceledException();
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (Throwable t) {
            throw BuckminsterException.wrap((Throwable)t);
        }
    }

    public static void runDelegated(MaterializationContext context, IProgressMonitor monitor) throws CoreException {
        InstallerJob mbJob = new InstallerJob(context);
        IStatus status = mbJob.runInWorkspace(monitor);
        if (status.getSeverity() == 8) {
            throw new OperationCanceledException();
        }
        if (!status.isOK()) {
            throw new CoreException(status);
        }
    }

    public InstallerJob(MaterializationContext ctx) throws CoreException {
        super(Messages.InstallerJob_Installing);
        this.m_context = ctx;
        this.setSystem(false);
        this.setUser(true);
        this.setPriority(30);
        this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(null, 1000);
        BillOfMaterials bom = this.m_context.getBillOfMaterials();
        try {
            try {
                AbstractMaterializer.performInstallActions(bom, this.m_context, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100));
            }
            catch (CoreException e) {
                if (!this.m_context.isContinueOnError()) {
                    throw e;
                }
                this.m_context.addRequestStatus(bom.getRequest(), e.getStatus());
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }
}

