/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.materializer;

import org.eclipse.buckminster.core.materializer.AbstractSiteMaterializer;
import org.eclipse.buckminster.core.materializer.MaterializationContext;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.model.InvalidSiteTypeException;
import org.eclipse.update.internal.mirror.MirrorSite;
import org.eclipse.update.internal.mirror.MirrorSiteFactory;

public class SiteMirrorMaterializer
extends AbstractSiteMaterializer {
    public static final String MIRROR_SITE_URL_PROPERTY = "mirror.site.url";

    public String getMaterializerRootDir() {
        return "siteMirrors";
    }

    protected ISite getDestinationSite(MaterializationContext context, IPath destination, IProgressMonitor monitor) throws CoreException {
        MirrorSite mirrorSite;
        MirrorSiteFactory factory = new MirrorSiteFactory();
        try {
            mirrorSite = (MirrorSite)factory.createSite(destination.toFile());
        }
        catch (InvalidSiteTypeException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        mirrorSite.setIgnoreNonPresentPlugins(context.isContinueOnError());
        MonitorUtils.complete((IProgressMonitor)monitor);
        return mirrorSite;
    }

    protected void installFeatures(MaterializationContext context, ISite destinationSite, ISite fromSite, ISiteFeatureReference[] features, IProgressMonitor monitor) throws CoreException {
        ((MirrorSite)destinationSite).mirrorAndExpose(fromSite, features, null, (String)context.get(MIRROR_SITE_URL_PROPERTY));
        MonitorUtils.complete((IProgressMonitor)monitor);
    }
}

