/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.metadata;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.core.metadata.ISaxableStorage;
import org.eclipse.buckminster.core.metadata.TimestampedKey;
import org.eclipse.buckminster.core.metadata.model.ElementNotFoundException;
import org.eclipse.buckminster.core.parser.IParser;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.buckminster.sax.UUIDKeyed;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileStorage<T extends UUIDKeyed>
implements ISaxableStorage<T> {
    private final HashMap<UUID, TimestampedKey> m_timestamps = new HashMap();
    private static final String SEQUENCE_FILE = ".sqfile";
    private final Class<T> m_class;
    private final File m_folder;
    private final File m_sqFile;
    private final HashMap<UUID, T> m_parsed = new HashMap();
    private final int m_sequenceNumber;
    private transient T[] m_allElements;
    private HashMap<String, Method> m_getters;
    private final IParser<T> m_parser;
    private long m_cacheTime;
    private long m_lastChecked;
    private boolean m_sequenceChanged;

    public FileStorage(File folder, IParser<T> parser, Class<T> clazz, int sequenceNumber) throws CoreException {
        this.m_folder = folder;
        this.m_sqFile = new File(this.m_folder, SEQUENCE_FILE);
        this.m_parser = parser;
        this.m_class = clazz;
        this.m_sequenceNumber = sequenceNumber;
        FileUtils.createDirectory(folder, null);
        Lock lock = Lock.lock(this.m_sqFile, true);
        try {
            try {
                ByteBuffer bf = ByteBuffer.allocateDirect(4);
                bf.order(ByteOrder.LITTLE_ENDIAN);
                FileChannel fc = lock.getLockChannel();
                int foundSequenceNumber = fc.read(bf) == 4 ? bf.getInt(0) : -1;
                boolean bl = this.m_sequenceChanged = foundSequenceNumber >= 0 && foundSequenceNumber != sequenceNumber;
                if (foundSequenceNumber < 0 || this.m_sequenceChanged) {
                    bf.clear();
                    bf.putInt(this.m_sequenceNumber);
                    bf.flip();
                    fc.position(0L);
                    fc.write(bf);
                }
                File[] files = this.m_folder.listFiles();
                int idx = files.length;
                while (--idx >= 0) {
                    File file = files[idx];
                    String name = file.getName();
                    if (name.charAt(0) == '.') continue;
                    UUID id = UUID.fromString(name);
                    this.m_timestamps.put(id, new TimestampedKey(id, file.lastModified()));
                }
            }
            catch (IOException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
        finally {
            lock.release();
        }
        this.m_cacheTime = this.m_sqFile.lastModified();
        this.m_lastChecked = System.currentTimeMillis();
    }

    private void checkCache() {
        long now = System.currentTimeMillis();
        if (now - this.m_lastChecked < 1000L) {
            return;
        }
        if (this.m_cacheTime >= this.m_sqFile.lastModified()) {
            this.m_lastChecked = now;
            return;
        }
        try {
            Lock lock = Lock.lock(this.m_sqFile, false);
            try {
                this.m_timestamps.clear();
                this.m_parsed.clear();
                this.m_allElements = null;
                File[] files = this.m_folder.listFiles();
                int idx = files.length;
                while (--idx >= 0) {
                    File file = files[idx];
                    String name = file.getName();
                    if (name.charAt(0) == '.') continue;
                    UUID id = UUID.fromString(name);
                    this.m_timestamps.put(id, new TimestampedKey(id, file.lastModified()));
                }
                this.m_cacheTime = this.m_sqFile.lastModified();
                this.m_lastChecked = System.currentTimeMillis();
            }
            finally {
                lock.release();
            }
        }
        catch (CoreException e) {
            CorePlugin.getLogger().error((Throwable)e, e.getMessage(), new Object[0]);
        }
    }

    @Override
    public synchronized void clear() {
        try {
            Lock lock = Lock.lock(this.m_sqFile, true);
            try {
                File[] fileArray = this.m_folder.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (!file.equals(this.m_sqFile)) {
                        file.delete();
                    }
                    ++n2;
                }
            }
            finally {
                lock.release();
            }
        }
        catch (CoreException e) {
            CorePlugin.getLogger().error((Throwable)e, e.toString(), new Object[0]);
        }
        this.m_parsed.clear();
        this.m_timestamps.clear();
    }

    @Override
    public synchronized boolean contains(T element) throws CoreException {
        this.checkCache();
        return this.m_timestamps.containsKey(element.getId());
    }

    @Override
    public synchronized long getCreationTime(UUID elementId) throws ElementNotFoundException {
        this.checkCache();
        TimestampedKey tsKey = this.m_timestamps.get(elementId);
        if (tsKey == null) {
            throw new ElementNotFoundException(this, elementId);
        }
        return tsKey.getCreationTime();
    }

    @Override
    public synchronized T getElement(UUID elementId) throws CoreException {
        UUIDKeyed uUIDKeyed;
        this.checkCache();
        if (!this.m_timestamps.containsKey(elementId)) {
            throw new ElementNotFoundException(this, elementId);
        }
        UUIDKeyed element = (UUIDKeyed)this.m_parsed.get(elementId);
        if (element != null) {
            return (T)element;
        }
        Lock lock = Lock.lock(this.m_sqFile, false);
        FileInputStream input = null;
        try {
            File elementFile = this.getElementFile(elementId);
            input = new FileInputStream(elementFile);
            element = (UUIDKeyed)this.m_parser.parse(elementFile.toString(), input);
            element.setId(elementId);
            this.m_parsed.put(elementId, element);
            uUIDKeyed = element;
        }
        catch (FileNotFoundException e) {
            try {
                throw new ElementNotFoundException(this, elementId);
            }
            catch (Throwable throwable) {
                IOUtils.close(input);
                lock.release();
                throw throwable;
            }
        }
        IOUtils.close((Closeable)input);
        lock.release();
        return (T)uUIDKeyed;
    }

    private File getElementFile(UUID elementId) {
        return new File(this.m_folder, elementId.toString());
    }

    @Override
    public synchronized T[] getElements() throws CoreException {
        this.checkCache();
        if (this.m_allElements == null) {
            Set<UUID> keys = this.m_timestamps.keySet();
            HashSet<UUID> badKeys = null;
            int idx = keys.size();
            UUIDKeyed[] elems = (UUIDKeyed[])Array.newInstance(this.m_class, idx);
            for (UUID key : keys) {
                try {
                    elems[--idx] = this.getElement(key);
                }
                catch (CoreException e) {
                    CorePlugin.getLogger().warning(BuckminsterException.unwind((Throwable)e), NLS.bind((String)Messages.Unable_to_read_0, (Object)this.m_class.getName()), new Object[0]);
                    if (badKeys == null) {
                        badKeys = new HashSet<UUID>();
                    }
                    badKeys.add(key);
                }
            }
            if (badKeys != null) {
                idx = elems.length;
                int goodIdx = idx - badKeys.size();
                UUIDKeyed[] goodElems = (UUIDKeyed[])Array.newInstance(this.m_class, goodIdx);
                while (--idx >= 0) {
                    UUIDKeyed elem = elems[idx];
                    if (elem == null) continue;
                    goodElems[--goodIdx] = elem;
                }
                elems = goodElems;
                for (UUID badKey : badKeys) {
                    this.m_timestamps.remove(badKey);
                }
            }
            this.m_allElements = elems;
        }
        return this.m_allElements;
    }

    private synchronized Method getGetter(String keyName) throws CoreException {
        String key = keyName.toLowerCase();
        if (this.m_getters == null) {
            this.m_getters = new HashMap();
        } else {
            Method getter = this.m_getters.get(key);
            if (getter != null) {
                return getter;
            }
        }
        Class<UUID> retType = UUID.class;
        Method[] methodArray = this.m_class.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            Method method = methodArray[n2];
            int mod = method.getModifiers();
            if (Modifier.isPublic(mod) && !Modifier.isStatic(mod) && method.getReturnType().equals(retType) && method.getParameterTypes().length == 0 && (name = method.getName().toLowerCase()).length() > 3 && name.startsWith("get") && (name = name.substring(3)).equals(key)) {
                this.m_getters.put(key, method);
                return method;
            }
            ++n2;
        }
        throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.No_such_foreign_key_0, (Object)keyName), (Object[])new Object[0]);
    }

    @Override
    public synchronized UUID[] getKeys() {
        this.checkCache();
        Set<UUID> keys = this.m_timestamps.keySet();
        return keys.toArray(new UUID[keys.size()]);
    }

    @Override
    public String getName() {
        return this.m_folder.getName();
    }

    @Override
    public synchronized List<UUID> getReferencingKeys(UUID foreignKey, String keyName) throws CoreException {
        List<UUID> result = null;
        Method getter = this.getGetter(keyName);
        try {
            for (UUID elementId : this.m_timestamps.keySet()) {
                T element = this.getElement(elementId);
                UUID fkey = (UUID)getter.invoke(element, Trivial.EMPTY_OBJECT_ARRAY);
                if (fkey == null || !fkey.equals(foreignKey)) continue;
                if (result == null) {
                    result = new ArrayList<UUID>();
                }
                result.add(elementId);
            }
            if (result == null) {
                result = Collections.emptyList();
            }
            return result;
        }
        catch (Exception e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    @Override
    public synchronized TimestampedKey[] getTimestampedKeys() {
        this.checkCache();
        Collection<TimestampedKey> values = this.m_timestamps.values();
        return values.toArray(new TimestampedKey[values.size()]);
    }

    private void persistImage(UUID elementId, byte[] image) throws CoreException {
        Lock lock = Lock.lock(this.m_sqFile, true);
        try {
            this.m_allElements = null;
            File elementFile = this.getElementFile(elementId);
            if (image == null) {
                if (!elementFile.delete() && elementFile.exists()) {
                    throw new FileUtils.DeleteException(elementFile);
                }
                this.m_timestamps.remove(elementId);
            } else {
                FileOutputStream output = null;
                try {
                    try {
                        output = new FileOutputStream(elementFile);
                        ((OutputStream)output).write(image);
                    }
                    catch (IOException e) {
                        elementFile.delete();
                        throw BuckminsterException.wrap((Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.close(output);
                    throw throwable;
                }
                IOUtils.close((Closeable)output);
            }
            this.m_lastChecked = this.m_cacheTime = System.currentTimeMillis();
            this.m_sqFile.setLastModified(this.m_cacheTime);
        }
        finally {
            lock.release();
        }
    }

    @Override
    public synchronized void putElement(T element) throws CoreException {
        long timestamp;
        UUID id = element.getId();
        if (!this.m_timestamps.containsKey(id)) {
            this.m_parsed.put(id, element);
            this.persistImage(id, element.getImage());
            timestamp = System.currentTimeMillis();
        } else {
            timestamp = System.currentTimeMillis();
            this.getElementFile(id).setLastModified(timestamp);
        }
        this.m_timestamps.put(id, new TimestampedKey(id, timestamp));
    }

    @Override
    public synchronized void putElement(UUID id, T element) throws CoreException {
        UUID realId = element.getId();
        this.putElement(element);
        if (id.equals(realId)) {
            return;
        }
        CorePlugin.getLogger().debug("Element id discrepancy in storage %s, expected %s, was %s", new Object[]{this.getName(), realId, id});
        if (this.m_timestamps.containsKey(id)) {
            return;
        }
        this.m_parsed.put(id, element);
        this.persistImage(id, element.getImage());
        this.m_timestamps.put(id, new TimestampedKey(id, System.currentTimeMillis()));
    }

    @Override
    public synchronized void removeElement(UUID elementId) throws CoreException {
        this.m_parsed.remove(elementId);
        this.persistImage(elementId, null);
    }

    @Override
    public boolean sequenceChanged() {
        return this.m_sequenceChanged;
    }

    public static class Lock {
        private final RandomAccessFile m_lockFile;
        private FileLock m_lock;

        public static Lock lock(File file, boolean exclusive) throws CoreException {
            return new Lock(file, exclusive);
        }

        private Lock(File file, boolean exclusive) throws CoreException {
            RandomAccessFile lockFile = null;
            try {
                lockFile = new RandomAccessFile(file, "rws");
                this.m_lock = lockFile.getChannel().lock(0L, Long.MAX_VALUE, !exclusive);
                this.m_lockFile = lockFile;
            }
            catch (IOException e) {
                IOUtils.close(lockFile);
                throw BuckminsterException.wrap((Throwable)e);
            }
        }

        public FileChannel getLockChannel() {
            return this.m_lock.channel();
        }

        public RandomAccessFile getLockFile() {
            return this.m_lockFile;
        }

        public void migrateToExclusive() throws CoreException {
            if (this.m_lock.isShared()) {
                FileLock shared = this.m_lock;
                try {
                    FileChannel channel = shared.channel();
                    shared.release();
                    this.m_lock = channel.lock(0L, Long.MAX_VALUE, true);
                }
                catch (IOException e) {
                    throw BuckminsterException.wrap((Throwable)e);
                }
            }
        }

        public void release() {
            try {
                this.m_lock.release();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            IOUtils.close((Closeable)this.m_lockFile);
        }
    }
}

