/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.metadata;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.buckminster.core.cspec.ICSpecData;
import org.eclipse.buckminster.core.cspec.PathGroup;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.metadata.WorkspaceInfo;
import org.eclipse.buckminster.core.metadata.model.IModelCache;
import org.eclipse.core.runtime.CoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelCache
implements IModelCache {
    private Map<String, ? extends Object> m_properties;
    private Map<String, PathGroup[]> m_pathGroupsCache;
    private Map<ComponentRequest, CSpec> m_cspecCache;

    public ModelCache() {
    }

    public ModelCache(Map<String, ? extends Object> properties) {
        this.m_properties = properties;
    }

    @Override
    public synchronized CSpec findCSpec(ICSpecData ownerCSpec, ComponentRequest request) throws CoreException {
        CSpec cspec = null;
        if (this.m_cspecCache == null) {
            this.m_cspecCache = new HashMap<ComponentRequest, CSpec>();
        } else {
            cspec = this.m_cspecCache.get(request);
        }
        if (cspec == null) {
            cspec = WorkspaceInfo.getResolution(request, false).getCSpec();
            this.m_cspecCache.put(request, cspec);
        }
        return cspec;
    }

    @Override
    public synchronized Map<String, PathGroup[]> getPathGroupsCache() {
        if (this.m_pathGroupsCache == null) {
            this.m_pathGroupsCache = new HashMap<String, PathGroup[]>();
        }
        return this.m_pathGroupsCache;
    }

    @Override
    public synchronized Map<String, ? extends Object> getProperties() {
        if (this.m_properties == null) {
            this.m_properties = new HashMap<String, Object>();
        }
        return this.m_properties;
    }
}

