/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.metadata;

import java.io.File;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.metadata.FileStorage;
import org.eclipse.buckminster.core.metadata.ISaxableStorage;
import org.eclipse.buckminster.core.metadata.WorkspaceInfo;
import org.eclipse.buckminster.core.metadata.model.Materialization;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.metadata.model.WorkspaceBinding;
import org.eclipse.buckminster.core.parser.IParserFactory;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.opml.model.OPML;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StorageManager {
    private static StorageManager s_defaultManager;
    private final ISaxableStorage<CSpec> m_cspecs;
    private final ISaxableStorage<WorkspaceBinding> m_wsBindings;
    private final ISaxableStorage<Resolution> m_resolutions;
    private final ISaxableStorage<Provider> m_providers;
    private final ISaxableStorage<Materialization> m_materializations;
    private final ISaxableStorage<OPML> m_opmls;

    public static synchronized StorageManager getDefault() throws CoreException {
        if (s_defaultManager == null) {
            s_defaultManager = new StorageManager(CorePlugin.getDefault().getStateLocation().toFile());
            s_defaultManager.initialize();
        }
        return s_defaultManager;
    }

    public StorageManager(File baseLocation) throws CoreException {
        CorePlugin plugin = CorePlugin.getDefault();
        IParserFactory pf = plugin.getParserFactory();
        this.m_providers = new FileStorage<Provider>(new File(baseLocation, "provider"), pf.getProviderParser(false), Provider.class, 2);
        this.m_cspecs = new FileStorage<CSpec>(new File(baseLocation, "cspec"), pf.getCSpecParser(false), CSpec.class, 4);
        this.m_resolutions = new FileStorage<Resolution>(new File(baseLocation, "resolution"), pf.getResolutionParser(), Resolution.class, 2);
        this.m_materializations = new FileStorage<Materialization>(new File(baseLocation, "materialization"), pf.getMaterializationParser(), Materialization.class, 3);
        this.m_opmls = new FileStorage<OPML>(new File(baseLocation, "opml"), pf.getOPMLParser(false), OPML.class, 1);
        this.m_wsBindings = new FileStorage<WorkspaceBinding>(new File(baseLocation, "workspaceBinding"), pf.getWorkspaceBindingParser(false), WorkspaceBinding.class, 1);
    }

    public ISaxableStorage<CSpec> getCSpecs() throws CoreException {
        return this.m_cspecs;
    }

    public ISaxableStorage<Materialization> getMaterializations() throws CoreException {
        return this.m_materializations;
    }

    public ISaxableStorage<OPML> getOPMLs() throws CoreException {
        return this.m_opmls;
    }

    public ISaxableStorage<Provider> getProviders() throws CoreException {
        return this.m_providers;
    }

    public ISaxableStorage<Resolution> getResolutions() throws CoreException {
        return this.m_resolutions;
    }

    public ISaxableStorage<WorkspaceBinding> getWorkspaceBindings() throws CoreException {
        return this.m_wsBindings;
    }

    private void initialize() throws CoreException {
        if (this.m_materializations.sequenceChanged() || this.m_resolutions.sequenceChanged() || this.m_cspecs.sequenceChanged() || this.m_providers.sequenceChanged() || this.m_opmls.sequenceChanged() || this.m_wsBindings.sequenceChanged()) {
            WorkspaceInfo.forceRefreshOnAll((IProgressMonitor)new NullProgressMonitor());
        }
    }
}

