/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.metadata.model;

import java.util.List;
import java.util.Set;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.cspec.IGenerator;
import org.eclipse.buckminster.core.cspec.QualifiedDependency;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.metadata.model.BOMNode;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.mspec.model.MaterializationSpec;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratorNode
extends BOMNode {
    public static final String ATTR_ATTRIBUTE = "attribute";
    public static final String ATTR_COMPONENT = "component";
    public static final String ATTR_GENERATES = "generates";
    public static final String ATTR_DECLARING_CSPEC_ID = "declaringCSpecId";
    public static final String TAG = "generatorNode";
    private final String m_attribute;
    private final String m_component;
    private final String m_generates;
    private final CSpec m_declaringCSpec;

    public GeneratorNode(CSpec declaringCSpec, IGenerator generator) {
        this.m_declaringCSpec = declaringCSpec;
        this.m_component = generator.getComponent();
        this.m_attribute = generator.getAttribute();
        this.m_generates = generator.getGenerates();
    }

    public GeneratorNode(CSpec declaringCSpec, String component, String attribute, String generates) {
        this.m_declaringCSpec = declaringCSpec;
        this.m_component = component;
        this.m_attribute = attribute;
        this.m_generates = generates;
    }

    protected void addAttributes(AttributesImpl attrs) {
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_DECLARING_CSPEC_ID, (String)this.m_declaringCSpec.getId().toString());
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_ATTRIBUTE, (String)this.m_attribute);
        if (this.m_component != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_COMPONENT, (String)this.m_component);
        }
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_GENERATES, (String)this.m_generates);
    }

    @Override
    void addMaterializationCandidates(RMContext context, List<Resolution> resolutions, ComponentQuery query, MaterializationSpec mspec, Set<Resolution> perused) throws CoreException {
    }

    public String getAttribute() {
        return this.m_attribute;
    }

    public String getComponent() {
        return this.m_component;
    }

    public CSpec getDeclaringCSpec() {
        return this.m_declaringCSpec;
    }

    public String getDefaultTag() {
        return TAG;
    }

    public String getGenerates() {
        return this.m_generates;
    }

    @Override
    public QualifiedDependency getQualifiedDependency() {
        return new QualifiedDependency(this.getRequest(), null);
    }

    @Override
    public ComponentRequest getRequest() {
        return new ComponentRequest(this.m_generates, null, null);
    }

    @Override
    public String getViewName() throws CoreException {
        return String.valueOf(this.getRequest().getViewName()) + ":generated";
    }

    @Override
    public boolean isFullyResolved(ComponentQuery query) throws CoreException {
        return true;
    }
}

