/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.metadata.model;

import java.io.File;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.metadata.StorageManager;
import org.eclipse.buckminster.core.metadata.WorkspaceInfo;
import org.eclipse.buckminster.core.metadata.model.IUUIDPersisted;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.version.IVersion;
import org.eclipse.buckminster.sax.UUIDKeyed;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Materialization
extends UUIDKeyed
implements IUUIDPersisted {
    public static final String TAG = "materialization";
    public static final String ATTR_LOCATION = "location";
    public static final int SEQUENCE_NUMBER = 3;
    private final IPath m_componentLocation;
    private final ComponentIdentifier m_componentIdentifier;

    public Materialization(IPath destination, ComponentIdentifier componentIdentifier) {
        if (destination == null || componentIdentifier == null) {
            throw new NullPointerException();
        }
        this.m_componentLocation = destination;
        this.m_componentIdentifier = componentIdentifier;
    }

    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        IVersion version;
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_LOCATION, (String)this.m_componentLocation.toPortableString());
        Utils.addAttribute((AttributesImpl)attrs, (String)"name", (String)this.m_componentIdentifier.getName());
        String tmp = this.m_componentIdentifier.getComponentTypeID();
        if (tmp != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)"componentType", (String)tmp);
        }
        if ((version = this.m_componentIdentifier.getVersion()) != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)"version", (String)version.toString());
            Utils.addAttribute((AttributesImpl)attrs, (String)"versionType", (String)version.getType().getId());
        }
    }

    public ComponentIdentifier getComponentIdentifier() {
        return this.m_componentIdentifier;
    }

    public final IPath getComponentLocation() {
        return this.m_componentLocation;
    }

    public String getDefaultTag() {
        return TAG;
    }

    public Resolution getResolution() throws CoreException {
        this.store(StorageManager.getDefault());
        return WorkspaceInfo.getResolution(this.m_componentIdentifier);
    }

    public boolean isPersisted(StorageManager sm) throws CoreException {
        return sm.getMaterializations().contains(this);
    }

    public boolean isValid() {
        IPath location = this.getComponentLocation();
        File destFile = location.toFile();
        String[] list = destFile.list();
        return list == null ? destFile.length() > 0L : list.length > 0;
    }

    public synchronized void remove(StorageManager sm) throws CoreException {
        WorkspaceInfo.clearCachedLocation(this.m_componentIdentifier);
        sm.getMaterializations().removeElement(this.getId());
    }

    public void store(StorageManager sm) throws CoreException {
        WorkspaceInfo.clearCachedLocation(this.m_componentIdentifier);
        sm.getMaterializations().putElement(this);
    }

    public void toSax(ContentHandler receiver) throws SAXException {
        receiver.startDocument();
        this.toSax(receiver, "http://www.eclipse.org/buckminster/MetaData-1.0", "md", this.getDefaultTag());
        receiver.endDocument();
    }
}

