/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.metadata.model;

import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.cspec.QualifiedDependency;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.core.metadata.IResolution;
import org.eclipse.buckminster.core.metadata.MissingComponentException;
import org.eclipse.buckminster.core.metadata.StorageManager;
import org.eclipse.buckminster.core.metadata.WorkspaceInfo;
import org.eclipse.buckminster.core.metadata.builder.ResolutionBuilder;
import org.eclipse.buckminster.core.metadata.model.IUUIDPersisted;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.version.IVersion;
import org.eclipse.buckminster.core.version.IVersionDesignator;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.buckminster.opml.model.OPML;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.sax.UUIDKeyed;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resolution
extends UUIDKeyed
implements IUUIDPersisted,
IResolution {
    public static final String ATTR_ATTRIBUTES = "attributes";
    public static final String ATTR_COMPONENT_TYPE = "componentType";
    public static final String ATTR_CONTENT_TYPE = "contentType";
    public static final String ATTR_CSPEC_ID = "cspecId";
    public static final String ATTR_LAST_MODIFIED = "lastModified";
    public static final String ATTR_MATERIALIZABLE = "materializable";
    public static final String ATTR_OPML_ID = "opmlId";
    public static final String ATTR_PERSISTENT_ID = "persistentId";
    public static final String ATTR_PROVIDER_ID = "providerId";
    public static final String ATTR_QUERY_ID = "queryId";
    public static final String ATTR_REMOTE_NAME = "remoteName";
    public static final String ATTR_REPOSITORY = "repository";
    public static final String ATTR_SIZE = "size";
    public static final String ATTR_UNPACK = "unpack";
    public static final String ELEM_REQUEST = "request";
    public static final int SEQUENCE_NUMBER = 2;
    public static final String TAG = "resolution";
    private final List<String> m_attributes;
    private final String m_componentTypeId;
    private final String m_contentType;
    private transient CSpec m_cspec;
    private final long m_lastModified;
    private final boolean m_materializable;
    private transient OPML m_opml;
    private final String m_persistentId;
    private transient Provider m_provider;
    private final String m_remoteName;
    private final String m_repository;
    private final ComponentRequest m_request;
    private final long m_size;
    private final boolean m_unpack;
    private final VersionMatch m_versionMatch;

    public Resolution(CSpec cspec, OPML opml, Resolution old) {
        this.m_cspec = cspec;
        this.m_opml = opml;
        this.m_request = old.getRequest();
        this.m_attributes = old.getAttributes();
        this.m_persistentId = old.getPersistentId();
        this.m_provider = old.getProvider();
        this.m_componentTypeId = old.getComponentTypeId();
        this.m_versionMatch = old.getVersionMatch().copyWithVersion(cspec.getVersion());
        this.m_materializable = old.isMaterializable();
        this.m_repository = old.getRepository();
        this.m_remoteName = old.getRemoteName();
        this.m_contentType = old.getContentType();
        this.m_lastModified = old.getLastModified();
        this.m_size = old.getSize();
        this.m_unpack = old.isUnpack();
    }

    public Resolution(CSpec cspec, OPML opml, String componentTypeId, VersionMatch versionMatch, Provider provider, boolean materializeable, ComponentRequest request, List<String> attributes, String persistentId, String repository, String remoteName, String contentType, long lastModified, long size, boolean unpack) {
        this.m_cspec = cspec;
        this.m_opml = opml;
        this.m_provider = provider;
        this.m_componentTypeId = componentTypeId;
        this.m_versionMatch = versionMatch;
        this.m_materializable = materializeable;
        this.m_request = request;
        this.m_attributes = Utils.createUnmodifiableList(attributes);
        this.m_persistentId = persistentId;
        this.m_repository = repository;
        this.m_remoteName = remoteName;
        this.m_contentType = contentType;
        this.m_lastModified = lastModified;
        this.m_size = size;
        this.m_unpack = unpack;
    }

    public Resolution(IVersion version, Resolution old) {
        this.m_cspec = old.getCSpec();
        this.m_opml = old.getOPML();
        this.m_request = old.getRequest();
        this.m_attributes = old.getAttributes();
        this.m_persistentId = old.getPersistentId();
        this.m_provider = old.getProvider();
        this.m_componentTypeId = old.getComponentTypeId();
        this.m_versionMatch = old.getVersionMatch().copyWithVersion(version);
        this.m_materializable = old.isMaterializable();
        this.m_repository = old.getRepository();
        this.m_remoteName = old.getRemoteName();
        this.m_contentType = old.getContentType();
        this.m_lastModified = old.getLastModified();
        this.m_size = old.getSize();
        this.m_unpack = old.isUnpack();
    }

    public Resolution(ResolutionBuilder bld) {
        this.m_attributes = Utils.createUnmodifiableList(bld.getAttributes());
        this.m_componentTypeId = bld.getComponentTypeId();
        this.m_contentType = bld.getContentType();
        this.m_cspec = bld.getCSpec();
        this.m_lastModified = bld.getLastModified();
        this.m_materializable = bld.isMaterializable();
        this.m_opml = bld.getOPML();
        this.m_persistentId = bld.getPersistentId();
        this.m_provider = bld.getProvider();
        this.m_remoteName = bld.getRemoteName();
        this.m_repository = bld.getRepository();
        this.m_request = bld.getRequest().createComponentRequest();
        this.m_size = bld.getSize();
        this.m_versionMatch = bld.getVersionMatch();
        this.m_unpack = bld.isUnpack();
    }

    public void emitElements(ContentHandler handler, String namespace, String prefix) throws SAXException {
        this.m_request.toSax(handler, "http://www.eclipse.org/buckminster/MetaData-1.0", "md", ELEM_REQUEST);
        this.m_versionMatch.toSax(handler, "http://www.eclipse.org/buckminster/MetaData-1.0", "md", this.m_versionMatch.getDefaultTag());
    }

    @Override
    public String getArtifactInfo() {
        return this.m_versionMatch.getArtifactInfo();
    }

    public URI getArtifactURI(RMContext context) throws CoreException {
        return this.getProvider().getReaderType().getArtifactURL(this, context);
    }

    @Override
    public List<String> getAttributes() {
        return this.m_attributes;
    }

    public ComponentIdentifier getComponentIdentifier() {
        return this.getCSpec().getComponentIdentifier();
    }

    public IComponentType getComponentType() throws CoreException {
        return CorePlugin.getDefault().getComponentType(this.m_componentTypeId);
    }

    @Override
    public String getComponentTypeId() {
        return this.m_componentTypeId;
    }

    public String getContentType() {
        return this.m_contentType;
    }

    @Override
    public CSpec getCSpec() {
        return this.m_cspec;
    }

    public UUID getCSpecId() {
        return this.m_cspec.getId();
    }

    public String getDefaultTag() {
        return TAG;
    }

    public long getLastModified() {
        return this.m_lastModified;
    }

    @Override
    public VersionSelector getMatchedBranchOrTag() {
        return this.m_versionMatch.getBranchOrTag();
    }

    public final String getName() {
        return this.m_request.getName();
    }

    public OPML getOPML() {
        return this.m_opml;
    }

    public UUID getOPMLId() {
        return this.m_opml == null ? null : this.m_opml.getId();
    }

    @Override
    public String getPersistentId() {
        return this.m_persistentId;
    }

    @Override
    public Provider getProvider() {
        return this.m_provider;
    }

    public UUID getProviderId() {
        return this.m_provider.getId();
    }

    public ProviderMatch getProviderMatch(RMContext context) throws CoreException {
        ProviderMatch pm = new ProviderMatch(this.m_provider, this.getComponentType(), this.getVersionMatch(), context.getNodeQuery(this.getQualifiedDependency()));
        pm.setRepositoryURI(this.m_repository);
        return pm;
    }

    public final QualifiedDependency getQualifiedDependency() {
        return new QualifiedDependency(this.m_request, this.m_attributes);
    }

    @Override
    public String getReaderTypeId() {
        return this.getProvider().getReaderTypeId();
    }

    public String getRemoteName() {
        return this.m_remoteName;
    }

    @Override
    public String getRepository() {
        return this.m_repository;
    }

    @Override
    public final ComponentRequest getRequest() {
        return this.m_request;
    }

    @Override
    public Filter getResolutionFilter() {
        return this.getProvider().getResolutionFilter();
    }

    @Override
    public long getSelectedRevision() {
        return this.m_versionMatch.getRevision();
    }

    @Override
    public Date getSelectedTimestamp() {
        return this.getVersionMatch().getTimestamp();
    }

    public long getSize() {
        return this.m_size;
    }

    public final IVersion getVersion() {
        return this.m_versionMatch.getVersion();
    }

    public final IVersionDesignator getVersionDesignator() throws CoreException {
        return this.m_request.getVersionDesignator();
    }

    @Override
    public VersionMatch getVersionMatch() {
        return this.m_versionMatch;
    }

    public boolean isDesignatedBy(ComponentRequest request) throws CoreException {
        if (!request.getName().equals(this.m_request.getName())) {
            return false;
        }
        String componentType = request.getComponentTypeID();
        if (componentType != null && !componentType.equals(this.m_request.getComponentTypeID())) {
            return false;
        }
        IVersionDesignator vd = request.getVersionDesignator();
        return vd == null ? true : vd.designates(this.getVersion());
    }

    public boolean isFilterMatchFor(NodeQuery query) {
        return this.isFilterMatchFor(query, null);
    }

    public boolean isFilterMatchFor(NodeQuery query, Filter[] failingFilter) {
        Filter cspecFilter;
        Map<String, String[]> attributeUsageMap = query.getContext().getFilterAttributeUsageMap();
        Filter resFilter = this.getProvider().getResolutionFilter();
        Map<String, ? extends Object> properties = query.getProperties();
        if (resFilter != null) {
            resFilter.addConsultedAttributes(attributeUsageMap);
            if (!resFilter.matchCase(properties)) {
                if (failingFilter != null) {
                    failingFilter[0] = resFilter;
                }
                return false;
            }
        }
        if ((cspecFilter = this.getCSpec().getFilter()) != null) {
            cspecFilter.addConsultedAttributes(attributeUsageMap);
            if (!cspecFilter.matchCase(properties)) {
                if (failingFilter != null) {
                    failingFilter[0] = cspecFilter;
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isMaterializable() {
        return this.m_materializable;
    }

    public boolean isMaterialized(IPath location) throws CoreException {
        try {
            IPath myLocation = this.getCSpec().getComponentLocation();
            return location.equals((Object)myLocation);
        }
        catch (MissingComponentException e) {
            return false;
        }
    }

    @Override
    public boolean isPersisted(StorageManager sm) throws CoreException {
        return sm.getResolutions().contains(this);
    }

    @Override
    public boolean isUnpack() {
        return this.m_unpack;
    }

    @Override
    public void remove(StorageManager sm) throws CoreException {
        WorkspaceInfo.clearResolutionCache(this.getComponentIdentifier());
        sm.getResolutions().removeElement(this.getId());
    }

    @Override
    public void store(StorageManager sm) throws CoreException {
        WorkspaceInfo.clearResolutionCache(this.getComponentIdentifier());
        this.m_cspec.store(sm);
        if (this.m_opml != null) {
            sm.getOPMLs().putElement(this.m_opml);
        }
        this.m_provider.store(sm);
        sm.getResolutions().putElement(this);
    }

    public void toSax(ContentHandler receiver) throws SAXException {
        receiver.startDocument();
        this.toSax(receiver, "http://www.eclipse.org/buckminster/MetaData-1.0", "md", this.getDefaultTag());
        receiver.endDocument();
    }

    public void toSax(ContentHandler handler, String namespace, String prefix, String localName) throws SAXException {
        handler.startPrefixMapping("md", "http://www.eclipse.org/buckminster/MetaData-1.0");
        super.toSax(handler, namespace, prefix, localName);
        handler.endPrefixMapping("md");
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(Messages.Name);
        result.append(this.m_request.getName());
        result.append(", ");
        this.m_versionMatch.toString(result);
        return result.toString();
    }

    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        String tmp;
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_CSPEC_ID, (String)this.m_cspec.getId().toString());
        if (this.m_opml != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_OPML_ID, (String)this.m_opml.getId().toString());
        }
        if ((tmp = TextUtils.concat(this.m_attributes, ",")) != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_ATTRIBUTES, (String)tmp);
        }
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_MATERIALIZABLE, (String)(this.m_materializable ? "true" : "false"));
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_PROVIDER_ID, (String)this.m_provider.getId().toString());
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_REPOSITORY, (String)this.m_repository);
        if (this.m_componentTypeId != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_COMPONENT_TYPE, (String)this.m_componentTypeId);
        }
        if (this.m_persistentId != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_PERSISTENT_ID, (String)this.m_persistentId);
        }
        if (this.m_remoteName != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_REMOTE_NAME, (String)this.m_remoteName);
        }
        if (this.m_contentType != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_CONTENT_TYPE, (String)this.m_contentType);
        }
        if (this.m_lastModified != 0L) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_LAST_MODIFIED, (String)Long.toString(this.m_lastModified));
        }
        if (this.m_size != -1L) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_SIZE, (String)Long.toString(this.m_size));
        }
        if (this.m_unpack) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_UNPACK, (String)"true");
        }
    }

    protected String getElementNamespace(String namespace) {
        return "http://www.eclipse.org/buckminster/MetaData-1.0";
    }

    protected String getElementPrefix(String prefix) {
        return "md";
    }
}

