/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.metadata.parser;

import java.util.UUID;
import org.eclipse.buckminster.core.cspec.parser.CSpecHandler;
import org.eclipse.buckminster.core.metadata.model.IDWrapper;
import org.eclipse.buckminster.core.metadata.parser.BillOfMaterialsHandler;
import org.eclipse.buckminster.core.metadata.parser.BomNodeHandler;
import org.eclipse.buckminster.core.metadata.parser.GeneratorNodeHandler;
import org.eclipse.buckminster.core.metadata.parser.IWrapperParent;
import org.eclipse.buckminster.core.metadata.parser.ResolutionHandler;
import org.eclipse.buckminster.core.metadata.parser.ResolvedNodeHandler;
import org.eclipse.buckminster.core.metadata.parser.UnresolvedNodeHandler;
import org.eclipse.buckminster.core.parser.ExtensionAwareHandler;
import org.eclipse.buckminster.core.query.parser.ComponentQueryHandler;
import org.eclipse.buckminster.core.rmap.parser.ProviderHandler;
import org.eclipse.buckminster.opml.model.OPML;
import org.eclipse.buckminster.opml.parser.OPMLHandler;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.buckminster.sax.ChildHandler;
import org.eclipse.buckminster.sax.ChildPoppedListener;
import org.eclipse.buckminster.sax.UUIDKeyed;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class IDWrapperHandler
extends ExtensionAwareHandler
implements ChildPoppedListener {
    public static final String TAG = "idwrapper";
    private final CSpecHandler m_cspecHandler = new CSpecHandler((AbstractHandler)this);
    private final ResolutionHandler m_resolutionHandler = new ResolutionHandler((AbstractHandler)this);
    private final ResolvedNodeHandler m_resolvedNodeHandler = new ResolvedNodeHandler((AbstractHandler)this);
    private final UnresolvedNodeHandler m_unresolvedNodeHandler = new UnresolvedNodeHandler((AbstractHandler)this);
    private final GeneratorNodeHandler m_generatorNodeHandler = new GeneratorNodeHandler((AbstractHandler)this);
    private final ComponentQueryHandler m_componentQueryHandler = new ComponentQueryHandler((AbstractHandler)this, null);
    private final OPMLHandler m_opmlHandler = new OPMLHandler((AbstractHandler)this);
    private BillOfMaterialsHandler m_billOfMaterialsHandler;
    private UUID m_id;
    private IDWrapper m_wrapper;

    public IDWrapperHandler(AbstractHandler parent) {
        super(parent);
    }

    public void childPopped(ChildHandler child) throws SAXException {
        if (child instanceof BomNodeHandler) {
            this.m_wrapper = new IDWrapper(this.m_id, ((BomNodeHandler)child).getDepNode());
        } else if (child == this.m_cspecHandler) {
            this.m_wrapper = new IDWrapper(this.m_id, this.m_cspecHandler.getCSpec());
        } else if (child instanceof ProviderHandler) {
            this.m_wrapper = new IDWrapper(this.m_id, ((ProviderHandler)child).getProvider());
        } else if (child == this.m_resolutionHandler) {
            this.m_wrapper = new IDWrapper(this.m_id, this.m_resolutionHandler.getResolution());
        } else if (child == this.m_componentQueryHandler) {
            this.m_wrapper = new IDWrapper(this.m_id, this.m_componentQueryHandler.getComponentQuery());
        } else if (child == this.m_opmlHandler) {
            this.m_wrapper = new IDWrapper(this.m_id, (UUIDKeyed)new OPML(this.m_opmlHandler.getOPML()));
        }
    }

    public ChildHandler createHandler(String uri, String localName, Attributes attrs) throws SAXException {
        Object ch;
        if ("cspec".equals(localName)) {
            ch = this.m_cspecHandler;
        } else if ("provider".equals(localName)) {
            ch = this.createContentHandler(ProviderHandler.class, uri, attrs);
        } else if ("resolution".equals(localName)) {
            ch = this.m_resolutionHandler;
        } else if ("resolvedNode".equals(localName)) {
            ch = this.m_resolvedNodeHandler;
        } else if ("billOfMaterials".equals(localName)) {
            if (this.m_billOfMaterialsHandler == null) {
                this.m_billOfMaterialsHandler = new BillOfMaterialsHandler((AbstractHandler)this);
            }
            ch = this.m_billOfMaterialsHandler;
        } else {
            ch = "unresolvedNode".equals(localName) ? this.m_unresolvedNodeHandler : ("generatorNode".equals(localName) ? this.m_generatorNodeHandler : (this.m_componentQueryHandler.getTAG().equals(localName) ? this.m_componentQueryHandler : (this.m_opmlHandler.getTAG().equals(localName) ? this.m_opmlHandler : super.createHandler(uri, localName, attrs))));
        }
        return ch;
    }

    UUIDKeyed getWrapped(UUID id) throws SAXException {
        return ((IWrapperParent)this.getParentHandler()).getWrapped(id);
    }

    public IDWrapper getWrapper() {
        return this.m_wrapper;
    }

    public void handleAttributes(Attributes attrs) throws SAXException {
        this.m_id = UUID.fromString(this.getStringValue(attrs, "id"));
        this.m_wrapper = null;
    }
}

