/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.metadata.parser;

import java.util.UUID;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.metadata.StorageManager;
import org.eclipse.buckminster.core.metadata.model.Materialization;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.parser.ExtensionAwareHandler;
import org.eclipse.buckminster.core.version.IVersion;
import org.eclipse.buckminster.core.version.VersionFactory;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class MaterializationHandler
extends ExtensionAwareHandler {
    public static final String TAG = "materialization";
    private Materialization m_materialization;

    public MaterializationHandler(AbstractHandler parent) {
        super(parent);
    }

    public Materialization getMaterialization() {
        return this.m_materialization;
    }

    public void handleAttributes(Attributes attrs) throws SAXException {
        ComponentIdentifier cid;
        String name = MaterializationHandler.getOptionalStringValue((Attributes)attrs, (String)"name");
        if (name == null) {
            UUID resolutionId = UUID.fromString(this.getStringValue(attrs, "resolutionId"));
            try {
                Resolution res = StorageManager.getDefault().getResolutions().getElement(resolutionId);
                cid = res.getComponentIdentifier();
            }
            catch (CoreException e) {
                throw new SAXParseException(e.getMessage(), this.getDocumentLocator(), (Exception)((Object)e));
            }
        }
        String ctype = this.getComponentType(attrs);
        IVersion version = null;
        String tmp = MaterializationHandler.getOptionalStringValue((Attributes)attrs, (String)"version");
        if (tmp != null) {
            String type = MaterializationHandler.getOptionalStringValue((Attributes)attrs, (String)"versionType");
            if (type == null) {
                type = "OSGi";
            }
            try {
                version = VersionFactory.createVersion(type, tmp);
            }
            catch (CoreException e) {
                throw new SAXParseException(e.getMessage(), this.getDocumentLocator());
            }
        }
        cid = new ComponentIdentifier(name, ctype, version);
        this.m_materialization = new Materialization(Path.fromPortableString((String)this.getStringValue(attrs, "location")), cid);
    }
}

