/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.metadata.parser;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.cspec.ICSpecData;
import org.eclipse.buckminster.core.cspec.builder.ComponentRequestBuilder;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.cspec.parser.ComponentRequestHandler;
import org.eclipse.buckminster.core.helpers.DateAndTimeUtils;
import org.eclipse.buckminster.core.metadata.StorageManager;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.metadata.parser.IDWrapperHandler;
import org.eclipse.buckminster.core.metadata.parser.VersionMatchHandler;
import org.eclipse.buckminster.core.parser.ExtensionAwareHandler;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.version.IVersion;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.buckminster.opml.model.OPML;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.buckminster.sax.ChildHandler;
import org.eclipse.buckminster.sax.ChildPoppedListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ResolutionHandler
extends ExtensionAwareHandler
implements ChildPoppedListener {
    public static final String TAG = "resolution";
    private final ComponentRequestHandler m_componentRequestHandler = new ComponentRequestHandler((AbstractHandler)this, new ComponentRequestBuilder());
    private final VersionMatchHandler m_versionMatchHandler = new VersionMatchHandler((AbstractHandler)this);
    private final ArrayList<String> m_attributes = new ArrayList();
    private UUID m_cspecId;
    private UUID m_opmlId;
    private UUID m_providerId;
    private ComponentRequest m_request;
    private String m_componentType;
    private VersionMatch m_versionMatch;
    private boolean m_materializable;
    private String m_persistentId;
    private String m_repository;
    private String m_remoteName;
    private String m_contentType;
    private long m_lastModified;
    private long m_size;
    private boolean m_unpack;
    private String m_version;
    private String m_versionType;
    private String m_fixedVersionSelector;
    private static final Pattern s_versionExp = Pattern.compile("^\\s*(.*?)([@/#][^@/#]*?)?(?:\\|(.+))?\\s*$");
    private static final Pattern s_numberExp = Pattern.compile("^#(\\d+)$");
    private static final Pattern s_tagExp = Pattern.compile("^/(.*)$");

    public ResolutionHandler(AbstractHandler parent) {
        super(parent);
    }

    public void childPopped(ChildHandler child) throws SAXException {
        if (child == this.m_componentRequestHandler) {
            this.m_request = this.m_componentRequestHandler.getBuilder().createComponentRequest();
        } else if (child == this.m_versionMatchHandler) {
            this.m_versionMatch = this.m_versionMatchHandler.getVersionMatch();
        }
    }

    public ChildHandler createHandler(String uri, String localName, Attributes attrs) throws SAXException {
        ExtensionAwareHandler ch = "request".equals(localName) ? this.m_componentRequestHandler : ("versionMatch".equals(localName) ? this.m_versionMatchHandler : super.createHandler(uri, localName, attrs));
        return ch;
    }

    public Resolution getResolution() throws SAXException {
        Provider provider;
        CSpec cspec;
        if (this.m_request == null) {
            throw new SAXParseException(NLS.bind((String)Messages.Missing_required_element_0, (Object)"md.request"), this.getDocumentLocator());
        }
        if (this.m_versionMatch == null) {
            if (this.m_version == null && this.m_fixedVersionSelector == null) {
                throw new SAXParseException(NLS.bind((String)Messages.Missing_required_element_0, (Object)"md.versionMatch"), this.getDocumentLocator());
            }
            this.m_versionMatch = this.legacyVersionMatch();
        }
        if (this.m_componentType == null) {
            this.m_componentType = this.legacyComponentType();
        }
        AbstractHandler parent = this.getParentHandler();
        OPML opml = null;
        if (parent instanceof IDWrapperHandler) {
            IDWrapperHandler wh = (IDWrapperHandler)parent;
            cspec = (CSpec)wh.getWrapped(this.m_cspecId);
            provider = (Provider)wh.getWrapped(this.m_providerId);
            if (this.m_opmlId != null) {
                opml = (OPML)wh.getWrapped(this.m_opmlId);
            }
        } else {
            try {
                StorageManager sm = StorageManager.getDefault();
                cspec = sm.getCSpecs().getElement(this.m_cspecId);
                provider = sm.getProviders().getElement(this.m_providerId);
                if (this.m_opmlId != null) {
                    opml = sm.getOPMLs().getElement(this.m_opmlId);
                }
            }
            catch (CoreException e) {
                throw new SAXParseException(e.getMessage(), this.getDocumentLocator(), (Exception)((Object)e));
            }
        }
        return new Resolution(cspec, opml, this.m_componentType, this.m_versionMatch, provider, this.m_materializable, this.m_request, this.m_attributes, this.m_persistentId, this.m_repository, this.m_remoteName, this.m_contentType, this.m_lastModified, this.m_size, this.m_unpack);
    }

    public void handleAttributes(Attributes attrs) throws SAXException {
        this.m_versionMatch = null;
        this.m_cspecId = UUID.fromString(this.getStringValue(attrs, "cspecId"));
        this.m_materializable = this.getBooleanValue(attrs, "materializable");
        this.m_providerId = UUID.fromString(this.getStringValue(attrs, "providerId"));
        String tmp = ResolutionHandler.getOptionalStringValue((Attributes)attrs, (String)"opmlId");
        this.m_opmlId = tmp == null ? null : UUID.fromString(tmp);
        this.m_componentType = ResolutionHandler.getOptionalStringValue((Attributes)attrs, (String)"componentType");
        this.m_persistentId = ResolutionHandler.getOptionalStringValue((Attributes)attrs, (String)"persistentId");
        this.m_repository = this.getStringValue(attrs, "repository");
        this.m_remoteName = ResolutionHandler.getOptionalStringValue((Attributes)attrs, (String)"remoteName");
        this.m_contentType = ResolutionHandler.getOptionalStringValue((Attributes)attrs, (String)"contentType");
        this.m_size = ResolutionHandler.getOptionalLongValue((Attributes)attrs, (String)"size", (long)-1L);
        this.m_lastModified = ResolutionHandler.getOptionalLongValue((Attributes)attrs, (String)"lastModified", (long)-1L);
        this.m_unpack = ResolutionHandler.getOptionalBooleanValue((Attributes)attrs, (String)"unpack", (boolean)false);
        this.m_request = null;
        this.m_attributes.clear();
        String attributes = ResolutionHandler.getOptionalStringValue((Attributes)attrs, (String)"attributes");
        if (attributes != null) {
            String[] stringArray = attributes.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String attr = stringArray[n2];
                if (!this.m_attributes.contains(attr)) {
                    this.m_attributes.add(attr);
                }
                ++n2;
            }
        }
        this.m_version = ResolutionHandler.getOptionalStringValue((Attributes)attrs, (String)"version");
        this.m_versionType = ResolutionHandler.getOptionalStringValue((Attributes)attrs, (String)"versionType");
        this.m_fixedVersionSelector = ResolutionHandler.getOptionalStringValue((Attributes)attrs, (String)"fixedVersionSelector");
    }

    private String legacyComponentType() throws SAXException {
        Provider provider;
        ICSpecData cspec;
        AbstractHandler parent = this.getParentHandler();
        if (parent instanceof IDWrapperHandler) {
            IDWrapperHandler wh = (IDWrapperHandler)parent;
            cspec = (ICSpecData)wh.getWrapped(this.m_cspecId);
            provider = (Provider)wh.getWrapped(this.m_providerId);
        } else {
            try {
                StorageManager sm = StorageManager.getDefault();
                cspec = sm.getCSpecs().getElement(this.m_cspecId);
                provider = sm.getProviders().getElement(this.m_providerId);
            }
            catch (CoreException e) {
                throw new SAXParseException(e.getMessage(), this.getDocumentLocator(), (Exception)((Object)e));
            }
        }
        String[] ctypeIDs = provider.getComponentTypeIDs();
        if (ctypeIDs.length == 1) {
            return ctypeIDs[0];
        }
        String ctype = cspec.getComponentIdentifier().getComponentTypeID();
        if (ctype != null) {
            return ctype;
        }
        if (ctypeIDs.length == 3 && ctypeIDs[0].equals("osgi.bundle") && ctypeIDs[1].equals("eclipse.feature") && ctypeIDs[2].equals("buckminster")) {
            return "buckminster";
        }
        return "unknown";
    }

    private VersionMatch legacyVersionMatch() throws SAXException {
        block11: {
            IVersion version = null;
            if (this.m_version != null) {
                try {
                    version = CorePlugin.getDefault().getVersionType(this.m_versionType).fromString(this.m_version);
                }
                catch (CoreException e) {
                    throw new SAXParseException(e.getMessage(), this.getDocumentLocator(), (Exception)((Object)e));
                }
            }
            if (this.m_fixedVersionSelector == null || this.m_fixedVersionSelector.length() == 0) {
                return new VersionMatch(version, null, -1L, null, null);
            }
            Matcher m = s_versionExp.matcher(this.m_fixedVersionSelector);
            if (m.matches()) {
                VersionSelector btag;
                String branch = m.group(1);
                if (branch.length() == 0 || "main".equals(branch)) {
                    branch = null;
                }
                String qualifier = m.group(2);
                String artifactType = m.group(3);
                VersionSelector versionSelector = btag = branch == null ? null : VersionSelector.branch(branch);
                if (qualifier == null) {
                    return new VersionMatch(version, btag, -1L, null, artifactType);
                }
                m = s_tagExp.matcher(qualifier);
                if (m.matches()) {
                    String tag = m.group(1);
                    if (tag != null && !"LATEST".equals(tag)) {
                        btag = VersionSelector.tag(tag);
                    }
                    return new VersionMatch(version, btag, -1L, null, artifactType);
                }
                try {
                    Date d = DateAndTimeUtils.fromISOFormat(qualifier.substring(1));
                    return new VersionMatch(version, btag, -1L, d, artifactType);
                }
                catch (ParseException parseException) {
                    m = s_numberExp.matcher(qualifier);
                    if (!m.matches()) break block11;
                    return new VersionMatch(version, btag, Long.parseLong(m.group(1)), null, artifactType);
                }
            }
        }
        throw new SAXParseException(NLS.bind((String)Messages.Unable_to_parse_legacy_version_selector_string_0, (Object)this.m_fixedVersionSelector), this.getDocumentLocator());
    }
}

