/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.metadata.parser;

import java.util.ArrayList;
import java.util.UUID;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.metadata.model.BOMNode;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.metadata.model.ResolvedNode;
import org.eclipse.buckminster.core.metadata.parser.BomNodeHandler;
import org.eclipse.buckminster.core.metadata.parser.ElementRefHandler;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.buckminster.sax.ChildHandler;
import org.eclipse.buckminster.sax.ChildPoppedListener;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class ResolvedNodeHandler
extends BomNodeHandler
implements ChildPoppedListener {
    public static final String TAG = "resolvedNode";
    private UUID m_resolutionId;
    private final ArrayList<UUID> m_children = new ArrayList();
    private final ElementRefHandler m_childHandler = new ElementRefHandler((AbstractHandler)this, "child");

    ResolvedNodeHandler(AbstractHandler parent) {
        super(parent);
    }

    public void childPopped(ChildHandler child) throws SAXParseException {
        if (child == this.m_childHandler) {
            this.m_children.add(this.m_childHandler.getRefId());
        }
    }

    public ChildHandler createHandler(String uri, String localName, Attributes attrs) throws SAXException {
        ElementRefHandler ch = this.m_childHandler.getTAG().equals(localName) ? this.m_childHandler : super.createHandler(uri, localName, attrs);
        return ch;
    }

    BOMNode getDepNode() throws SAXException {
        ArrayList<BOMNode> childNodes = new ArrayList<BOMNode>(this.m_children.size());
        for (UUID childId : this.m_children) {
            childNodes.add((BOMNode)this.getWrapped(childId));
        }
        try {
            return new ResolvedNode((Resolution)this.getWrapped(this.m_resolutionId), childNodes);
        }
        catch (ClassCastException e) {
            throw new SAXParseException(NLS.bind((String)Messages.Wrapper_0_does_not_wrap_resolution, (Object)this.m_resolutionId), this.getDocumentLocator());
        }
    }

    public void handleAttributes(Attributes attrs) throws SAXException {
        this.m_resolutionId = UUID.fromString(this.getStringValue(attrs, "resolutionId"));
        this.m_children.clear();
    }
}

